/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.nio.AbstractSelectionHandler;
import com.hazelcast.nio.CipherHelper;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.Packet;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.crypto.Cipher;

public final class WriteHandler
extends AbstractSelectionHandler
implements Runnable {
    private final Queue<Packet> writeQueue = new ConcurrentLinkedQueue<Packet>();
    private final AtomicBoolean informSelector = new AtomicBoolean(true);
    private final ByteBuffer socketBB = ByteBuffer.allocateDirect(32768);
    private boolean ready = false;
    private Packet lastPacket = null;
    private final PacketWriter packetWriter;

    WriteHandler(Connection connection) {
        super(connection);
        boolean symmetricEncryptionEnabled = CipherHelper.isSymmetricEncryptionEnabled(this.node);
        boolean asymmetricEncryptionEnabled = CipherHelper.isAsymmetricEncryptionEnabled(this.node);
        if (asymmetricEncryptionEnabled || symmetricEncryptionEnabled) {
            if (asymmetricEncryptionEnabled && symmetricEncryptionEnabled) {
                this.logger.log(Level.INFO, "Incorrect encryption configuration.");
                this.logger.log(Level.INFO, "You can enable either SymmetricEncryption or AsymmetricEncryption.");
                throw new RuntimeException();
            }
            if (symmetricEncryptionEnabled) {
                this.packetWriter = new SymmetricCipherPacketWriter();
                this.logger.log(Level.INFO, "Writer started with SymmetricEncryption");
            } else {
                this.packetWriter = new AsymmetricCipherPacketWriter();
                this.logger.log(Level.INFO, "Writer started with AsymmetricEncryption");
            }
        } else {
            this.packetWriter = new DefaultPacketWriter();
        }
    }

    public void enqueuePacket(Packet packet) {
        packet.write();
        this.writeQueue.offer(packet);
        if (this.informSelector.compareAndSet(true, false)) {
            this.outSelector.addTask(this);
            this.outSelector.selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle() {
        if (this.lastPacket == null) {
            this.lastPacket = this.writeQueue.poll();
            if (this.lastPacket == null && this.socketBB.position() == 0) {
                this.ready = true;
                return;
            }
        }
        if (!this.connection.live()) {
            return;
        }
        try {
            while (this.socketBB.hasRemaining()) {
                if (this.lastPacket == null) {
                    this.lastPacket = this.writeQueue.poll();
                }
                if (this.lastPacket == null) break;
                boolean packetDone = this.packetWriter.writePacket(this.lastPacket);
                if (packetDone) {
                    this.node.getPacketPool().release(this.lastPacket);
                    this.lastPacket = null;
                    continue;
                }
                if (!this.socketBB.hasRemaining()) continue;
                break;
            }
            this.socketBB.flip();
            try {
                int written = this.socketChannel.write(this.socketBB);
            }
            catch (Exception e) {
                if (this.lastPacket != null) {
                    this.node.getPacketPool().release(this.lastPacket);
                    this.lastPacket = null;
                }
                this.handleSocketException(e);
                this.ready = false;
                this.registerWrite();
                return;
            }
            if (this.socketBB.hasRemaining()) {
                this.socketBB.compact();
            } else {
                this.socketBB.clear();
            }
        }
        catch (Throwable t) {
            this.logger.log(Level.SEVERE, "Fatal Error at WriteHandler for endPoint: " + this.connection.getEndPoint(), t);
            t.printStackTrace();
        }
        finally {
            this.ready = false;
            this.registerWrite();
        }
    }

    public void run() {
        this.informSelector.set(true);
        if (this.ready) {
            this.handle();
        } else {
            this.registerWrite();
        }
        this.ready = false;
    }

    private void registerWrite() {
        this.registerOp(this.outSelector.selector, 4);
    }

    public void shutdown() {
        this.writeQueue.clear();
    }

    class SymmetricCipherPacketWriter
    implements PacketWriter {
        boolean sizeWritten = false;
        final ByteBuffer cipherBuffer = ByteBuffer.allocate(32768);
        final Cipher cipher;

        SymmetricCipherPacketWriter() {
            Cipher c = null;
            try {
                c = CipherHelper.createSymmetricWriterCipher(WriteHandler.this.node);
            }
            catch (Exception e) {
                WriteHandler.this.logger.log(Level.SEVERE, "Symmetric Cipher for WriteHandler cannot be initialized.", e);
                CipherHelper.handleCipherException(e, WriteHandler.this.connection);
            }
            this.cipher = c;
        }

        public boolean writePacket(Packet packet) throws Exception {
            boolean complete;
            if (this.cipherBuffer.position() > 0 && WriteHandler.this.socketBB.hasRemaining()) {
                this.cipherBuffer.flip();
                IOUtil.copyToDirectBuffer(this.cipherBuffer, WriteHandler.this.socketBB);
                if (this.cipherBuffer.hasRemaining()) {
                    this.cipherBuffer.compact();
                } else {
                    this.cipherBuffer.clear();
                }
            }
            if (!this.sizeWritten) {
                int cipherSize = this.cipher.getOutputSize(packet.totalSize);
                WriteHandler.this.socketBB.putInt(cipherSize);
                this.sizeWritten = true;
            }
            packet.totalWritten += this.encryptAndWriteToSocket(packet.bbSizes);
            packet.totalWritten += this.encryptAndWriteToSocket(packet.bbHeader);
            if (packet.getKey() != null && packet.getKey().size() > 0 && WriteHandler.this.socketBB.hasRemaining()) {
                packet.totalWritten += this.encryptAndWriteToSocket(packet.getKey().buffer);
            }
            if (packet.getValue() != null && packet.getValue().size() > 0 && WriteHandler.this.socketBB.hasRemaining()) {
                packet.totalWritten += this.encryptAndWriteToSocket(packet.getValue().buffer);
            }
            boolean bl = complete = packet.totalWritten >= packet.totalSize;
            if (complete) {
                if (WriteHandler.this.socketBB.remaining() >= this.cipher.getOutputSize(0)) {
                    this.sizeWritten = false;
                    WriteHandler.this.socketBB.put(this.cipher.doFinal());
                } else {
                    return false;
                }
            }
            return complete;
        }

        private int encryptAndWriteToSocket(ByteBuffer src) throws Exception {
            int remaining = src.remaining();
            if (src.hasRemaining() && this.cipherBuffer.hasRemaining()) {
                int outputSize = this.cipher.getOutputSize(src.remaining());
                if (outputSize <= this.cipherBuffer.remaining()) {
                    this.cipher.update(src, this.cipherBuffer);
                } else {
                    int min = Math.min(src.remaining(), this.cipherBuffer.remaining());
                    int len = min / 2;
                    if (len > 0) {
                        int limitOld = src.limit();
                        src.limit(src.position() + len);
                        this.cipher.update(src, this.cipherBuffer);
                        src.limit(limitOld);
                    } else {
                        return 0;
                    }
                }
                this.cipherBuffer.flip();
                IOUtil.copyToDirectBuffer(this.cipherBuffer, WriteHandler.this.socketBB);
                if (this.cipherBuffer.hasRemaining()) {
                    this.cipherBuffer.compact();
                } else {
                    this.cipherBuffer.clear();
                }
                return remaining - src.remaining();
            }
            return 0;
        }
    }

    class AsymmetricCipherPacketWriter
    implements PacketWriter {
        final ByteBuffer cipherBuffer = ByteBuffer.allocate(65536);
        final Cipher cipher;
        final int writeBlockSize;
        boolean aliasWritten = false;

        AsymmetricCipherPacketWriter() {
            Cipher c = null;
            try {
                c = CipherHelper.createAsymmetricWriterCipher(WriteHandler.this.node);
            }
            catch (Exception e) {
                WriteHandler.this.logger.log(Level.SEVERE, "Asymmetric Cipher for WriteHandler cannot be initialized.", e);
                this.cipher = null;
                this.writeBlockSize = 0;
                CipherHelper.handleCipherException(e, WriteHandler.this.connection);
                return;
            }
            this.cipher = c;
            this.writeBlockSize = this.cipher.getBlockSize();
        }

        public boolean writePacket(Packet packet) throws Exception {
            boolean complete;
            if (!this.aliasWritten) {
                String localAlias = CipherHelper.getKeyAlias(WriteHandler.this.node);
                byte[] localAliasBytes = localAlias.getBytes();
                WriteHandler.this.socketBB.putInt(localAliasBytes.length);
                WriteHandler.this.socketBB.put(localAliasBytes);
                this.aliasWritten = true;
            }
            if (complete = this.encryptAndWrite(packet)) {
                this.aliasWritten = false;
            }
            return complete;
        }

        public final boolean encryptAndWrite(Packet packet) throws Exception {
            if (this.cipherBuffer.position() > 0 && WriteHandler.this.socketBB.hasRemaining()) {
                this.cipherBuffer.flip();
                IOUtil.copyToDirectBuffer(this.cipherBuffer, WriteHandler.this.socketBB);
                if (this.cipherBuffer.hasRemaining()) {
                    this.cipherBuffer.compact();
                } else {
                    this.cipherBuffer.clear();
                }
            }
            packet.totalWritten += this.encryptAndWriteToSocket(packet.bbSizes);
            packet.totalWritten += this.encryptAndWriteToSocket(packet.bbHeader);
            if (packet.getKey() != null && packet.getKey().size() > 0 && WriteHandler.this.socketBB.hasRemaining()) {
                packet.totalWritten += this.encryptAndWriteToSocket(packet.getKey().buffer);
            }
            if (packet.getValue() != null && packet.getValue().size() > 0 && WriteHandler.this.socketBB.hasRemaining()) {
                packet.totalWritten += this.encryptAndWriteToSocket(packet.getValue().buffer);
            }
            return packet.totalWritten >= packet.totalSize;
        }

        private int encryptAndWriteToSocket(ByteBuffer src) throws Exception {
            int remaining = src.remaining();
            if (src.hasRemaining()) {
                this.doCipherUpdate(src);
                this.cipherBuffer.flip();
                IOUtil.copyToDirectBuffer(this.cipherBuffer, WriteHandler.this.socketBB);
                if (this.cipherBuffer.hasRemaining()) {
                    this.cipherBuffer.compact();
                } else {
                    this.cipherBuffer.clear();
                }
                return remaining - src.remaining();
            }
            return 0;
        }

        private void doCipherUpdate(ByteBuffer src) throws Exception {
            while (src.hasRemaining()) {
                int remaining = src.remaining();
                if (remaining > this.writeBlockSize) {
                    int oldLimit = src.limit();
                    src.limit(src.position() + this.writeBlockSize);
                    int outputAppendSize = this.cipher.doFinal(src, this.cipherBuffer);
                    src.limit(oldLimit);
                    continue;
                }
                int n = this.cipher.doFinal(src, this.cipherBuffer);
            }
        }
    }

    class ComplexCipherPacketWriter
    implements PacketWriter {
        boolean joinPartDone = false;
        AsymmetricCipherPacketWriter apw = new AsymmetricCipherPacketWriter();
        SymmetricCipherPacketWriter spw = new SymmetricCipherPacketWriter();
        int joinPartTotalWrites = 0;
        final int maxJoinWrite;

        ComplexCipherPacketWriter() {
            this.maxJoinWrite = 2280;
        }

        public boolean writePacket(Packet packet) throws Exception {
            boolean result = false;
            if (!this.joinPartDone) {
                int left = this.maxJoinWrite - this.joinPartTotalWrites;
                if (WriteHandler.this.socketBB.remaining() > left) {
                    WriteHandler.this.socketBB.limit(WriteHandler.this.socketBB.position() + left);
                }
                int currentPosition = WriteHandler.this.socketBB.position();
                result = this.apw.writePacket(packet);
                this.joinPartTotalWrites += WriteHandler.this.socketBB.position() - currentPosition;
                WriteHandler.this.socketBB.limit(WriteHandler.this.socketBB.capacity());
                if (this.joinPartTotalWrites == this.maxJoinWrite) {
                    this.joinPartDone = true;
                    this.apw = null;
                    this.writePacket(packet);
                }
            } else {
                result = this.spw.writePacket(packet);
            }
            return result;
        }
    }

    class DefaultPacketWriter
    implements PacketWriter {
        DefaultPacketWriter() {
        }

        public boolean writePacket(Packet packet) {
            return packet.writeToSocketBuffer(WriteHandler.this.socketBB);
        }
    }

    static interface PacketWriter {
        public boolean writePacket(Packet var1) throws Exception;
    }
}

