/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.nio.AbstractSelectionHandler;
import com.hazelcast.nio.CipherHelper;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.Packet;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import javax.crypto.Cipher;
import javax.crypto.ShortBufferException;

class ReadHandler
extends AbstractSelectionHandler
implements Runnable {
    final ByteBuffer inBuffer = ByteBuffer.allocate(32768);
    Packet packet = null;
    final PacketReader packetReader;

    public ReadHandler(Connection connection) {
        super(connection);
        boolean symmetricEncryptionEnabled = CipherHelper.isSymmetricEncryptionEnabled(this.node);
        boolean asymmetricEncryptionEnabled = CipherHelper.isAsymmetricEncryptionEnabled(this.node);
        if (asymmetricEncryptionEnabled || symmetricEncryptionEnabled) {
            if (asymmetricEncryptionEnabled && symmetricEncryptionEnabled) {
                this.logger.log(Level.INFO, "Incorrect encryption configuration.");
                this.logger.log(Level.INFO, "You can enable either SymmetricEncryption or AsymmetricEncryption.");
                throw new RuntimeException();
            }
            if (symmetricEncryptionEnabled) {
                this.packetReader = new SymmetricCipherPacketReader();
                this.logger.log(Level.INFO, "Reader started with SymmetricEncryption");
            } else {
                this.packetReader = new AsymmetricCipherPacketReader();
                this.logger.log(Level.INFO, "Reader started with AsymmetricEncryption");
            }
        } else {
            this.packetReader = new DefaultPacketReader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handle() {
        if (!this.connection.live()) {
            this.logger.log(Level.FINEST, ">>>> We are being to asked to read, but connection is not live so we won't");
            return;
        }
        try {
            int readBytes = this.socketChannel.read(this.inBuffer);
            if (readBytes == -1) {
                this.connection.close();
                return;
            }
        }
        catch (Exception e) {
            if (this.packet != null) {
                this.node.getPacketPool().release(this.packet);
                this.packet = null;
            }
            this.handleSocketException(e);
            return;
        }
        try {
            if (this.inBuffer.position() == 0) {
                return;
            }
            this.inBuffer.flip();
            this.packetReader.readPacket();
            if (this.inBuffer.hasRemaining()) {
                this.inBuffer.compact();
            } else {
                this.inBuffer.clear();
            }
        }
        catch (Exception t) {
            t.printStackTrace();
            this.handleSocketException(t);
        }
        finally {
            this.registerOp(this.inSelector.selector, 1);
        }
    }

    public void enqueueFullPacket(Packet p) {
        p.flipBuffers();
        p.read();
        p.setFromConnection(this.connection);
        if (p.client) {
            this.node.clientService.handle(p);
        } else {
            this.clusterService.enqueuePacket(p);
        }
    }

    public final void run() {
        this.registerOp(this.inSelector.selector, 1);
    }

    public Packet obtainReadable() {
        return this.node.getPacketPool().obtain();
    }

    class SymmetricCipherPacketReader
    implements PacketReader {
        int size = -1;
        final Cipher cipher;
        ByteBuffer cipherBuffer = ByteBuffer.allocate(65536);

        SymmetricCipherPacketReader() {
            this.cipher = this.init();
        }

        Cipher init() {
            Cipher c = null;
            try {
                c = CipherHelper.createSymmetricReaderCipher(ReadHandler.this.node);
            }
            catch (Exception e) {
                ReadHandler.this.logger.log(Level.SEVERE, "Symmetric Cipher for ReadHandler cannot be initialized.", e);
            }
            return c;
        }

        public void readPacket() throws Exception {
            while (ReadHandler.this.inBuffer.hasRemaining()) {
                try {
                    int remaining;
                    if (this.size == -1) {
                        if (ReadHandler.this.inBuffer.remaining() < 4) {
                            return;
                        }
                        this.size = ReadHandler.this.inBuffer.getInt();
                    }
                    if ((remaining = ReadHandler.this.inBuffer.remaining()) < this.size) {
                        this.cipher.update(ReadHandler.this.inBuffer, this.cipherBuffer);
                        this.size -= remaining;
                    } else if (remaining == this.size) {
                        this.cipher.doFinal(ReadHandler.this.inBuffer, this.cipherBuffer);
                        this.size = -1;
                    } else {
                        int oldLimit = ReadHandler.this.inBuffer.limit();
                        int newLimit = ReadHandler.this.inBuffer.position() + this.size;
                        ReadHandler.this.inBuffer.limit(newLimit);
                        this.cipher.doFinal(ReadHandler.this.inBuffer, this.cipherBuffer);
                        ReadHandler.this.inBuffer.limit(oldLimit);
                        this.size = -1;
                    }
                }
                catch (ShortBufferException e) {
                    e.printStackTrace();
                }
                this.cipherBuffer.flip();
                while (this.cipherBuffer.hasRemaining()) {
                    boolean complete;
                    if (ReadHandler.this.packet == null) {
                        ReadHandler.this.packet = ReadHandler.this.obtainReadable();
                    }
                    if (!(complete = ReadHandler.this.packet.read(this.cipherBuffer))) continue;
                    ReadHandler.this.enqueueFullPacket(ReadHandler.this.packet);
                    ReadHandler.this.packet = null;
                }
                this.cipherBuffer.clear();
            }
        }
    }

    class AsymmetricCipherPacketReader
    implements PacketReader {
        Cipher cipher = null;
        ByteBuffer cipherBuffer = ByteBuffer.allocate(128);
        ByteBuffer bbAlias = null;
        boolean aliasSizeSet = false;

        AsymmetricCipherPacketReader() {
        }

        public void readPacket() throws Exception {
            if (this.cipher == null) {
                if (!this.aliasSizeSet) {
                    if (ReadHandler.this.inBuffer.remaining() < 4) {
                        return;
                    }
                    int aliasSize = ReadHandler.this.inBuffer.getInt();
                    this.bbAlias = ByteBuffer.allocate(aliasSize);
                }
                IOUtil.copyToHeapBuffer(ReadHandler.this.inBuffer, this.bbAlias);
                if (!this.bbAlias.hasRemaining()) {
                    this.bbAlias.flip();
                    String remoteAlias = new String(this.bbAlias.array(), 0, this.bbAlias.limit());
                    this.cipher = CipherHelper.createAsymmetricReaderCipher(ReadHandler.this.node, remoteAlias);
                }
            }
            while (ReadHandler.this.inBuffer.remaining() >= 128) {
                if (this.cipherBuffer.position() > 0) {
                    throw new RuntimeException();
                }
                int oldLimit = ReadHandler.this.inBuffer.limit();
                ReadHandler.this.inBuffer.limit(ReadHandler.this.inBuffer.position() + 128);
                int cipherReadSize = this.cipher.doFinal(ReadHandler.this.inBuffer, this.cipherBuffer);
                ReadHandler.this.inBuffer.limit(oldLimit);
                this.cipherBuffer.flip();
                while (this.cipherBuffer.hasRemaining()) {
                    boolean complete;
                    if (ReadHandler.this.packet == null) {
                        ReadHandler.this.packet = ReadHandler.this.obtainReadable();
                    }
                    if (!(complete = ReadHandler.this.packet.read(this.cipherBuffer))) continue;
                    ReadHandler.this.enqueueFullPacket(ReadHandler.this.packet);
                    ReadHandler.this.packet = null;
                }
                this.cipherBuffer.clear();
            }
        }
    }

    class ComplexCipherPacketReader
    implements PacketReader {
        ComplexCipherPacketReader() {
        }

        public void readPacket() throws Exception {
        }
    }

    class DefaultPacketReader
    implements PacketReader {
        DefaultPacketReader() {
        }

        public void readPacket() {
            while (ReadHandler.this.inBuffer.hasRemaining()) {
                boolean complete;
                if (ReadHandler.this.packet == null) {
                    ReadHandler.this.packet = ReadHandler.this.obtainReadable();
                }
                if (!(complete = ReadHandler.this.packet.read(ReadHandler.this.inBuffer))) continue;
                ReadHandler.this.enqueueFullPacket(ReadHandler.this.packet);
                ReadHandler.this.packet = null;
            }
        }
    }

    static interface PacketReader {
        public void readPacket() throws Exception;
    }
}

