/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.impl.ThreadContext;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.DataHolder;
import java.nio.ByteBuffer;

public final class IOUtil {
    public static int copyToHeapBuffer(ByteBuffer src, ByteBuffer dest) {
        int n = Math.min(src.remaining(), dest.remaining());
        if (n > 0) {
            int srcPosition = src.position();
            int destPosition = dest.position();
            int ixSrc = srcPosition + src.arrayOffset();
            int ixDest = destPosition + dest.arrayOffset();
            System.arraycopy(src.array(), ixSrc, dest.array(), ixDest, n);
            src.position(srcPosition + n);
            dest.position(destPosition + n);
        }
        return n;
    }

    public static int copyToDirectBuffer(ByteBuffer src, ByteBuffer dest) {
        int n = Math.min(src.remaining(), dest.remaining());
        if (n > 0) {
            dest.put(src.array(), src.position(), n);
            src.position(src.position() + n);
        }
        return n;
    }

    public static void putBoolean(ByteBuffer bb, boolean value) {
        bb.put((byte)(value ? 1 : 0));
    }

    public static boolean getBoolean(ByteBuffer bb) {
        return bb.get() == 1;
    }

    public static Data toData(Object obj) {
        return ThreadContext.get().toData(obj);
    }

    public static Data addDelta(Data longData, long delta) {
        byte[] b = longData.buffer;
        ByteBuffer current = ByteBuffer.wrap(b);
        byte type = current.get();
        long value = current.getLong();
        ByteBuffer newLong = ByteBuffer.allocate(b.length);
        newLong.put(type);
        newLong.putLong(value += delta);
        return new Data(newLong.array());
    }

    public static Object toObject(Data data) {
        return ThreadContext.get().toObject(data);
    }

    public static Object toObject(DataHolder dataHolder) {
        return IOUtil.toObject(dataHolder.toData());
    }
}

