/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.cluster.AddOrRemoveConnection;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.nio.ReadHandler;
import com.hazelcast.nio.WriteHandler;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;

public class Connection {
    final SocketChannel socketChannel;
    final ReadHandler readHandler;
    final WriteHandler writeHandler;
    final ConnectionManager connectionManager;
    private volatile boolean live = true;
    Address endPoint = null;
    private final ILogger logger;

    public Connection(ConnectionManager connectionManager, SocketChannel socketChannel) {
        this.logger = connectionManager.node.getLogger(Connection.class.getName());
        this.connectionManager = connectionManager;
        this.socketChannel = socketChannel;
        this.writeHandler = new WriteHandler(this);
        this.readHandler = new ReadHandler(this);
    }

    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    public ReadHandler getReadHandler() {
        return this.readHandler;
    }

    public WriteHandler getWriteHandler() {
        return this.writeHandler;
    }

    public void setLive(boolean live) {
        this.live = live;
    }

    public boolean live() {
        return this.live;
    }

    public Address getEndPoint() {
        return this.endPoint;
    }

    public void setEndPoint(Address endPoint) {
        this.endPoint = endPoint;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.endPoint == null ? 0 : this.endPoint.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Connection other = (Connection)obj;
        return !(this.endPoint == null ? other.endPoint != null : !this.endPoint.equals(other.endPoint));
    }

    public void close() {
        if (!this.live) {
            return;
        }
        this.live = false;
        try {
            if (this.socketChannel != null && this.socketChannel.isOpen()) {
                this.socketChannel.close();
            }
            this.readHandler.shutdown();
            this.writeHandler.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.logger.log(Level.FINE, "Connection lost " + this.endPoint);
        this.connectionManager.remove(this);
        AddOrRemoveConnection addOrRemoveConnection = new AddOrRemoveConnection(this.endPoint, false);
        addOrRemoveConnection.setNode(this.connectionManager.node);
        this.connectionManager.node.clusterManager.enqueueAndReturn(addOrRemoveConnection);
    }

    public String toString() {
        return "Connection [" + this.endPoint + "] live=" + this.live;
    }
}

