/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.impl.BaseManager;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.Processable;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Data;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class TopicManager
extends BaseManager {
    Map<String, TopicInstance> mapTopics = new HashMap<String, TopicInstance>();

    TopicManager(Node node) {
        super(node);
    }

    public TopicInstance getTopicInstance(String name) {
        TopicInstance ti = this.mapTopics.get(name);
        if (ti == null) {
            ti = new TopicInstance(this, name);
            this.mapTopics.put(name, ti);
        }
        return ti;
    }

    public void syncForDead(Address deadAddress) {
        Collection<TopicInstance> instances = this.mapTopics.values();
        for (TopicInstance instance : instances) {
            instance.removeListener(deadAddress);
        }
    }

    public void syncForAdd() {
    }

    void handleListenerRegistrations(boolean add, String name, Data key, Address address, boolean includeValue) {
        TopicInstance instance = this.getTopicInstance(name);
        if (add) {
            instance.addListener(address, includeValue);
        } else {
            instance.removeListener(address);
        }
    }

    void destroy(String name) {
        TopicInstance instance = this.mapTopics.remove(name);
        if (instance != null) {
            instance.mapListeners.clear();
        }
    }

    void doPublish(String name, Object msg) {
        Data dataMsg = null;
        try {
            dataMsg = ThreadContext.get().toData(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.enqueueAndReturn(new TopicPublishProcess(name, dataMsg));
    }

    public final class TopicInstance {
        private final TopicManager topicManager;
        private final String name;
        private final Map<Address, Boolean> mapListeners = new HashMap<Address, Boolean>();

        public TopicInstance(TopicManager topicManager2, String name) {
            if (topicManager2 == null) {
                throw new NullPointerException("topic manager cannot be null");
            }
            if (name == null) {
                throw new NullPointerException("topic name cannot be null");
            }
            this.topicManager = topicManager2;
            this.name = name;
        }

        public void addListener(Address address, boolean includeValue) {
            this.mapListeners.put(address, includeValue);
        }

        public void removeListener(Address address) {
            this.mapListeners.remove(address);
        }

        public void publish(Data msg) {
            this.topicManager.fireMapEvent(this.mapListeners, this.name, EntryEvent.TYPE_ADDED, msg);
        }
    }

    class TopicPublishProcess
    implements Processable {
        final Data dataMsg;
        final String name;

        public TopicPublishProcess(String name, Data dataMsg) {
            this.dataMsg = dataMsg;
            this.name = name;
        }

        public void process() {
            TopicManager.this.getTopicInstance(this.name).publish(this.dataMsg);
        }
    }
}

