/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.impl.Constants;
import com.hazelcast.impl.LocalMapStatsImpl;
import com.hazelcast.impl.Record;
import com.hazelcast.impl.RecordEntry;
import com.hazelcast.nio.IOUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

class LocallyOwnedMap {
    private final ConcurrentMap<Object, Record> mapCache = new ConcurrentHashMap<Object, Record>(10000);
    private final Queue<Record> localRecords = new ConcurrentLinkedQueue<Record>();
    private final AtomicInteger counter = new AtomicInteger();
    private final LocalMapStatsImpl localMapStats;
    private final int LOCAL_INVALIDATION_COUNTER = 100000;
    private long lastEvictionTime = 0L;

    LocallyOwnedMap(LocalMapStatsImpl localMapStats) {
        this.localMapStats = localMapStats;
    }

    public Object get(Object key) {
        RecordEntry recordEntry;
        Object value;
        Record record;
        this.processLocalRecords();
        if (this.counter.incrementAndGet() == 100000) {
            this.counter.addAndGet(-100000);
            this.evict(System.currentTimeMillis());
        }
        if ((record = (Record)this.mapCache.get(key)) == null) {
            return Constants.Objects.OBJECT_REDO;
        }
        if (record.isActive() && record.isValid() && (value = (recordEntry = record.getRecordEntry()).getValue()) != null) {
            record.setLastAccessed();
            this.localMapStats.incrementHit();
            return value;
        }
        this.mapCache.remove(key);
        return Constants.Objects.OBJECT_REDO;
    }

    public void evict(long now) {
        if (now - this.lastEvictionTime > 10000L) {
            this.lastEvictionTime = now;
            Set entries = this.mapCache.entrySet();
            ArrayList lsKeysToRemove = new ArrayList();
            for (Map.Entry entry : entries) {
                Object key = entry.getKey();
                Record record = (Record)entry.getValue();
                if (record.isActive() && record.isValid(now)) continue;
                lsKeysToRemove.add(key);
            }
            for (Map.Entry key : lsKeysToRemove) {
                this.mapCache.remove(key);
            }
        }
    }

    public void reset() {
        this.localRecords.clear();
        this.mapCache.clear();
    }

    private void processLocalRecords() {
        Record record = this.localRecords.poll();
        while (record != null) {
            if (record.isActive()) {
                this.doPut(record);
            }
            record = this.localRecords.poll();
        }
    }

    public void doPut(Record record) {
        Object key = IOUtil.toObject(record.getKey());
        this.mapCache.put(key, record);
    }

    public void offerToCache(Record record) {
        this.localRecords.offer(record);
    }

    public void appendState(StringBuffer sbState) {
        sbState.append(", l.cache:");
        sbState.append(this.mapCache.size());
        sbState.append(", l.records:");
        sbState.append(this.localRecords.size());
    }
}

