/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.impl.Record;
import com.hazelcast.monitor.LocalMapOperationStats;
import com.hazelcast.monitor.LocalMapStats;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;

public class LocalMapStatsImpl
implements LocalMapStats,
Serializable {
    private final AtomicLong lastAccessTime = new AtomicLong();
    private final AtomicLong hits = new AtomicLong();
    private long ownedEntryCount;
    private long backupEntryCount;
    private long markedAsRemovedEntryCount;
    private long ownedEntryMemoryCost;
    private long backupEntryMemoryCost;
    private long markedAsRemovedMemoryCost;
    private long creationTime;
    private long lastUpdateTime;
    private long lastEvictionTime;
    private long lockedEntryCount;
    private long lockWaitCount;
    private LocalMapOperationStats operationStats;

    public void incrementHit() {
        this.hits.incrementAndGet();
        this.lastAccessTime.set(System.currentTimeMillis());
    }

    public void update(Op op, Record record, boolean owned, long updateCost) {
        if (owned) {
            if (op == Op.READ) {
                this.hits.incrementAndGet();
            } else if (op == Op.UPDATE) {
                this.lastUpdateTime = System.currentTimeMillis();
                this.ownedEntryMemoryCost += updateCost;
            } else if (op == Op.CREATE) {
                ++this.ownedEntryCount;
                this.ownedEntryMemoryCost += record.getCost();
            } else if (op == Op.REMOVE) {
                --this.ownedEntryCount;
                this.ownedEntryMemoryCost -= record.getCost();
            } else if (op == Op.LOCK) {
                ++this.lockedEntryCount;
            } else if (op == Op.UNLOCK) {
                --this.lockedEntryCount;
            } else if (op == Op.ADD_LOCK_WAIT) {
                ++this.lockWaitCount;
            } else if (op == Op.REMOVE_LOCK_WAIT) {
                --this.lockWaitCount;
            }
        } else if (op == Op.CREATE) {
            ++this.backupEntryCount;
            this.backupEntryMemoryCost += record.getCost();
        } else if (op == Op.UPDATE) {
            this.backupEntryMemoryCost += updateCost;
        } else if (op == Op.REMOVE) {
            --this.backupEntryCount;
            this.backupEntryMemoryCost -= record.getCost();
        }
    }

    public long getOwnedEntryCount() {
        return this.ownedEntryCount;
    }

    public void setOwnedEntryCount(long ownedEntryCount) {
        this.ownedEntryCount = ownedEntryCount;
    }

    public long getBackupEntryCount() {
        return this.backupEntryCount;
    }

    public void setBackupEntryCount(long backupEntryCount) {
        this.backupEntryCount = backupEntryCount;
    }

    public long getMarkedAsRemovedEntryCount() {
        return this.markedAsRemovedEntryCount;
    }

    public void setMarkedAsRemovedEntryCount(long markedAsRemovedEntryCount) {
        this.markedAsRemovedEntryCount = markedAsRemovedEntryCount;
    }

    public long getOwnedEntryMemoryCost() {
        return this.ownedEntryMemoryCost;
    }

    public void setOwnedEntryMemoryCost(long ownedEntryMemoryCost) {
        this.ownedEntryMemoryCost = ownedEntryMemoryCost;
    }

    public long getBackupEntryMemoryCost() {
        return this.backupEntryMemoryCost;
    }

    public void setBackupEntryMemoryCost(long backupEntryMemoryCost) {
        this.backupEntryMemoryCost = backupEntryMemoryCost;
    }

    public long getMarkedAsRemovedMemoryCost() {
        return this.markedAsRemovedMemoryCost;
    }

    public void setMarkedAsRemovedMemoryCost(long markedAsRemovedMemoryCost) {
        this.markedAsRemovedMemoryCost = markedAsRemovedMemoryCost;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime.get();
    }

    public void setLastAccessTime(long lastAccessTime) {
        this.lastAccessTime.set(Math.max(this.lastAccessTime.get(), lastAccessTime));
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = Math.max(this.lastUpdateTime, lastUpdateTime);
    }

    public long getLastEvictionTime() {
        return this.lastEvictionTime;
    }

    public void setLastEvictionTime(long lastEvictionTime) {
        this.lastEvictionTime = lastEvictionTime;
    }

    public long getHits() {
        return this.hits.get();
    }

    public void setHits(long hits) {
        this.hits.set(hits);
    }

    public long getLockedEntryCount() {
        return this.lockedEntryCount;
    }

    public void setLockedEntryCount(long lockedEntryCount) {
        this.lockedEntryCount = lockedEntryCount;
    }

    public long getLockWaitCount() {
        return this.lockWaitCount;
    }

    public void setLockWaitCount(long lockWaitCount) {
        this.lockWaitCount = lockWaitCount;
    }

    public LocalMapOperationStats getOperationStats() {
        return this.operationStats;
    }

    public void setOperationStats(LocalMapOperationStats operationStats) {
        this.operationStats = operationStats;
    }

    public String toString() {
        return "LocalMapStatsImpl{ownedEntryCount=" + this.ownedEntryCount + ", backupEntryCount=" + this.backupEntryCount + ", markedAsRemovedEntryCount=" + this.markedAsRemovedEntryCount + ", ownedEntryMemoryCost=" + this.ownedEntryMemoryCost + ", backupEntryMemoryCost=" + this.backupEntryMemoryCost + ", markedAsRemovedMemoryCost=" + this.markedAsRemovedMemoryCost + ", creationTime=" + this.creationTime + ", lastAccessTime=" + this.lastAccessTime.get() + ", lastUpdateTime=" + this.lastUpdateTime + ", lastEvictionTime=" + this.lastEvictionTime + ", hits=" + this.hits.get() + ", lockedEntryCount=" + this.lockedEntryCount + ", lockWaitCount=" + this.lockWaitCount + ", " + this.operationStats + '}';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Op {
        CREATE,
        READ,
        UPDATE,
        REMOVE,
        LOCK,
        UNLOCK,
        ADD_LOCK_WAIT,
        REMOVE_LOCK_WAIT;

    }
}

