/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.impl.CallContext;
import com.hazelcast.impl.ClientService;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.nio.Packet;
import java.util.logging.Logger;

public class ClientRequestHandler
implements Runnable {
    private final Packet packet;
    private final CallContext callContext;
    private final Node node;
    Logger logger = Logger.getLogger(this.getClass().getName());
    private final ClientService.ClientOperationHandler[] clientOperationHandlers;

    public ClientRequestHandler(Node node, Packet packet, CallContext callContext, ClientService.ClientOperationHandler[] clientOperationHandlers) {
        this.packet = packet;
        this.callContext = callContext;
        this.node = node;
        this.clientOperationHandlers = clientOperationHandlers;
    }

    public void run() {
        ThreadContext.get().setCallContext(this.callContext);
        ClientService.ClientOperationHandler clientOperationHandler = this.clientOperationHandlers[this.packet.operation.getValue()];
        if (clientOperationHandler != null) {
            clientOperationHandler.handle(this.node, this.packet);
            return;
        }
        throw new RuntimeException("Unknown Client Operation, can not handle " + (Object)((Object)this.packet.operation));
    }
}

