/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.cluster.ClusterImpl;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.Instance;
import com.hazelcast.core.MapEntry;
import com.hazelcast.core.MapLoader;
import com.hazelcast.core.MapStore;
import com.hazelcast.core.Member;
import com.hazelcast.impl.Block;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.Constants;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.LocalMapStatsImpl;
import com.hazelcast.impl.LocallyOwnedMap;
import com.hazelcast.impl.MProxy;
import com.hazelcast.impl.MapNearCache;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.PartitionServiceImpl;
import com.hazelcast.impl.Processable;
import com.hazelcast.impl.Record;
import com.hazelcast.impl.RecordEntry;
import com.hazelcast.impl.Request;
import com.hazelcast.impl.VersionedBackupOp;
import com.hazelcast.impl.base.DistributedLock;
import com.hazelcast.impl.base.ScheduledAction;
import com.hazelcast.impl.concurrentmap.LFUMapEntryComparator;
import com.hazelcast.impl.concurrentmap.LRUMapEntryComparator;
import com.hazelcast.impl.concurrentmap.MapStoreWrapper;
import com.hazelcast.impl.concurrentmap.MultiData;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.Serializer;
import com.hazelcast.query.Expression;
import com.hazelcast.query.MapIndexService;
import com.hazelcast.util.SortedHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMap {
    private static final Comparator<MapEntry> LRU_COMPARATOR = new LRUMapEntryComparator();
    private static final Comparator<MapEntry> LFU_COMPARATOR = new LFUMapEntryComparator();
    public static final int DEFAULT_MAP_SIZE = 10000;
    final ILogger logger;
    final ConcurrentMapManager concurrentMapManager;
    final Node node;
    final int PARTITION_COUNT;
    final Block[] blocks;
    final Address thisAddress;
    final ConcurrentMap<Data, Record> mapRecords = new ConcurrentHashMap<Data, Record>(10000);
    final ConcurrentMap<Long, RecordEntry> mapRecordEntries = new ConcurrentHashMap<Long, RecordEntry>(1000);
    final String name;
    final Map<Address, Boolean> mapListeners = new HashMap<Address, Boolean>(1);
    final int backupCount;
    final EvictionPolicy evictionPolicy;
    final Comparator<MapEntry> evictionComparator;
    final int maxSize;
    final float evictionRate;
    final long ttl;
    final long maxIdle;
    final Instance.InstanceType instanceType;
    final MapLoader loader;
    final MapStore store;
    final long writeDelayMillis;
    final long removeDelayMillis;
    final long evictionDelayMillis;
    final MapIndexService mapIndexService;
    final LocallyOwnedMap locallyOwnedMap;
    final MapNearCache mapNearCache;
    final long creationTime;
    volatile boolean ttlPerRecord = false;
    volatile long lastEvictionTime = 0L;
    DistributedLock lockEntireMap = null;
    final LocalMapStatsImpl localMapStats = new LocalMapStatsImpl();

    public CMap(ConcurrentMapManager concurrentMapManager, String name) {
        this.concurrentMapManager = concurrentMapManager;
        this.logger = concurrentMapManager.node.getLogger(CMap.class.getName());
        this.PARTITION_COUNT = concurrentMapManager.PARTITION_COUNT;
        this.blocks = concurrentMapManager.blocks;
        this.node = concurrentMapManager.node;
        this.thisAddress = concurrentMapManager.thisAddress;
        this.name = name;
        MapConfig mapConfig = null;
        String mapConfigName = name.substring(2);
        mapConfig = mapConfigName.startsWith("__hz_") || mapConfigName.startsWith("l:") || mapConfigName.startsWith("s:") ? new MapConfig() : this.node.getConfig().getMapConfig(mapConfigName);
        this.mapIndexService = new MapIndexService(mapConfig.isValueIndexed());
        this.backupCount = mapConfig.getBackupCount();
        this.ttl = (long)mapConfig.getTimeToLiveSeconds() * 1000L;
        this.evictionDelayMillis = (long)mapConfig.getEvictionDelaySeconds() * 1000L;
        this.maxIdle = (long)mapConfig.getMaxIdleSeconds() * 1000L;
        this.evictionPolicy = EvictionPolicy.valueOf(mapConfig.getEvictionPolicy());
        if (this.evictionPolicy == EvictionPolicy.NONE) {
            this.maxSize = Integer.MAX_VALUE;
            this.evictionComparator = null;
        } else {
            this.maxSize = mapConfig.getMaxSize() == 0 ? Integer.MAX_VALUE : mapConfig.getMaxSize();
            this.evictionComparator = this.evictionPolicy == EvictionPolicy.LRU ? LRU_COMPARATOR : LFU_COMPARATOR;
        }
        this.evictionRate = (float)mapConfig.getEvictionPercentage() / 100.0f;
        this.instanceType = ConcurrentMapManager.getInstanceType(name);
        MapStoreConfig mapStoreConfig = mapConfig.getMapStoreConfig();
        MapStoreWrapper mapStoreWrapper = null;
        int writeDelaySeconds = -1;
        if (!this.node.isSuperClient() && mapStoreConfig != null && mapStoreConfig.isEnabled()) {
            try {
                Object storeInstance = mapStoreConfig.getImplementation();
                if (storeInstance == null) {
                    String mapStoreClassName = mapStoreConfig.getClassName();
                    storeInstance = Serializer.classForName(this.node.getConfig().getClassLoader(), mapStoreClassName).newInstance();
                }
                mapStoreWrapper = new MapStoreWrapper(storeInstance, this.node.factory.getHazelcastInstanceProxy(), mapStoreConfig.getProperties(), mapConfigName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            writeDelaySeconds = mapStoreConfig.getWriteDelaySeconds();
        }
        if (!this.node.isSuperClient() && this.evictionPolicy == EvictionPolicy.NONE && this.instanceType == Instance.InstanceType.MAP) {
            this.locallyOwnedMap = new LocallyOwnedMap(this.localMapStats);
            concurrentMapManager.mapLocallyOwnedMaps.put(name, this.locallyOwnedMap);
        } else {
            this.locallyOwnedMap = null;
        }
        this.writeDelayMillis = writeDelaySeconds == -1 ? -1L : (long)writeDelaySeconds * 1000L;
        this.removeDelayMillis = writeDelaySeconds > 0 ? concurrentMapManager.GLOBAL_REMOVE_DELAY_MILLIS + (long)writeDelaySeconds : concurrentMapManager.GLOBAL_REMOVE_DELAY_MILLIS;
        this.loader = mapStoreWrapper == null || !mapStoreWrapper.isMapLoader() ? null : mapStoreWrapper;
        this.store = mapStoreWrapper == null || !mapStoreWrapper.isMapStore() ? null : mapStoreWrapper;
        NearCacheConfig nearCacheConfig = mapConfig.getNearCacheConfig();
        if (nearCacheConfig == null) {
            this.mapNearCache = null;
        } else {
            this.mapNearCache = new MapNearCache(this, SortedHashMap.getOrderingTypeByName(nearCacheConfig.getEvictionPolicy()), nearCacheConfig.getMaxSize(), (long)nearCacheConfig.getTimeToLiveSeconds() * 1000L, (long)nearCacheConfig.getMaxIdleSeconds() * 1000L, nearCacheConfig.isInvalidateOnChange());
            concurrentMapManager.mapCaches.put(name, this.mapNearCache);
        }
        this.creationTime = System.currentTimeMillis();
    }

    public boolean checkLock(Request request) {
        return this.lockEntireMap == null || !this.lockEntireMap.isLocked() || this.lockEntireMap.isLockedBy(request.lockAddress, request.lockThreadId);
    }

    public RecordEntry getRecordEntry(Record record) {
        RecordEntry recordEntry = (RecordEntry)this.mapRecordEntries.get(record.getId());
        if (recordEntry == null) {
            recordEntry = new RecordEntry(record);
            RecordEntry found = this.mapRecordEntries.putIfAbsent(record.getId(), recordEntry);
            if (found != null) {
                recordEntry = found;
            }
        }
        return recordEntry;
    }

    public void invalidateRecordEntryValue(Record record) {
        this.mapRecordEntries.remove(record.getId());
    }

    public void lockMap(Request request) {
        if (request.operation == ClusterOperation.CONCURRENT_MAP_LOCK_MAP) {
            if (this.lockEntireMap == null) {
                this.lockEntireMap = new DistributedLock();
            }
            boolean locked = this.lockEntireMap.lock(request.lockAddress, request.lockThreadId);
            request.clearForResponse();
            request.response = !locked ? (request.timeout == 0L ? Boolean.FALSE : Constants.Objects.OBJECT_REDO) : Boolean.TRUE;
        } else if (request.operation == ClusterOperation.CONCURRENT_MAP_UNLOCK_MAP) {
            request.response = this.lockEntireMap != null ? Boolean.valueOf(this.lockEntireMap.unlock(request.lockAddress, request.lockThreadId)) : Boolean.TRUE;
        }
    }

    public void addIndex(Expression expression, boolean ordered, int attributeIndex) {
        this.mapIndexService.addIndex(expression, ordered, attributeIndex);
    }

    public Record getRecord(Data key) {
        return (Record)this.mapRecords.get(key);
    }

    public int getBackupCount() {
        return this.backupCount;
    }

    public void own(Request req) {
        if (req.key == null || req.key.size() == 0) {
            throw new RuntimeException("Key cannot be null " + req.key);
        }
        if (req.value == null) {
            req.value = new Data();
        }
        Record record = this.toRecordAndStats(req, true);
        if (req.ttl <= 0L || req.timeout <= 0L) {
            record.setInvalid();
        } else {
            record.setExpirationTime(req.ttl);
            record.setMaxIdle(req.timeout);
        }
        this.markAsActive(record);
        this.markAsDirty(record);
        this.updateIndexes(record);
        if (record.isLocked()) {
            this.updateStats(LocalMapStatsImpl.Op.LOCK, record, true, null);
        }
        record.setVersion(req.version);
    }

    public boolean isMultiMap() {
        return this.instanceType == Instance.InstanceType.MULTIMAP;
    }

    public boolean isSet() {
        return this.instanceType == Instance.InstanceType.SET;
    }

    public boolean isList() {
        return this.instanceType == Instance.InstanceType.LIST;
    }

    public boolean isMap() {
        return this.instanceType == Instance.InstanceType.MAP;
    }

    public boolean backup(Request req) {
        if (req.key == null || req.key.size() == 0) {
            throw new RuntimeException("Backup key size cannot be 0: " + req.key);
        }
        if (this.instanceType == Instance.InstanceType.MAP || this.instanceType == Instance.InstanceType.SET) {
            return this.backupOneValue(req);
        }
        return this.backupMultiValue(req);
    }

    private boolean backupOneValue(Request req) {
        Record record = this.getRecord(req.key);
        if (record != null && record.isActive() && req.version < record.getVersion()) {
            return false;
        }
        this.doBackup(req);
        if (record != null) {
            record.setVersion(req.version);
        }
        return true;
    }

    private boolean backupMultiValue(Request req) {
        Record record = this.getRecord(req.key);
        if (record != null) {
            record.setActive();
            if (req.version > record.getVersion() + 1L) {
                Request reqCopy = req.hardCopy();
                record.addBackupOp(new VersionedBackupOp(this, reqCopy));
                return true;
            }
            if (req.version <= record.getVersion()) {
                return false;
            }
        }
        this.doBackup(req);
        if (record != null) {
            record.setVersion(req.version);
            record.runBackupOps();
        }
        return true;
    }

    Record toRecordAndStats(Request req, boolean owned) {
        LocalMapStatsImpl.Op op;
        Record record = this.getRecord(req.key);
        Data oldValue = null;
        if (record == null || !record.isActive()) {
            op = LocalMapStatsImpl.Op.CREATE;
        } else {
            op = LocalMapStatsImpl.Op.UPDATE;
            oldValue = record.getValue();
        }
        record = this.toRecord(req);
        this.updateStats(op, record, owned, oldValue);
        return record;
    }

    public void doBackup(Request req) {
        if (req.key == null || req.key.size() == 0) {
            throw new RuntimeException("Backup key size cannot be zero! " + req.key);
        }
        if (req.operation == ClusterOperation.CONCURRENT_MAP_BACKUP_PUT) {
            Record record = this.toRecordAndStats(req, false);
            if (!record.isActive()) {
                record.setActive();
                record.setCreationTime(System.currentTimeMillis());
            }
            record.setVersion(req.version);
            if (req.indexes != null) {
                if (req.indexTypes == null) {
                    throw new RuntimeException("index types cannot be null!");
                }
                if (req.indexes.length != req.indexTypes.length) {
                    throw new RuntimeException("index and type lengths do not match");
                }
                record.setIndexes(req.indexes, req.indexTypes);
            }
        } else if (req.operation == ClusterOperation.CONCURRENT_MAP_BACKUP_REMOVE) {
            Record record = this.getRecord(req.key);
            if (record != null && record.isActive()) {
                this.updateStats(LocalMapStatsImpl.Op.REMOVE, record, false, null);
                if (record.getCopyCount() > 0) {
                    record.decrementCopyCount();
                }
                this.markAsRemoved(record);
            }
        } else if (req.operation == ClusterOperation.CONCURRENT_MAP_BACKUP_LOCK) {
            Record rec = this.toRecord(req);
            if (rec.getVersion() == 0L) {
                rec.setVersion(req.version);
            }
        } else if (req.operation == ClusterOperation.CONCURRENT_MAP_BACKUP_ADD) {
            this.add(req, true);
        } else if (req.operation == ClusterOperation.CONCURRENT_MAP_BACKUP_REMOVE_MULTI) {
            Record record = this.getRecord(req.key);
            if (record != null) {
                if (req.value == null) {
                    this.markAsRemoved(record);
                } else {
                    if (record.containsValue(req.value) && record.getMultiValues() != null) {
                        Iterator<Data> itValues = record.getMultiValues().iterator();
                        while (itValues.hasNext()) {
                            Data value = itValues.next();
                            if (!req.value.equals(value)) continue;
                            itValues.remove();
                        }
                    }
                    if (record.valueCount() == 0) {
                        this.markAsRemoved(record);
                    }
                }
            }
        } else {
            this.logger.log(Level.SEVERE, "Unknown backup operation " + (Object)((Object)req.operation));
        }
    }

    public LocalMapStatsImpl getLocalMapStats() {
        ClusterImpl clusterImpl = this.node.getClusterImpl();
        LocalMapStatsImpl stats = new LocalMapStatsImpl();
        stats.setLockWaitCount(this.localMapStats.getLockWaitCount());
        stats.setLockedEntryCount(this.localMapStats.getLockedEntryCount());
        stats.setHits(this.localMapStats.getHits());
        stats.setOwnedEntryCount(this.localMapStats.getOwnedEntryCount());
        stats.setBackupEntryCount(this.localMapStats.getBackupEntryCount());
        stats.setOwnedEntryMemoryCost(this.localMapStats.getOwnedEntryMemoryCost());
        stats.setBackupEntryMemoryCost(this.localMapStats.getBackupEntryMemoryCost());
        stats.setLastEvictionTime(clusterImpl.getClusterTimeFor(this.lastEvictionTime));
        stats.setCreationTime(clusterImpl.getClusterTimeFor(this.creationTime));
        stats.setLastAccessTime(clusterImpl.getClusterTimeFor(this.localMapStats.getLastAccessTime()));
        stats.setLastUpdateTime(clusterImpl.getClusterTimeFor(this.localMapStats.getLastUpdateTime()));
        return stats;
    }

    void resetLocalMapStats(Map<Address, Integer> distances) {
        long now = System.currentTimeMillis();
        int ownedEntryCount = 0;
        int backupEntryCount = 0;
        int markedAsRemovedEntryCount = 0;
        int ownedEntryMemoryCost = 0;
        int backupEntryMemoryCost = 0;
        int markedAsRemovedMemoryCost = 0;
        int hits = 0;
        int lockedEntryCount = 0;
        int lockWaitCount = 0;
        ClusterImpl clusterImpl = this.node.getClusterImpl();
        for (Record record : this.mapRecords.values()) {
            Integer distance;
            Address eventualOwner;
            if (!record.isActive() || !record.isValid(now)) {
                ++markedAsRemovedEntryCount;
                markedAsRemovedMemoryCost = (int)((long)markedAsRemovedMemoryCost + record.getCost());
                continue;
            }
            Block block = this.concurrentMapManager.getOrCreateBlock(record.getBlockId());
            boolean owned = this.thisAddress.equals(block.getOwner());
            if (owned) {
                ownedEntryCount += record.valueCount();
                ownedEntryMemoryCost = (int)((long)ownedEntryMemoryCost + record.getCost());
                this.localMapStats.setLastAccessTime(record.getLastAccessTime());
                this.localMapStats.setLastUpdateTime(record.getLastUpdateTime());
                hits += record.getHits();
                if (!record.isLocked()) continue;
                ++lockedEntryCount;
                lockWaitCount += record.getScheduledActionCount();
                continue;
            }
            boolean unknown = false;
            Address address = eventualOwner = block.isMigrating() ? block.getMigrationAddress() : block.getOwner();
            if (!this.thisAddress.equals(eventualOwner) && (distance = distances.get(eventualOwner)) != null && distance > this.getBackupCount()) {
                unknown = true;
            }
            if (unknown) {
                ++markedAsRemovedEntryCount;
                markedAsRemovedMemoryCost = (int)((long)markedAsRemovedMemoryCost + record.getCost());
                this.markAsRemoved(record);
                continue;
            }
            backupEntryCount += record.valueCount();
            backupEntryMemoryCost = (int)((long)backupEntryMemoryCost + record.getCost());
        }
        this.localMapStats.setMarkedAsRemovedEntryCount(markedAsRemovedEntryCount);
        this.localMapStats.setMarkedAsRemovedMemoryCost(markedAsRemovedMemoryCost);
        this.localMapStats.setLockWaitCount(lockWaitCount);
        this.localMapStats.setLockedEntryCount(lockedEntryCount);
        this.localMapStats.setHits(hits);
        this.localMapStats.setOwnedEntryCount(ownedEntryCount);
        this.localMapStats.setBackupEntryCount(backupEntryCount);
        this.localMapStats.setOwnedEntryMemoryCost(ownedEntryMemoryCost);
        this.localMapStats.setBackupEntryMemoryCost(backupEntryMemoryCost);
        this.localMapStats.setLastEvictionTime(clusterImpl.getClusterTimeFor(this.lastEvictionTime));
        this.localMapStats.setCreationTime(clusterImpl.getClusterTimeFor(this.creationTime));
    }

    public LocalMapStatsImpl createLocalMapStats() {
        long now = System.currentTimeMillis();
        int ownedEntryCount = 0;
        int backupEntryCount = 0;
        int markedAsRemovedEntryCount = 0;
        int ownedEntryMemoryCost = 0;
        int backupEntryMemoryCost = 0;
        int markedAsRemovedMemoryCost = 0;
        int hits = 0;
        int lockedEntryCount = 0;
        int lockWaitCount = 0;
        ClusterImpl clusterImpl = this.node.getClusterImpl();
        LocalMapStatsImpl localMapStats = new LocalMapStatsImpl();
        for (Record record : this.mapRecords.values()) {
            if (!record.isActive() || !record.isValid(now)) {
                ++markedAsRemovedEntryCount;
                markedAsRemovedMemoryCost = (int)((long)markedAsRemovedMemoryCost + record.getCost());
                continue;
            }
            if (this.isOwned(record)) {
                ownedEntryCount += record.valueCount();
                ownedEntryMemoryCost = (int)((long)ownedEntryMemoryCost + record.getCost());
                localMapStats.setLastAccessTime(clusterImpl.getClusterTimeFor(record.getLastAccessTime()));
                localMapStats.setLastUpdateTime(clusterImpl.getClusterTimeFor(record.getLastUpdateTime()));
                hits += record.getHits();
                if (!record.isLocked()) continue;
                ++lockedEntryCount;
                lockWaitCount += record.getScheduledActionCount();
                continue;
            }
            if (this.isBackup(record)) {
                backupEntryCount += record.valueCount();
                backupEntryMemoryCost = (int)((long)backupEntryMemoryCost + record.getCost());
                continue;
            }
            ++markedAsRemovedEntryCount;
            markedAsRemovedMemoryCost = (int)((long)markedAsRemovedMemoryCost + record.getCost());
        }
        localMapStats.setMarkedAsRemovedEntryCount(markedAsRemovedEntryCount);
        localMapStats.setMarkedAsRemovedMemoryCost(markedAsRemovedMemoryCost);
        localMapStats.setLockWaitCount(lockWaitCount);
        localMapStats.setLockedEntryCount(lockedEntryCount);
        localMapStats.setHits(hits);
        localMapStats.setOwnedEntryCount(ownedEntryCount);
        localMapStats.setBackupEntryCount(backupEntryCount);
        localMapStats.setOwnedEntryMemoryCost(ownedEntryMemoryCost);
        localMapStats.setBackupEntryMemoryCost(backupEntryMemoryCost);
        localMapStats.setLastEvictionTime(clusterImpl.getClusterTimeFor(this.lastEvictionTime));
        localMapStats.setCreationTime(clusterImpl.getClusterTimeFor(this.creationTime));
        return localMapStats;
    }

    private void purgeIfNotOwnedOrBackup(Collection<Record> records) {
        HashMap<Address, Integer> mapMemberDistances = new HashMap<Address, Integer>();
        for (Record record : records) {
            int distance;
            Address owner;
            Block block = this.blocks[record.getBlockId()];
            boolean owned = this.thisAddress.equals(block.getOwner());
            if (owned || block.isMigrating() || (owner = block.isMigrating() ? block.getMigrationAddress() : block.getOwner()) == null || this.thisAddress.equals(owner)) continue;
            Integer d = (Integer)mapMemberDistances.get(owner);
            if (d == null) {
                distance = this.concurrentMapManager.getDistance(owner, this.thisAddress);
                mapMemberDistances.put(owner, distance);
            } else {
                distance = d;
            }
            if (distance <= this.getBackupCount()) continue;
            this.mapRecords.remove(record.getKey());
        }
    }

    private boolean isOwned(Record record) {
        PartitionServiceImpl partitionService = this.concurrentMapManager.partitionManager.partitionServiceImpl;
        PartitionServiceImpl.PartitionProxy partition = partitionService.getPartition(record.getBlockId());
        Member owner = partition.getOwner();
        return owner != null && owner.localMember();
    }

    private boolean isBackup(Record record) {
        PartitionServiceImpl partitionService = this.concurrentMapManager.partitionManager.partitionServiceImpl;
        PartitionServiceImpl.PartitionProxy partition = partitionService.getPartition(record.getBlockId());
        Member ownerNow = partition.getOwner();
        Member ownerEventual = partition.getEventualOwner();
        if (ownerEventual != null && ownerNow != null && !ownerNow.localMember()) {
            int distance = this.node.getClusterImpl().getDistanceFrom(ownerEventual);
            return distance != -1 && distance <= this.getBackupCount();
        }
        return false;
    }

    public int size() {
        if (this.maxIdle > 0L || this.ttl > 0L || this.ttlPerRecord || this.isList() || this.isMultiMap()) {
            long now = System.currentTimeMillis();
            int size = 0;
            Collection<Record> records = this.mapIndexService.getOwnedRecords();
            for (Record record : records) {
                if (!record.isActive() || !record.isValid(now)) continue;
                size += record.valueCount();
            }
            return size;
        }
        return this.mapIndexService.size();
    }

    public boolean hasOwned(long blockId) {
        Collection records = this.mapRecords.values();
        for (Record record : records) {
            if ((long)record.getBlockId() != blockId || !record.isActive()) continue;
            return true;
        }
        return false;
    }

    public int valueCount(Data key) {
        long now = System.currentTimeMillis();
        int count = 0;
        Record record = (Record)this.mapRecords.get(key);
        if (record != null && record.isValid(now)) {
            count = record.valueCount();
        }
        return count;
    }

    public boolean contains(Request req) {
        Data key = req.key;
        Data value = req.value;
        if (key != null) {
            Record record = this.getRecord(req.key);
            if (record == null) {
                return false;
            }
            if (record.isActive() && record.isValid()) {
                this.updateStats(LocalMapStatsImpl.Op.READ, record, true, null);
                if (value == null) {
                    return record.valueCount() > 0;
                }
                return record.containsValue(value);
            }
        } else {
            Collection records = this.mapRecords.values();
            for (Record record : records) {
                Block block;
                long now = System.currentTimeMillis();
                if (!record.isActive() || !record.isValid(now) || !this.thisAddress.equals((block = this.blocks[record.getBlockId()]).getOwner()) || !record.containsValue(value)) continue;
                return true;
            }
        }
        return false;
    }

    public void containsValue(Request request) {
        if (this.isMultiMap()) {
            boolean found = false;
            Collection records = this.mapRecords.values();
            for (Record record : records) {
                Block block;
                long now = System.currentTimeMillis();
                if (!record.isActive() || !record.isValid(now) || !this.thisAddress.equals((block = this.blocks[record.getBlockId()]).getOwner()) || !record.containsValue(request.value)) continue;
                found = true;
            }
            request.response = found;
        } else {
            request.response = this.mapIndexService.containsValue(request.value);
        }
    }

    public CMapEntry getMapEntry(Request req) {
        Record record = this.getRecord(req.key);
        if (record == null || !record.isActive() || !record.isValid()) {
            return null;
        }
        return new CMapEntry(record.getCost(), record.getExpirationTime(), record.getLastAccessTime(), record.getLastUpdateTime(), record.getCreationTime(), record.getVersion(), record.getHits(), true);
    }

    public Data get(Request req) {
        Record record = this.getRecord(req.key);
        if (record == null) {
            return null;
        }
        if (!record.isActive()) {
            return null;
        }
        if (!record.isValid() && record.isEvictable()) {
            return null;
        }
        record.setLastAccessed();
        this.updateStats(LocalMapStatsImpl.Op.READ, record, true, null);
        Data data = record.getValue();
        Data returnValue = null;
        if (data != null) {
            returnValue = data;
        } else if (record.getMultiValues() != null) {
            Values values = new Values(record.getMultiValues());
            returnValue = IOUtil.toData(values);
        }
        if (req.local && this.locallyOwnedMap != null && returnValue != null) {
            this.locallyOwnedMap.offerToCache(record);
        }
        return returnValue;
    }

    public boolean add(Request req, boolean backup) {
        Record record = this.getRecord(req.key);
        if (record == null) {
            record = this.toRecord(req);
        } else if (record.isActive() && req.operation == ClusterOperation.CONCURRENT_MAP_ADD_TO_SET) {
            return false;
        }
        record.setActive(true);
        record.incrementVersion();
        record.incrementCopyCount();
        if (!backup) {
            this.updateIndexes(record);
            this.concurrentMapManager.fireMapEvent(this.mapListeners, this.getName(), EntryEvent.TYPE_ADDED, record);
        }
        return true;
    }

    void lock(Request request) {
        Data reqValue = request.value;
        request.value = null;
        Record rec = this.concurrentMapManager.ensureRecord(request);
        if (request.operation == ClusterOperation.CONCURRENT_MAP_LOCK_AND_GET_VALUE) {
            if (reqValue == null) {
                request.value = rec.getValue();
                if (rec.getMultiValues() != null) {
                    Values values = new Values(rec.getMultiValues());
                    request.value = IOUtil.toData(values);
                }
            } else {
                request.value = !rec.containsValue(reqValue) ? null : reqValue;
            }
        }
        rec.lock(request.lockThreadId, request.lockAddress);
        rec.incrementVersion();
        this.mapRecordEntries.remove(rec.getId());
        request.version = rec.getVersion();
        request.lockCount = rec.getLockCount();
        this.updateStats(LocalMapStatsImpl.Op.LOCK, rec, true, null);
        this.markAsActive(rec);
        request.response = Boolean.TRUE;
    }

    void unlock(Record record) {
        record.clearLock();
        this.fireScheduledActions(record);
    }

    void fireScheduledActions(Record record) {
        this.concurrentMapManager.checkServiceThread();
        if (record.getLockCount() == 0) {
            record.clearLock();
            while (record.hasScheduledAction()) {
                ScheduledAction sa = record.getScheduledActions().remove(0);
                this.node.clusterManager.deregisterScheduledAction(sa);
                if (!sa.expired()) {
                    sa.consume();
                    if (!record.isLocked()) continue;
                    return;
                }
                sa.onExpire();
            }
        }
    }

    public void onDisconnect(Record record, Address deadAddress) {
        if (record == null || deadAddress == null) {
            return;
        }
        List<ScheduledAction> lsScheduledActions = record.getScheduledActions();
        if (lsScheduledActions != null && lsScheduledActions.size() > 0) {
            Iterator<ScheduledAction> it = lsScheduledActions.iterator();
            while (it.hasNext()) {
                ScheduledAction sa = it.next();
                if (!deadAddress.equals(sa.getRequest().caller)) continue;
                this.node.clusterManager.deregisterScheduledAction(sa);
                sa.setValid(false);
                it.remove();
            }
        }
        if (record.getLockCount() > 0 && deadAddress.equals(record.getLockAddress())) {
            this.unlock(record);
        }
    }

    public boolean removeMulti(Request req) {
        Record record = this.getRecord(req.key);
        if (record == null) {
            return false;
        }
        boolean removed = false;
        if (req.value == null) {
            removed = true;
            this.markAsRemoved(record);
        } else if (record.containsValue(req.value) && record.getMultiValues() != null) {
            Iterator<Data> itValues = record.getMultiValues().iterator();
            while (itValues.hasNext()) {
                Data value = itValues.next();
                if (!req.value.equals(value)) continue;
                itValues.remove();
                removed = true;
            }
        }
        if (req.txnId != -1L) {
            this.unlock(record);
        }
        if (removed) {
            record.incrementVersion();
            this.concurrentMapManager.fireMapEvent(this.mapListeners, this.getName(), EntryEvent.TYPE_REMOVED, record.getKey(), req.value, record.getMapListeners());
            this.logger.log(Level.FINEST, record.getValue() + " RemoveMulti " + record.getMultiValues());
        }
        req.version = record.getVersion();
        if (record.valueCount() == 0) {
            this.markAsRemoved(record);
        }
        return removed;
    }

    public boolean putMulti(Request req) {
        Record record = this.getRecord(req.key);
        boolean added = true;
        if (record == null) {
            record = this.toRecord(req);
        } else {
            if (!record.isActive()) {
                this.markAsActive(record);
            }
            if (record.containsValue(req.value)) {
                added = false;
            }
        }
        if (added) {
            Data value = req.value;
            this.updateIndexes(record);
            record.addValue(value);
            record.incrementVersion();
            this.concurrentMapManager.fireMapEvent(this.mapListeners, this.getName(), EntryEvent.TYPE_ADDED, record.getKey(), value, record.getMapListeners());
        }
        if (req.txnId != -1L) {
            this.unlock(record);
        }
        this.logger.log(Level.FINEST, record.getValue() + " PutMulti " + record.getMultiValues());
        req.clearForResponse();
        req.version = record.getVersion();
        return added;
    }

    public void addAndGet(Request req) {
        Record record = this.getRecord(req.key);
    }

    public void getAndAdd(Request req) {
    }

    public void put(Request req) {
        long now = System.currentTimeMillis();
        if (this.mapRecords.size() >= this.maxSize) {
            // empty if block
        }
        if (req.value == null) {
            req.value = new Data();
        }
        Record record = this.getRecord(req.key);
        if (req.operation == ClusterOperation.CONCURRENT_MAP_PUT_IF_ABSENT) {
            if (record != null && record.isActive() && record.isValid(now) && record.getValue() != null) {
                req.clearForResponse();
                req.response = record.getValue();
                return;
            }
        } else if (req.operation == ClusterOperation.CONCURRENT_MAP_REPLACE_IF_NOT_NULL) {
            if (record == null || !record.isActive() || !record.isValid(now) || record.getValue() == null) {
                return;
            }
        } else if (req.operation == ClusterOperation.CONCURRENT_MAP_REPLACE_IF_SAME) {
            if (record == null || !record.isActive() || !record.isValid(now)) {
                req.response = Boolean.FALSE;
                return;
            }
            MultiData multiData = (MultiData)IOUtil.toObject(req.value);
            if (multiData == null || multiData.size() != 2) {
                throw new RuntimeException("Illegal replaceIfSame argument: " + multiData);
            }
            Data expectedOldValue = multiData.getData(0);
            req.value = multiData.getData(1);
            if (!record.getValue().equals(expectedOldValue)) {
                req.response = Boolean.FALSE;
                return;
            }
        }
        Data oldValue = null;
        LocalMapStatsImpl.Op op = LocalMapStatsImpl.Op.UPDATE;
        if (record == null) {
            record = this.createNewRecord(req.key, req.value);
            this.mapRecords.put(req.key, record);
            op = LocalMapStatsImpl.Op.CREATE;
        } else {
            if (!record.isActive()) {
                op = LocalMapStatsImpl.Op.CREATE;
            }
            this.markAsActive(record);
            oldValue = record.isValid(now) ? record.getValue() : null;
            record.setValue(req.value);
            record.incrementVersion();
            record.setLastUpdated();
        }
        if (req.ttl > 0L) {
            record.setExpirationTime(req.ttl);
            this.ttlPerRecord = true;
        }
        if (oldValue == null) {
            this.concurrentMapManager.fireMapEvent(this.mapListeners, this.getName(), EntryEvent.TYPE_ADDED, record);
        } else {
            this.fireInvalidation(record);
            this.concurrentMapManager.fireMapEvent(this.mapListeners, this.getName(), EntryEvent.TYPE_UPDATED, record);
        }
        if (req.txnId != -1L) {
            this.unlock(record);
        }
        record.setIndexes(req.indexes, req.indexTypes);
        this.updateStats(op, record, true, oldValue);
        this.updateIndexes(record);
        this.markAsDirty(record);
        req.clearForResponse();
        req.version = record.getVersion();
        req.longValue = record.getCopyCount();
        req.response = req.operation == ClusterOperation.CONCURRENT_MAP_REPLACE_IF_SAME ? Boolean.TRUE : oldValue;
    }

    private void executeStoreUpdate(final Map<Data, Data> entriesToStore, final Collection<Data> keysToDelete) {
        final int entriesToStoreSize = entriesToStore.size();
        final int keysToDeleteSize = keysToDelete.size();
        if (entriesToStoreSize > 0 || keysToDeleteSize > 0) {
            this.concurrentMapManager.node.executorManager.executeStoreTask(new Runnable(){

                public void run() {
                    if (keysToDeleteSize > 0) {
                        if (keysToDeleteSize == 1) {
                            Data key = (Data)keysToDelete.iterator().next();
                            CMap.this.store.delete(IOUtil.toObject(key));
                        } else {
                            HashSet<Object> realKeys = new HashSet<Object>();
                            for (Data key : keysToDelete) {
                                realKeys.add(IOUtil.toObject(key));
                            }
                            CMap.this.store.deleteAll(realKeys);
                        }
                    }
                    if (entriesToStoreSize > 0) {
                        Object keyFirst = null;
                        Object valueFirst = null;
                        Set entries = entriesToStore.entrySet();
                        HashMap<Object, Object> realEntries = new HashMap<Object, Object>();
                        for (Map.Entry entry : entries) {
                            Object key = IOUtil.toObject((Data)entry.getKey());
                            Object value = IOUtil.toObject((Data)entry.getValue());
                            realEntries.put(key, value);
                            if (keyFirst != null) continue;
                            keyFirst = key;
                            valueFirst = value;
                        }
                        if (entriesToStoreSize == 1) {
                            CMap.this.store.store(keyFirst, valueFirst);
                        } else {
                            CMap.this.store.storeAll(realEntries);
                        }
                    }
                }
            });
        }
    }

    void startCleanup() {
        long now = System.currentTimeMillis();
        HashMap<Data, Data> entriesToStore = new HashMap<Data, Data>();
        HashSet<Data> keysToDelete = new HashSet<Data>();
        HashSet<Record> recordsUnknown = new HashSet<Record>();
        HashSet<Record> recordsToPurge = new HashSet<Record>();
        HashSet<Record> recordsToEvict = new HashSet<Record>();
        TreeSet<MapEntry> sortedRecords = new TreeSet<MapEntry>(this.evictionComparator);
        Collection records = this.mapRecords.values();
        boolean evictionAware = this.evictionComparator != null && this.maxSize > 0;
        PartitionServiceImpl partitionService = this.concurrentMapManager.partitionManager.partitionServiceImpl;
        int recordsStillOwned = 0;
        for (Record record : records) {
            PartitionServiceImpl.PartitionProxy partition = partitionService.getPartition(record.getBlockId());
            Member member = partition.getOwner();
            if (member == null || partition.isMigrating()) continue;
            boolean owned = member.localMember();
            if (owned) {
                if (this.store != null && record.isDirty()) {
                    if (now <= record.getWriteTime()) continue;
                    if (record.getValue() != null) {
                        entriesToStore.put(record.getKey(), record.getValue());
                    } else {
                        keysToDelete.add(record.getKey());
                    }
                    record.setDirty(false);
                    continue;
                }
                if (this.shouldPurgeRecord(record, now)) {
                    recordsToPurge.add(record);
                    continue;
                }
                if (record.isActive() && !record.isValid(now)) {
                    recordsToEvict.add(record);
                    continue;
                }
                if (evictionAware && record.isActive() && record.isEvictable()) {
                    sortedRecords.add(record);
                    ++recordsStillOwned;
                    continue;
                }
                ++recordsStillOwned;
                continue;
            }
            Member ownerEventual = partition.getEventualOwner();
            boolean backup = false;
            if (ownerEventual != null && member != null && !member.localMember()) {
                int distance = this.node.getClusterImpl().getDistanceFrom(ownerEventual);
                boolean bl = backup = distance != -1 && distance <= this.getBackupCount();
            }
            if (backup) {
                if (!this.shouldPurgeRecord(record, now)) continue;
                recordsToPurge.add(record);
                continue;
            }
            recordsUnknown.add(record);
        }
        if (evictionAware && this.maxSize < recordsStillOwned) {
            int numberOfRecordsToEvict = (int)((float)recordsStillOwned * this.evictionRate);
            int evictedCount = 0;
            for (Record record : sortedRecords) {
                if (!record.isActive() || !record.isEvictable()) continue;
                recordsToEvict.add(record);
                if (++evictedCount < numberOfRecordsToEvict) continue;
                break;
            }
        }
        Level levelLog = this.concurrentMapManager.LOG_STATE ? Level.INFO : Level.FINEST;
        this.logger.log(levelLog, "Cleanup , store:" + entriesToStore.size() + ", delete:" + keysToDelete.size() + ", purge:" + recordsToPurge.size() + ", evict:" + recordsToEvict.size() + ", unknown:" + recordsUnknown.size());
        this.executeStoreUpdate(entriesToStore, keysToDelete);
        this.executeEviction(recordsToEvict);
        this.executePurge(recordsToPurge);
        this.executePurgeUnknowns(recordsUnknown);
    }

    private void executePurgeUnknowns(final Set<Record> recordsUnknown) {
        if (recordsUnknown.size() > 0) {
            this.concurrentMapManager.enqueueAndReturn(new Processable(){

                public void process() {
                    CMap.this.purgeIfNotOwnedOrBackup(recordsUnknown);
                }
            });
        }
    }

    private void executePurge(final Set<Record> recordsToPurge) {
        if (recordsToPurge.size() > 0) {
            this.concurrentMapManager.enqueueAndReturn(new Processable(){

                public void process() {
                    long now = System.currentTimeMillis();
                    for (Record recordToPurge : recordsToPurge) {
                        if (!CMap.this.shouldPurgeRecord(recordToPurge, now)) continue;
                        CMap.this.removeAndPurgeRecord(recordToPurge);
                    }
                }
            });
        }
    }

    boolean shouldPurgeRecord(Record record, long now) {
        return !record.isActive() && this.shouldRemove(record, now);
    }

    private void executeEviction(Collection<Record> lsRecordsToEvict) {
        if (lsRecordsToEvict != null && lsRecordsToEvict.size() > 0) {
            this.logger.log(Level.FINEST, lsRecordsToEvict.size() + " evicting");
            for (Record recordToEvict : lsRecordsToEvict) {
                this.concurrentMapManager.evictAsync(recordToEvict.getName(), recordToEvict.getKey());
            }
        }
    }

    void fireInvalidation(Record record) {
        if (this.mapNearCache != null && this.mapNearCache.shouldInvalidateOnChange()) {
            for (MemberImpl member : this.concurrentMapManager.lsMembers) {
                if (member.localMember() || member.getAddress() == null) continue;
                Packet packet = this.concurrentMapManager.obtainPacket();
                packet.name = this.getName();
                packet.setKey(record.getKey());
                packet.operation = ClusterOperation.CONCURRENT_MAP_INVALIDATE;
                boolean sent = this.concurrentMapManager.send(packet, member.getAddress());
                if (sent) continue;
                this.concurrentMapManager.releasePacket(packet);
            }
            this.mapNearCache.invalidate(record.getKey());
        }
    }

    Record toRecord(Request req) {
        Record record = (Record)this.mapRecords.get(req.key);
        if (record == null) {
            if (this.isMultiMap()) {
                record = this.createNewRecord(req.key, null);
                record.addValue(req.value);
            } else {
                record = this.createNewRecord(req.key, req.value);
            }
            this.mapRecords.put(req.key, record);
        } else if (req.value != null) {
            if (this.isMultiMap()) {
                record.addValue(req.value);
            } else {
                record.setValue(req.value);
            }
        }
        record.setIndexes(req.indexes, req.indexTypes);
        record.setCopyCount((int)req.longValue);
        if (req.lockCount >= 0) {
            DistributedLock lock = new DistributedLock(req.lockAddress, req.lockThreadId, req.lockCount);
            record.setLock(lock);
        }
        return record;
    }

    public boolean removeItem(Request req) {
        Record record = (Record)this.mapRecords.get(req.key);
        if (record == null) {
            return false;
        }
        if (req.txnId != -1L) {
            this.unlock(record);
        }
        boolean removed = false;
        if (record.getCopyCount() > 0) {
            record.decrementCopyCount();
            removed = true;
        } else if (record.getValue() != null) {
            removed = true;
        } else if (record.getMultiValues() != null) {
            removed = true;
        }
        if (removed) {
            this.concurrentMapManager.fireMapEvent(this.mapListeners, this.getName(), EntryEvent.TYPE_REMOVED, record);
            record.incrementVersion();
        }
        req.version = record.getVersion();
        req.longValue = record.getCopyCount();
        this.markAsRemoved(record);
        return true;
    }

    boolean evict(Request req) {
        Record record = this.getRecord(req.key);
        if (record != null && record.isEvictable()) {
            this.fireInvalidation(record);
            this.concurrentMapManager.fireMapEvent(this.mapListeners, this.getName(), EntryEvent.TYPE_EVICTED, record.getKey(), record.getValue(), record.getMapListeners());
            record.incrementVersion();
            this.updateStats(LocalMapStatsImpl.Op.REMOVE, record, true, null);
            this.markAsRemoved(record);
            req.clearForResponse();
            req.version = record.getVersion();
            req.longValue = record.getCopyCount();
            this.lastEvictionTime = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    public void remove(Request req) {
        Record record = (Record)this.mapRecords.get(req.key);
        if (record == null) {
            req.clearForResponse();
            return;
        }
        if (req.txnId != -1L) {
            this.unlock(record);
        }
        if (!record.isActive()) {
            return;
        }
        if (!record.isValid() && record.isEvictable()) {
            return;
        }
        if (req.value != null && record.getValue() != null && !record.getValue().equals(req.value)) {
            return;
        }
        Data oldValue = record.getValue();
        if (oldValue == null && record.getMultiValues() != null && record.getMultiValues().size() > 0) {
            Values values = new Values(record.getMultiValues());
            oldValue = IOUtil.toData(values);
        }
        if (oldValue != null) {
            this.fireInvalidation(record);
            this.concurrentMapManager.fireMapEvent(this.mapListeners, this.getName(), EntryEvent.TYPE_REMOVED, record.getKey(), oldValue, record.getMapListeners());
            record.incrementVersion();
        }
        this.updateStats(LocalMapStatsImpl.Op.REMOVE, record, true, null);
        this.markAsRemoved(record);
        req.clearForResponse();
        req.version = record.getVersion();
        req.longValue = record.getCopyCount();
        req.response = oldValue;
    }

    void updateStats(LocalMapStatsImpl.Op op, Record record, boolean owned, Data oldValue) {
        long updateCost = 0L;
        if (op == LocalMapStatsImpl.Op.UPDATE) {
            long newValueCost = record.getValue() != null ? (long)record.getValue().size() : 0L;
            long oldValueCost = oldValue != null ? (long)oldValue.size() : 0L;
            updateCost = newValueCost - oldValueCost;
        }
        this.localMapStats.update(op, record, owned, updateCost);
    }

    public void incrementLockWaits(Record record) {
        this.localMapStats.update(LocalMapStatsImpl.Op.ADD_LOCK_WAIT, record, true, 0L);
    }

    public void decrementLockWaits(Record record) {
        this.localMapStats.update(LocalMapStatsImpl.Op.REMOVE_LOCK_WAIT, record, true, 0L);
    }

    void reset() {
        if (this.locallyOwnedMap != null) {
            this.locallyOwnedMap.reset();
        }
        this.mapRecords.clear();
        this.mapIndexService.clear();
    }

    void markAsDirty(Record record) {
        if (!record.isDirty()) {
            record.setDirty(true);
            if (this.writeDelayMillis > 0L) {
                record.setWriteTime(System.currentTimeMillis() + this.writeDelayMillis);
            }
        }
    }

    void markAsActive(Record record) {
        if (!record.isActive()) {
            record.setActive();
            record.setCreationTime(System.currentTimeMillis());
        }
    }

    boolean shouldRemove(Record record, long now) {
        return record.isRemovable() && now - record.getRemoveTime() > this.removeDelayMillis;
    }

    void markAsRemoved(Record record) {
        if (record.isActive()) {
            record.markRemoved();
            this.mapRecordEntries.remove(record.getId());
        }
        record.setValue(null);
        record.setMultiValues(null);
        this.updateIndexes(record);
        this.markAsDirty(record);
    }

    void removeAndPurgeRecord(Record record) {
        this.mapRecordEntries.remove(record.getId());
        this.mapRecords.remove(record.getKey());
        this.mapIndexService.remove(record);
    }

    void updateIndexes(Record record) {
        this.mapIndexService.index(record);
    }

    Record createNewRecord(Data key, Data value) {
        if (key == null || key.size() == 0) {
            throw new RuntimeException("Cannot create record from a 0 size key: " + key);
        }
        int blockId = this.concurrentMapManager.getBlockId(key);
        return new Record(this, blockId, key, value, this.ttl, this.maxIdle, this.concurrentMapManager.newRecordId());
    }

    public void addListener(Data key, Address address, boolean includeValue) {
        if (key == null || key.size() == 0) {
            this.mapListeners.put(address, includeValue);
        } else {
            Record rec = this.getRecord(key);
            if (rec == null) {
                rec = this.createNewRecord(key, null);
                this.mapRecords.put(key, rec);
            }
            rec.addListener(address, includeValue);
        }
    }

    public void removeListener(Data key, Address address) {
        if (key == null || key.size() == 0) {
            this.mapListeners.remove(address);
        } else {
            Record rec = this.getRecord(key);
            if (rec != null) {
                rec.removeListener(address);
            }
        }
    }

    public void appendState(StringBuffer sbState) {
        sbState.append("\nCMap [");
        sbState.append(this.name);
        sbState.append("] r:");
        sbState.append(this.mapRecords.size());
        if (this.locallyOwnedMap != null) {
            this.locallyOwnedMap.appendState(sbState);
        }
        if (this.mapNearCache != null) {
            this.mapNearCache.appendState(sbState);
        }
        this.mapIndexService.appendState(sbState);
    }

    public String toString() {
        return "CMap [" + this.getName() + "] size=" + this.size();
    }

    public String getName() {
        return this.name;
    }

    public MapIndexService getMapIndexService() {
        return this.mapIndexService;
    }

    public static class CMapEntry
    implements HazelcastInstanceAware,
    MapEntry,
    DataSerializable {
        private long cost = 0L;
        private long expirationTime = 0L;
        private long lastAccessTime = 0L;
        private long lastUpdateTime = 0L;
        private long creationTime = 0L;
        private long version = 0L;
        private int hits = 0;
        private boolean valid = true;
        private String name = null;
        private Object key = null;
        private Object value = null;
        private HazelcastInstance hazelcastInstance = null;

        public CMapEntry() {
        }

        public CMapEntry(long cost, long expirationTime, long lastAccessTime, long lastUpdateTime, long creationTime, long version, int hits, boolean valid) {
            this.cost = cost;
            this.expirationTime = expirationTime;
            this.lastAccessTime = lastAccessTime;
            this.lastUpdateTime = lastUpdateTime;
            this.creationTime = creationTime;
            this.version = version;
            this.hits = hits;
            this.valid = valid;
        }

        public void writeData(DataOutput out) throws IOException {
            out.writeLong(this.cost);
            out.writeLong(this.expirationTime);
            out.writeLong(this.lastAccessTime);
            out.writeLong(this.lastUpdateTime);
            out.writeLong(this.creationTime);
            out.writeLong(this.version);
            out.writeInt(this.hits);
            out.writeBoolean(this.valid);
        }

        public void readData(DataInput in) throws IOException {
            this.cost = in.readLong();
            this.expirationTime = in.readLong();
            this.lastAccessTime = in.readLong();
            this.lastUpdateTime = in.readLong();
            this.creationTime = in.readLong();
            this.version = in.readLong();
            this.hits = in.readInt();
            this.valid = in.readBoolean();
        }

        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
            this.hazelcastInstance = hazelcastInstance;
        }

        public void set(String name, Object key) {
            this.name = name;
            this.key = key;
        }

        public long getCost() {
            return this.cost;
        }

        public long getCreationTime() {
            return this.creationTime;
        }

        public long getExpirationTime() {
            return this.expirationTime;
        }

        public long getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public int getHits() {
            return this.hits;
        }

        public long getLastAccessTime() {
            return this.lastAccessTime;
        }

        public long getVersion() {
            return this.version;
        }

        public boolean isValid() {
            return this.valid;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            if (this.value == null) {
                FactoryImpl factory = (FactoryImpl)this.hazelcastInstance;
                this.value = ((MProxy)factory.getOrCreateProxyByName(this.name)).get(this.key);
            }
            return this.value;
        }

        public Object setValue(Object value) {
            Object oldValue = this.value;
            FactoryImpl factory = (FactoryImpl)this.hazelcastInstance;
            ((MProxy)factory.getOrCreateProxyByName(this.name)).put(this.key, value);
            return oldValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CMapEntry cMapEntry = (CMapEntry)o;
            return !(this.key == null ? cMapEntry.key != null : !this.key.equals(cMapEntry.key)) && !(this.name == null ? cMapEntry.name != null : !this.name.equals(cMapEntry.name));
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
            return result;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("MapEntry");
            sb.append("{key=").append(this.key);
            sb.append(", valid=").append(this.valid);
            sb.append(", hits=").append(this.hits);
            sb.append(", version=").append(this.version);
            sb.append(", creationTime=").append(this.creationTime);
            sb.append(", lastUpdateTime=").append(this.lastUpdateTime);
            sb.append(", lastAccessTime=").append(this.lastAccessTime);
            sb.append(", expirationTime=").append(this.expirationTime);
            sb.append(", cost=").append(this.cost);
            sb.append('}');
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Values
    implements Collection,
    DataSerializable {
        Collection<Data> lsValues = null;

        public Values() {
        }

        public Values(Collection<Data> lsValues) {
            this.lsValues = lsValues;
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                throw new IllegalArgumentException("Contains cannot have null argument.");
            }
            for (Object v : this) {
                if (!o.equals(v)) continue;
                return true;
            }
            return false;
        }

        public boolean containsAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public Iterator iterator() {
            return new ValueIterator(this.lsValues.iterator());
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.lsValues == null ? 0 : this.lsValues.size();
        }

        @Override
        public Object[] toArray() {
            if (this.size() == 0) {
                return null;
            }
            return this.toArray(new Object[this.size()]);
        }

        public Object[] toArray(Object[] a) {
            int size = this.size();
            if (size == 0) {
                return null;
            }
            if (a == null || a.length < size) {
                a = new Object[size];
            }
            Iterator<Data> it = this.lsValues.iterator();
            int index = 0;
            while (it.hasNext()) {
                a[index++] = IOUtil.toObject(it.next());
            }
            return a;
        }

        @Override
        public void readData(DataInput in) throws IOException {
            int size = in.readInt();
            this.lsValues = new ArrayList<Data>(size);
            for (int i = 0; i < size; ++i) {
                Data data = new Data();
                data.readData(in);
                this.lsValues.add(data);
            }
        }

        @Override
        public void writeData(DataOutput out) throws IOException {
            int size = this.lsValues == null ? 0 : this.lsValues.size();
            out.writeInt(size);
            if (size > 0) {
                for (Data data : this.lsValues) {
                    data.writeData(out);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ValueIterator
        implements Iterator {
            final Iterator<Data> it;

            public ValueIterator(Iterator<Data> it) {
                this.it = it;
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            public Object next() {
                Data value = this.it.next();
                return IOUtil.toObject(value);
            }

            @Override
            public void remove() {
                this.it.remove();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum EvictionPolicy {
        LRU,
        LFU,
        NONE;

    }
}

