/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.nio.Address;
import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Block
implements DataSerializable {
    private int blockId;
    private Address owner;
    private Address migrationAddress;
    private int hash = Integer.MIN_VALUE;
    private boolean migrationStarted = false;

    public Block() {
    }

    public Block(Block block) {
        this(block.blockId, block.owner);
        this.migrationAddress = block.migrationAddress;
    }

    public Block(int blockId, Address owner) {
        this.blockId = blockId;
        this.setOwner(owner);
    }

    public int getBlockId() {
        return this.blockId;
    }

    public boolean isMigrationStarted() {
        return this.migrationStarted;
    }

    public void setMigrationStarted(boolean migrationStarted) {
        this.migrationStarted = migrationStarted;
    }

    public Address getOwner() {
        return this.owner;
    }

    public void setOwner(Address owner) {
        this.owner = owner;
        this.hash = Integer.MIN_VALUE;
    }

    public Address getMigrationAddress() {
        return this.migrationAddress;
    }

    public void setMigrationAddress(Address migrationAddress) {
        this.migrationAddress = migrationAddress;
        if (migrationAddress == null) {
            this.migrationStarted = false;
        }
        this.hash = Integer.MIN_VALUE;
    }

    public boolean isMigrating() {
        return this.getMigrationAddress() != null;
    }

    public void readOwnership(DataInput in) throws IOException {
        this.blockId = in.readInt();
        boolean owned = in.readBoolean();
        if (owned) {
            this.owner = new Address();
            this.owner.readData(in);
        }
    }

    public void readData(DataInput in) throws IOException {
        this.readOwnership(in);
        boolean migrating = in.readBoolean();
        if (migrating) {
            this.setMigrationAddress(new Address());
            this.getMigrationAddress().readData(in);
        }
    }

    public void writeOwnership(DataOutput out) throws IOException {
        out.writeInt(this.blockId);
        boolean owned = this.owner != null;
        out.writeBoolean(owned);
        if (owned) {
            this.owner.writeData(out);
        }
    }

    public void writeData(DataOutput out) throws IOException {
        this.writeOwnership(out);
        boolean migrating = this.getMigrationAddress() != null;
        out.writeBoolean(migrating);
        if (migrating) {
            this.getMigrationAddress().writeData(out);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Block block = (Block)o;
        return this.blockId == block.blockId;
    }

    public int hashCode() {
        return this.blockId;
    }

    public int customHash() {
        if (this.hash == Integer.MIN_VALUE) {
            int result = this.blockId;
            result = 31 * result + (this.owner != null ? this.owner.hashCode() : 0);
            this.hash = result = 31 * result + (this.migrationAddress != null ? this.migrationAddress.hashCode() : 0);
        }
        return this.hash;
    }

    public String toString() {
        return "Block [" + this.getBlockId() + "] owner=" + this.getOwner() + " migrationAddress=" + this.getMigrationAddress();
    }
}

