/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.core;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.Member;
import java.util.EventObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryEvent<K, V>
extends EventObject {
    private static final long serialVersionUID = -2296203982913729851L;
    public static final int TYPE_ADDED = EntryEventType.ADDED.getType();
    public static final int TYPE_REMOVED = EntryEventType.REMOVED.getType();
    public static final int TYPE_UPDATED = EntryEventType.UPDATED.getType();
    public static final int TYPE_EVICTED = EntryEventType.EVICTED.getType();
    protected EntryEventType entryEventType = EntryEventType.ADDED;
    protected K key;
    protected V value;
    protected Member member;
    protected final String name;
    protected boolean collection;

    public EntryEvent(Object source) {
        super(source);
        this.name = (String)source;
        this.collection = !this.name.startsWith("c:") && !this.name.startsWith("m:u:");
    }

    public EntryEvent(Object source, Member member, int eventType, K key, V value) {
        this(source);
        this.member = member;
        this.key = key;
        this.value = value;
        this.entryEventType = this.entryEventType.getByType(eventType);
    }

    @Override
    public Object getSource() {
        return this.name;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public Member getMember() {
        return this.member;
    }

    public EntryEventType getEventType() {
        return this.entryEventType;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return "EntryEvent {" + this.getSource() + "} key=" + this.getKey() + ", value=" + this.getValue() + ", event=" + (Object)((Object)this.entryEventType);
    }
}

