/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

public class ExecutorConfig {
    public static final int DEFAULT_CORE_POOL_SIZE = 40;
    public static final int DEFAULT_MAX_POOL_SIZE = 40;
    public static final int DEFAULT_KEEP_ALIVE_SECONDS = 300;
    private String name = "default";
    private int corePoolSize = 40;
    private int maxPoolSize = 40;
    private int keepAliveSeconds = 300;

    public ExecutorConfig() {
    }

    public ExecutorConfig(String name) {
        this.name = name;
    }

    public ExecutorConfig(String name, int corePoolSize, int maxPoolSize, int keepAliveSeconds) {
        this.name = name;
        this.corePoolSize = corePoolSize;
        this.maxPoolSize = maxPoolSize;
        this.keepAliveSeconds = keepAliveSeconds;
    }

    public String getName() {
        return this.name;
    }

    public ExecutorConfig setName(String name) {
        this.name = name;
        return this;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public ExecutorConfig setCorePoolSize(int corePoolSize) {
        if (corePoolSize <= 0) {
            throw new IllegalArgumentException("corePoolSize must be positive");
        }
        this.corePoolSize = corePoolSize;
        return this;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public ExecutorConfig setMaxPoolSize(int maxPoolSize) {
        if (maxPoolSize <= 0) {
            throw new IllegalArgumentException("maxPoolSize must be positive");
        }
        this.maxPoolSize = maxPoolSize;
        return this;
    }

    public int getKeepAliveSeconds() {
        return this.keepAliveSeconds;
    }

    public ExecutorConfig setKeepAliveSeconds(int keepAliveSeconds) {
        if (keepAliveSeconds <= 0) {
            throw new IllegalArgumentException("keepAlice seconds must be positive");
        }
        this.keepAliveSeconds = keepAliveSeconds;
        return this;
    }
}

