/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.cluster.AbstractRemotelyCallable;
import com.hazelcast.cluster.AbstractRemotelyProcessable;
import com.hazelcast.cluster.AddOrRemoveConnection;
import com.hazelcast.cluster.ConnectionCheckCall;
import com.hazelcast.cluster.FinalizeJoin;
import com.hazelcast.cluster.InitialProcess;
import com.hazelcast.cluster.JoinRequest;
import com.hazelcast.cluster.Master;
import com.hazelcast.cluster.MemberInfo;
import com.hazelcast.cluster.MemberRemover;
import com.hazelcast.cluster.MembersUpdateCall;
import com.hazelcast.cluster.RemotelyProcessable;
import com.hazelcast.cluster.SyncProcess;
import com.hazelcast.core.Member;
import com.hazelcast.impl.BaseManager;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.NodeType;
import com.hazelcast.impl.Processable;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.impl.base.Call;
import com.hazelcast.impl.base.PacketProcessor;
import com.hazelcast.impl.base.ScheduledAction;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionListener;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.Packet;
import com.hazelcast.util.Prioritized;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClusterManager
extends BaseManager
implements ConnectionListener {
    private final long WAIT_MILLIS_BEFORE_JOIN;
    private final long MAX_NO_HEARTBEAT_MILLIS;
    private final Set<ScheduledAction> setScheduledActions = new LinkedHashSet<ScheduledAction>(1000);
    private final Set<MemberInfo> setJoins = new LinkedHashSet<MemberInfo>(100);
    private boolean joinInProgress = false;
    private long timeToStartJoin = 0L;
    private final List<MemberImpl> lsMembersBefore = new ArrayList<MemberImpl>();

    public ClusterManager(final Node node) {
        super(node);
        this.WAIT_MILLIS_BEFORE_JOIN = (long)node.groupProperties.WAIT_SECONDS_BEFORE_JOIN.getInteger() * 1000L;
        this.MAX_NO_HEARTBEAT_MILLIS = (long)node.groupProperties.MAX_NO_HEARTBEAT_SECONDS.getInteger() * 1000L;
        node.clusterService.registerPeriodicRunnable(new Runnable(){

            public void run() {
                ClusterManager.this.heartBeater();
            }
        });
        node.clusterService.registerPeriodicRunnable(new Runnable(){

            public void run() {
                ClusterManager.this.checkScheduledActions();
            }
        });
        node.connectionManager.addConnectionListener(this);
        this.registerPacketProcessor(ClusterOperation.RESPONSE, new PacketProcessor(){

            public void process(Packet packet) {
                ClusterManager.this.handleResponse(packet);
            }
        });
        this.registerPacketProcessor(ClusterOperation.HEARTBEAT, new PacketProcessor(){

            public void process(Packet packet) {
                ClusterManager.this.releasePacket(packet);
            }
        });
        this.registerPacketProcessor(ClusterOperation.REMOTELY_PROCESS_AND_RESPOND, new PacketProcessor(){

            public void process(Packet packet) {
                Data data = packet.getValueData();
                RemotelyProcessable rp = (RemotelyProcessable)IOUtil.toObject(data);
                rp.setConnection(packet.conn);
                rp.setNode(node);
                rp.process();
                ClusterManager.this.sendResponse(packet);
            }
        });
        this.registerPacketProcessor(ClusterOperation.REMOTELY_PROCESS, new PacketProcessor(){

            public void process(Packet packet) {
                Data data = packet.getValueData();
                RemotelyProcessable rp = (RemotelyProcessable)IOUtil.toObject(data);
                rp.setConnection(packet.conn);
                rp.setNode(node);
                rp.process();
                ClusterManager.this.releasePacket(packet);
            }
        });
        this.registerPacketProcessor(ClusterOperation.REMOTELY_CALLABLE_BOOLEAN, new PacketProcessor(){

            public void process(Packet packet) {
                Boolean result;
                AbstractRemotelyCallable callable = null;
                try {
                    Data data = packet.getValueData();
                    callable = (AbstractRemotelyCallable)IOUtil.toObject(data);
                    callable.setConnection(packet.conn);
                    callable.setNode(node);
                    result = (Boolean)callable.call();
                }
                catch (Exception e) {
                    ClusterManager.this.logger.log(Level.SEVERE, "Error processing " + callable, e);
                    result = Boolean.FALSE;
                }
                if (result == Boolean.TRUE) {
                    ClusterManager.this.sendResponse(packet);
                } else {
                    ClusterManager.this.sendResponseFailure(packet);
                }
            }
        });
        this.registerPacketProcessor(ClusterOperation.REMOTELY_CALLABLE_OBJECT, new PacketProcessor(){

            public void process(Packet packet) {
                Object result;
                AbstractRemotelyCallable callable = null;
                try {
                    Data data = packet.getValueData();
                    callable = (AbstractRemotelyCallable)IOUtil.toObject(data);
                    callable.setConnection(packet.conn);
                    callable.setNode(node);
                    result = callable.call();
                }
                catch (Exception e) {
                    ClusterManager.this.logger.log(Level.SEVERE, "Error processing " + callable, e);
                    result = null;
                }
                if (result != null) {
                    Data value = result instanceof Data ? (Data)result : IOUtil.toData(result);
                    packet.setValue(value);
                }
                ClusterManager.this.sendResponse(packet);
            }
        });
    }

    public final void heartBeater() {
        block15: {
            long now;
            block14: {
                if (!this.node.joined()) {
                    return;
                }
                now = System.currentTimeMillis();
                if (!this.isMaster()) break block14;
                ArrayList<Address> lsDeadAddresses = null;
                for (MemberImpl memberImpl : this.lsMembers) {
                    Address address = memberImpl.getAddress();
                    if (this.thisAddress.equals(address)) continue;
                    try {
                        Connection conn = this.node.connectionManager.getConnection(address);
                        if (conn != null && conn.live() && now - memberImpl.getLastRead() >= this.MAX_NO_HEARTBEAT_MILLIS) {
                            conn = null;
                            if (lsDeadAddresses == null) {
                                lsDeadAddresses = new ArrayList<Address>();
                            }
                            this.logger.log(Level.WARNING, "Added " + address + " to list of dead addresses because of timeout since last read");
                            lsDeadAddresses.add(address);
                        }
                        if (conn == null || !conn.live() || now - memberImpl.getLastWrite() <= 500L) continue;
                        Packet packet = this.obtainPacket("heartbeat", null, null, ClusterOperation.HEARTBEAT, 0L);
                        this.sendOrReleasePacket(packet, conn);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
                if (lsDeadAddresses == null) break block15;
                for (Address address : lsDeadAddresses) {
                    this.logger.log(Level.FINEST, "NO HEARTBEAT should remove " + address);
                    this.doRemoveAddress(address);
                    this.sendRemoveMemberToOthers(address);
                }
                break block15;
            }
            if (this.getMasterAddress() != null) {
                MemberImpl masterMember = this.getMember(this.getMasterAddress());
                boolean removed = false;
                if (masterMember != null && now - masterMember.getLastRead() >= this.MAX_NO_HEARTBEAT_MILLIS) {
                    this.logger.log(Level.FINEST, "Master node has timed out it's heartbeat and will be removed");
                    this.doRemoveAddress(this.getMasterAddress());
                    removed = true;
                }
                if (!removed) {
                    Packet packet = this.obtainPacket("heartbeat", null, null, ClusterOperation.HEARTBEAT, 0L);
                    Connection connMaster = this.node.connectionManager.getOrConnect(this.getMasterAddress());
                    this.sendOrReleasePacket(packet, connMaster);
                }
            }
            for (MemberImpl member : this.lsMembers) {
                Packet packet;
                Connection conn;
                if (member.localMember()) continue;
                Address address = member.getAddress();
                if (this.shouldConnectTo(address)) {
                    conn = this.node.connectionManager.getOrConnect(address);
                    if (conn != null) {
                        packet = this.obtainPacket("heartbeat", null, null, ClusterOperation.HEARTBEAT, 0L);
                        this.sendOrReleasePacket(packet, conn);
                        continue;
                    }
                    this.logger.log(Level.FINEST, "could not connect to " + address + " to send heartbeat");
                    continue;
                }
                conn = this.node.connectionManager.getConnection(address);
                if (conn != null && conn.live()) {
                    if (now - member.getLastWrite() <= 500L) continue;
                    packet = this.obtainPacket("heartbeat", null, null, ClusterOperation.HEARTBEAT, 0L);
                    this.sendOrReleasePacket(packet, conn);
                    continue;
                }
                this.logger.log(Level.FINEST, "not sending heartbeat because connection is null or not live " + address);
            }
        }
    }

    public boolean shouldConnectTo(Address address) {
        return !this.node.joined() || this.lsMembers.indexOf(this.getMember(this.thisAddress)) > this.lsMembers.indexOf(this.getMember(address));
    }

    private void sendRemoveMemberToOthers(Address deadAddress) {
        for (MemberImpl member : this.lsMembers) {
            Address address = member.getAddress();
            if (this.thisAddress.equals(address) || address.equals(deadAddress)) continue;
            this.sendProcessableTo((RemotelyProcessable)new MemberRemover(deadAddress), address);
        }
    }

    public void handleMaster(Master master) {
        if (!this.node.joined() && !this.thisAddress.equals(master.address)) {
            this.node.setMasterAddress(master.address);
            Connection connMaster = this.node.connectionManager.getOrConnect(master.address);
            if (connMaster != null) {
                this.sendJoinRequest(master.address);
            }
        }
    }

    public void handleAddRemoveConnection(AddOrRemoveConnection connection) {
        if (connection.add) {
            if (!connection.address.equals(this.thisAddress)) {
                this.node.connectionManager.getOrConnect(connection.address);
            }
        } else if (connection.address != null) {
            this.doRemoveAddress(connection.address);
        }
    }

    void doRemoveAddress(Address deadAddress) {
        MemberImpl deadMember;
        Connection conn;
        this.logger.log(Level.FINEST, "Removing Address " + deadAddress);
        if (!this.node.joined()) {
            this.node.failedConnection(deadAddress);
            return;
        }
        if (deadAddress.equals(this.thisAddress)) {
            return;
        }
        if (deadAddress.equals(this.getMasterAddress())) {
            if (this.node.joined()) {
                MemberImpl newMaster = this.getNextMemberAfter(deadAddress, false, 1);
                if (newMaster != null) {
                    this.node.setMasterAddress(newMaster.getAddress());
                } else {
                    this.node.setMasterAddress(null);
                }
            } else {
                this.node.setMasterAddress(null);
            }
            this.logger.log(Level.FINEST, "Now Master " + this.node.getMasterAddress());
        }
        if (this.isMaster()) {
            this.setJoins.remove(new MemberInfo(deadAddress));
        }
        if ((conn = this.node.connectionManager.getConnection(deadAddress)) != null) {
            this.node.connectionManager.remove(conn);
        }
        if ((deadMember = this.getMember(deadAddress)) != null) {
            Object[] calls;
            this.lsMembersBefore.clear();
            for (MemberImpl memberBefore : this.lsMembers) {
                this.lsMembersBefore.add(memberBefore);
            }
            this.removeMember(deadAddress);
            this.node.blockingQueueManager.syncForDead(deadAddress);
            this.node.concurrentMapManager.syncForDead(deadMember);
            this.node.listenerManager.syncForDead(deadAddress);
            this.node.topicManager.syncForDead(deadAddress);
            this.node.getClusterImpl().setMembers(this.lsMembers);
            for (Object call : calls = this.mapCalls.values().toArray()) {
                ((Call)call).onDisconnect(deadAddress);
            }
            this.logger.log(Level.INFO, this.toString());
        }
    }

    public List<MemberImpl> getMembersBeforeSync() {
        return this.lsMembersBefore;
    }

    public boolean isNextOrPreviousChanged() {
        return this.isNextChanged() || this.isPreviousChanged();
    }

    public boolean isNextChanged() {
        MemberImpl nextMemberBefore = this.getNextMemberBeforeSync(this.thisAddress, true, 1);
        MemberImpl nextMemberNow = this.getNextMemberAfter(this.thisAddress, true, 1);
        if (nextMemberBefore == null) {
            return nextMemberNow != null;
        }
        return !((Object)nextMemberBefore).equals(nextMemberNow);
    }

    public boolean isPreviousChanged() {
        int indexBefore = this.lsMembersBefore.indexOf(this.thisMember);
        int indexNow = this.lsMembers.indexOf(this.thisMember);
        MemberImpl previousMemberBefore = this.getMemberAt(this.lsMembersBefore, indexBefore - 1);
        MemberImpl previousMemberNow = this.getMemberAt(this.lsMembers, indexNow - 1);
        if (previousMemberBefore == null) {
            return previousMemberNow != null;
        }
        return !previousMemberBefore.equals(previousMemberNow);
    }

    public MemberImpl getMemberAt(List<MemberImpl> members, int index) {
        return members.get((index + members.size()) % members.size());
    }

    void handleJoinRequest(JoinRequest joinRequest) {
        this.logger.log(Level.FINEST, this.joinInProgress + " Handling " + joinRequest);
        if (this.getMember(joinRequest.address) != null) {
            return;
        }
        Connection conn = joinRequest.getConnection();
        if (this.node.validateJoinRequest(joinRequest)) {
            if (!this.node.getConfig().getNetworkConfig().getJoin().getMulticastConfig().isEnabled() && this.node.getMasterAddress() != null && !this.isMaster()) {
                this.sendProcessableTo((RemotelyProcessable)new Master(this.node.getMasterAddress()), conn);
            }
            if (this.isMaster()) {
                if (joinRequest.to != null && !joinRequest.to.equals(this.thisAddress)) {
                    this.sendProcessableTo((RemotelyProcessable)new Master(this.node.getMasterAddress()), conn);
                    return;
                }
                if (!this.joinInProgress) {
                    MemberInfo newMemberInfo = new MemberInfo(joinRequest.address, joinRequest.nodeType);
                    if (this.setJoins.add(newMemberInfo)) {
                        this.sendProcessableTo((RemotelyProcessable)new Master(this.node.getMasterAddress()), conn);
                        this.timeToStartJoin = System.currentTimeMillis() + this.WAIT_MILLIS_BEFORE_JOIN;
                    } else if (System.currentTimeMillis() > this.timeToStartJoin) {
                        this.startJoin();
                    }
                }
            }
        } else {
            conn.close();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("\n\nMembers [");
        sb.append(this.lsMembers.size());
        sb.append("] {");
        for (MemberImpl member : this.lsMembers) {
            sb.append("\n\t").append(member);
        }
        sb.append("\n}\n");
        return sb.toString();
    }

    public int getMemberDistance(Address target) {
        int indexThis = -1;
        int indexTarget = -1;
        int index = 0;
        for (MemberImpl member : this.lsMembers) {
            if (member.getAddress().equals(this.thisAddress)) {
                indexThis = index;
            } else if (member.getAddress().equals(target)) {
                indexTarget = index;
            }
            if (indexThis > -1 && indexTarget > -1) {
                int distance = indexThis - indexTarget;
                if (distance < 0) {
                    distance += this.lsMembers.size();
                }
                return distance;
            }
            ++index;
        }
        return 0;
    }

    public Packet createRemotelyProcessablePacket(RemotelyProcessable rp) {
        Data value = ThreadContext.get().toData(rp);
        Packet packet = this.obtainPacket();
        packet.set("remotelyProcess", ClusterOperation.REMOTELY_PROCESS, null, value);
        return packet;
    }

    public void sendProcessableTo(RemotelyProcessable rp, Connection conn) {
        Packet packet = this.createRemotelyProcessablePacket(rp);
        boolean sent = this.send(packet, conn);
        if (!sent) {
            this.releasePacket(packet);
        }
    }

    void joinReset() {
        this.joinInProgress = false;
        this.setJoins.clear();
        this.timeToStartJoin = System.currentTimeMillis() + this.WAIT_MILLIS_BEFORE_JOIN;
    }

    public void finalizeJoin() {
        ArrayList<AsyncRemotelyBooleanCallable> calls = new ArrayList<AsyncRemotelyBooleanCallable>();
        for (MemberImpl member : this.lsMembers) {
            if (member.localMember()) continue;
            AsyncRemotelyBooleanCallable rrp = new AsyncRemotelyBooleanCallable();
            rrp.executeProcess(member.getAddress(), new FinalizeJoin());
            calls.add(rrp);
        }
        for (AsyncRemotelyBooleanCallable call : calls) {
            call.getResultAsBoolean();
        }
    }

    void startJoin() {
        this.joinInProgress = true;
        MembersUpdateCall membersUpdate = new MembersUpdateCall(this.lsMembers, this.node.getClusterImpl().getClusterTime());
        if (this.setJoins != null && this.setJoins.size() > 0) {
            for (MemberInfo memberJoined : this.setJoins) {
                membersUpdate.addMemberInfo(memberJoined);
            }
        }
        this.node.executorManager.executeMigrationTask(new JoinRunnable(membersUpdate));
    }

    void updateMembers(Collection<MemberInfo> lsMemberInfos) {
        this.logger.log(Level.FINEST, "MEMBERS UPDATE!!");
        this.lsMembersBefore.clear();
        HashMap<Address, MemberImpl> mapOldMembers = new HashMap<Address, MemberImpl>();
        for (MemberImpl member : this.lsMembers) {
            this.lsMembersBefore.add(member);
            mapOldMembers.put(member.getAddress(), member);
        }
        this.lsMembers.clear();
        for (MemberInfo memberInfo : lsMemberInfos) {
            MemberImpl member = (MemberImpl)mapOldMembers.get(memberInfo.address);
            if (member == null) {
                member = this.addMember(memberInfo.address, memberInfo.nodeType);
            } else {
                this.addMember(member);
            }
            member.didRead();
        }
        if (!this.lsMembers.contains(this.thisMember)) {
            throw new RuntimeException("Member list doesn't contain local member!");
        }
        this.mapMembers.clear();
        for (MemberImpl member : this.lsMembers) {
            this.mapMembers.put(member.getAddress(), member);
        }
        this.heartBeater();
        this.node.getClusterImpl().setMembers(this.lsMembers);
        this.node.unlock();
        this.logger.log(Level.INFO, this.toString());
    }

    public void sendJoinRequest(Address toAddress) {
        if (toAddress == null) {
            toAddress = this.node.getMasterAddress();
        }
        this.sendProcessableTo((RemotelyProcessable)new JoinRequest(this.thisAddress, this.node.getConfig().getGroupConfig().getName(), this.node.getConfig().getGroupConfig().getPassword(), this.node.getLocalNodeType(), Packet.PACKET_VERSION, this.node.getBuildNumber()), toAddress);
    }

    public void registerScheduledAction(ScheduledAction scheduledAction) {
        this.setScheduledActions.add(scheduledAction);
    }

    public void deregisterScheduledAction(ScheduledAction scheduledAction) {
        this.setScheduledActions.remove(scheduledAction);
    }

    public void checkScheduledActions() {
        if (this.setScheduledActions.size() > 0) {
            Iterator<ScheduledAction> it = this.setScheduledActions.iterator();
            while (it.hasNext()) {
                ScheduledAction sa = it.next();
                if (!sa.expired()) continue;
                sa.onExpire();
                it.remove();
            }
        }
    }

    public RemotelyProcessable createInitialProcess() {
        InitialProcess initialProcess = new InitialProcess();
        List<AbstractRemotelyProcessable> lsProcessables = initialProcess.getProcessables();
        this.node.listenerManager.collectInitialProcess(lsProcessables);
        return initialProcess;
    }

    @Override
    public void connectionAdded(final Connection connection) {
        this.enqueueAndReturn(new Processable(){

            public void process() {
                MemberImpl member = ClusterManager.this.getMember(connection.getEndPoint());
                if (member != null) {
                    member.didRead();
                }
                if (!ClusterManager.this.thisAddress.equals(connection.getEndPoint())) {
                    ClusterManager.this.sendProcessableTo(ClusterManager.this.createInitialProcess(), connection);
                }
            }
        });
    }

    @Override
    public void connectionRemoved(Connection connection) {
        this.logger.log(Level.FINEST, "Connection is removed " + connection.getEndPoint());
        if (!this.node.joined() && this.getMasterAddress() != null && this.getMasterAddress().equals(connection.getEndPoint())) {
            this.node.setMasterAddress(null);
        }
    }

    public Member addMember(MemberImpl member) {
        this.logger.log(Level.FINEST, "ClusterManager adding " + member);
        if (this.lsMembers.contains(member)) {
            for (MemberImpl m : this.lsMembers) {
                if (!m.equals(member)) continue;
                member = m;
            }
        } else {
            if (!member.getAddress().equals(this.thisAddress)) {
                this.node.connectionManager.getConnection(member.getAddress());
            }
            this.lsMembers.add(member);
        }
        return member;
    }

    protected void removeMember(Address address) {
        this.logger.log(Level.FINEST, "removing  " + address);
        MemberImpl member = (MemberImpl)this.mapMembers.remove(address);
        if (member != null) {
            this.lsMembers.remove(member);
        }
    }

    protected MemberImpl createMember(Address address, NodeType nodeType) {
        return new MemberImpl(address, this.thisAddress.equals(address), nodeType);
    }

    public MemberImpl getMember(Address address) {
        return (MemberImpl)this.mapMembers.get(address);
    }

    public final MemberImpl addMember(Address address, NodeType nodeType) {
        if (address == null) {
            this.logger.log(Level.FINEST, "Address cannot be null");
            return null;
        }
        MemberImpl member = this.getMember(address);
        if (member == null) {
            member = this.createMember(address, nodeType);
        }
        this.addMember(member);
        return member;
    }

    public void stop() {
        if (this.setJoins != null) {
            this.setJoins.clear();
        }
        this.timeToStartJoin = 0L;
        if (this.lsMembers != null) {
            this.lsMembers.clear();
        }
        if (this.mapMembers != null) {
            this.mapMembers.clear();
        }
        if (this.lsMembersBefore != null) {
            this.lsMembersBefore.clear();
        }
        if (this.mapCalls != null) {
            this.mapCalls.clear();
        }
    }

    class JoinRunnable
    implements Runnable,
    Prioritized {
        final MembersUpdateCall membersUpdate;

        JoinRunnable(MembersUpdateCall membersUpdate) {
            this.membersUpdate = membersUpdate;
        }

        public void run() {
            Collection<MemberInfo> lsMemberInfos = this.membersUpdate.getMemberInfos();
            ArrayList<Address> newMemberList = new ArrayList<Address>(lsMemberInfos.size());
            for (MemberInfo memberInfo : lsMemberInfos) {
                newMemberList.add(memberInfo.address);
            }
            ArrayList<AsyncRemotelyBooleanCallable> calls = new ArrayList<AsyncRemotelyBooleanCallable>(lsMemberInfos.size());
            for (Address target : newMemberList) {
                AsyncRemotelyBooleanCallable rrp = new AsyncRemotelyBooleanCallable();
                rrp.executeProcess(target, this.membersUpdate);
                calls.add(rrp);
            }
            for (AsyncRemotelyBooleanCallable call : calls) {
                if (call.getResultAsBoolean() != Boolean.FALSE.booleanValue()) continue;
                newMemberList.remove(call.getTarget());
            }
            calls.clear();
            for (Address target : newMemberList) {
                AsyncRemotelyBooleanCallable call = new AsyncRemotelyBooleanCallable();
                call.executeProcess(target, new SyncProcess());
                calls.add(call);
            }
            for (AsyncRemotelyBooleanCallable call : calls) {
                if (call.getResultAsBoolean() != Boolean.FALSE.booleanValue()) continue;
                newMemberList.remove(call.getTarget());
            }
            calls.clear();
            ConnectionCheckCall connCheckCallable = new ConnectionCheckCall();
            for (Address target : newMemberList) {
                AsyncRemotelyBooleanCallable call = new AsyncRemotelyBooleanCallable();
                call.executeProcess(target, connCheckCallable);
                calls.add(call);
            }
            for (AsyncRemotelyBooleanCallable call : calls) {
                if (call.getResultAsBoolean() != Boolean.FALSE.booleanValue()) continue;
                newMemberList.remove(call.getTarget());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AsyncRemotelyBooleanCallable
    extends BaseManager.TargetAwareOp {
        AbstractRemotelyCallable<Boolean> arp;

        public AsyncRemotelyBooleanCallable() {
            super(ClusterManager.this);
            this.arp = null;
        }

        public void executeProcess(Address address, AbstractRemotelyCallable<Boolean> arp) {
            this.arp = arp;
            this.target = address;
            arp.setNode(ClusterManager.this.node);
            this.setLocal(ClusterOperation.REMOTELY_CALLABLE_BOOLEAN, "call", null, arp, 0L, -1L);
            this.request.setBooleanRequest();
            this.doOp();
        }

        @Override
        public Address getTarget() {
            return this.target;
        }

        @Override
        public void onDisconnect(Address dead) {
            if (dead.equals(this.target)) {
                ClusterManager.this.removeCall(this.getCallId());
                this.setResult(Boolean.FALSE);
            }
        }

        @Override
        public void process() {
            if (!ClusterManager.this.thisAddress.equals(this.target) && ((ClusterManager)ClusterManager.this).node.connectionManager.getConnection(this.target) == null) {
                this.setResult(Boolean.FALSE);
            } else {
                super.process();
            }
        }

        @Override
        public void doLocalOp() {
            try {
                Boolean result = (Boolean)this.arp.call();
                this.setResult(result);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void setTarget() {
        }
    }
}

