/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.util.ByteUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Packet {
    private int headerSize;
    private int keySize;
    private int valueSize;
    private byte[] headerInBytes;
    private byte[] key;
    private byte[] value;
    private String name;
    private ClusterOperation operation;
    private int blockId = 0;
    private int threadId;
    private int lockCount = 0;
    private long ttl = -1L;
    private long timeout = -1L;
    private long txnId = -1L;
    private long longValue;
    private long version = -1L;
    private byte responseType = (byte)2;
    private long callId = -1L;
    private byte indexCount = 0;
    private long[] indexes = new long[10];
    private byte[] indexTypes = new byte[10];
    private static final byte PACKET_VERSION = 5;

    public void writeTo(DataOutputStream outputStream) throws IOException {
        this.headerInBytes = this.getHeader();
        this.headerSize = this.headerInBytes.length;
        outputStream.writeInt(this.headerSize);
        outputStream.writeInt(this.keySize);
        outputStream.writeInt(this.valueSize);
        outputStream.writeByte(5);
        outputStream.write(this.headerInBytes);
        if (this.key != null) {
            outputStream.write(this.key);
        }
        if (this.value != null) {
            outputStream.write(this.value);
        }
    }

    public void readFrom(DataInputStream dis) throws IOException {
        this.headerSize = dis.readInt();
        this.keySize = dis.readInt();
        this.valueSize = dis.readInt();
        byte packetVersion = dis.readByte();
        if (packetVersion != 5) {
            throw new RuntimeException("Invalid packet version. Expected:5, Found:" + packetVersion);
        }
        this.headerInBytes = new byte[this.headerSize];
        dis.readFully(this.headerInBytes);
        ByteArrayInputStream bis = new ByteArrayInputStream(this.headerInBytes);
        DataInputStream dis2 = new DataInputStream(bis);
        this.operation = ClusterOperation.create(dis2.readByte());
        this.blockId = dis2.readInt();
        this.threadId = dis2.readInt();
        byte booleans = dis2.readByte();
        if (ByteUtil.isTrue(booleans, 0)) {
            this.lockCount = dis2.readInt();
        }
        if (ByteUtil.isTrue(booleans, 1)) {
            this.timeout = dis2.readLong();
        }
        if (ByteUtil.isTrue(booleans, 2)) {
            this.ttl = dis2.readLong();
        }
        if (ByteUtil.isTrue(booleans, 3)) {
            this.txnId = dis2.readLong();
        }
        if (ByteUtil.isTrue(booleans, 4)) {
            this.longValue = dis2.readLong();
        }
        if (ByteUtil.isTrue(booleans, 5)) {
            this.version = dis2.readLong();
        }
        if (!ByteUtil.isTrue(booleans, 7)) {
            throw new RuntimeException("LockAddress cannot be sent to the client!" + (Object)((Object)this.operation));
        }
        this.callId = dis2.readLong();
        this.responseType = dis2.readByte();
        int nameLength = dis2.readInt();
        if (nameLength > 0) {
            byte[] b = new byte[nameLength];
            dis2.readFully(b);
            this.name = new String(b);
        }
        this.indexCount = dis2.readByte();
        for (int i = 0; i < this.indexCount; ++i) {
            this.indexes[i] = dis2.readLong();
            this.indexTypes[i] = dis2.readByte();
        }
        this.key = new byte[this.keySize];
        dis.readFully(this.key);
        this.value = new byte[this.valueSize];
        dis.readFully(this.value);
    }

    private byte[] getHeader() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeByte(this.operation.getValue());
        dos.writeInt(this.blockId);
        dos.writeInt(this.threadId);
        byte booleans = 0;
        if (this.lockCount != 0) {
            booleans = ByteUtil.setTrue(booleans, 0);
        }
        if (this.timeout != -1L) {
            booleans = ByteUtil.setTrue(booleans, 1);
        }
        if (this.ttl != -1L) {
            booleans = ByteUtil.setTrue(booleans, 2);
        }
        if (this.txnId != -1L) {
            booleans = ByteUtil.setTrue(booleans, 3);
        }
        if (this.longValue != Long.MIN_VALUE) {
            booleans = ByteUtil.setTrue(booleans, 4);
        }
        if (this.version != -1L) {
            booleans = ByteUtil.setTrue(booleans, 5);
        }
        booleans = ByteUtil.setTrue(booleans, 6);
        booleans = ByteUtil.setTrue(booleans, 7);
        dos.writeByte(booleans);
        if (this.lockCount != 0) {
            dos.writeInt(this.lockCount);
        }
        if (this.timeout != -1L) {
            dos.writeLong(this.timeout);
        }
        if (this.ttl != -1L) {
            dos.writeLong(this.ttl);
        }
        if (this.txnId != -1L) {
            dos.writeLong(this.txnId);
        }
        if (this.longValue != Long.MIN_VALUE) {
            dos.writeLong(this.longValue);
        }
        if (this.version != -1L) {
            dos.writeLong(this.version);
        }
        dos.writeLong(this.callId);
        dos.writeByte(this.responseType);
        int nameLen = 0;
        byte[] nameInBytes = null;
        if (this.name != null) {
            nameInBytes = this.name.getBytes();
            nameLen = nameInBytes.length;
        }
        dos.writeInt(nameLen);
        if (nameLen > 0) {
            dos.write(nameInBytes);
        }
        dos.writeByte(this.indexCount);
        for (int i = 0; i < this.indexCount; ++i) {
            dos.writeLong(this.indexes[i]);
            dos.writeByte(this.indexTypes[i]);
        }
        return bos.toByteArray();
    }

    public void set(String name, ClusterOperation operation, byte[] key, byte[] value) {
        this.name = name;
        this.operation = operation;
        this.setKey(key);
        this.setValue(value);
    }

    public int getHeaderSize() {
        return this.headerSize;
    }

    public void setHeaderSize(int headerSize) {
        this.headerSize = headerSize;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    public int getValueSize() {
        return this.valueSize;
    }

    public void setValueSize(int valueSize) {
        this.valueSize = valueSize;
    }

    public byte[] getKey() {
        return this.key;
    }

    public void setKey(byte[] key) {
        this.key = key;
        if (key != null) {
            this.keySize = this.key.length;
        }
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
        if (value != null) {
            this.valueSize = this.value.length;
        }
    }

    public void setCallId(long callid) {
        this.callId = callid;
    }

    public long getCallId() {
        return this.callId;
    }

    public byte[] getHeaderInBytes() {
        return this.headerInBytes;
    }

    public void setHeaderInBytes(byte[] headerInBytes) {
        this.headerInBytes = headerInBytes;
        this.headerSize = headerInBytes.length;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ClusterOperation getOperation() {
        return this.operation;
    }

    public void setOperation(ClusterOperation operation) {
        this.operation = operation;
    }

    public int getBlockId() {
        return this.blockId;
    }

    public void setBlockId(int blockId) {
        this.blockId = blockId;
    }

    public int getThreadId() {
        return this.threadId;
    }

    public void setThreadId(int threadId) {
        this.threadId = threadId;
    }

    public int getLockCount() {
        return this.lockCount;
    }

    public void setLockCount(int lockCount) {
        this.lockCount = lockCount;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTxnId() {
        return this.txnId;
    }

    public void setTxnId(long txnId) {
        this.txnId = txnId;
    }

    public long getLongValue() {
        return this.longValue;
    }

    public void setLongValue(long longValue) {
        this.longValue = longValue;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public byte getResponseType() {
        return this.responseType;
    }

    public void setResponseType(byte responseType) {
        this.responseType = responseType;
    }

    public byte getIndexCount() {
        return this.indexCount;
    }

    public void setIndexCount(byte indexCount) {
        this.indexCount = indexCount;
    }

    public long[] getIndexes() {
        return this.indexes;
    }

    public void setIndexes(long[] indexes) {
        this.indexes = indexes;
    }

    public byte[] getIndexTypes() {
        return this.indexTypes;
    }

    public void setIndexTypes(byte[] indexTypes) {
        this.indexTypes = indexTypes;
    }

    public void clearForResponse() {
        this.name = null;
        this.key = null;
        this.value = null;
        this.blockId = -1;
        this.timeout = -1L;
        this.ttl = -1L;
        this.txnId = -1L;
        this.threadId = -1;
        this.lockCount = 0;
        this.longValue = Long.MIN_VALUE;
        this.version = -1L;
        this.indexes = null;
        this.indexTypes = null;
    }

    public String toString() {
        return "Packet [callId = " + this.callId + "  name = " + this.name + " operation = " + (Object)((Object)this.operation) + "]";
    }
}

