/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.Call;
import com.hazelcast.client.Connection;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.IORunnable;
import com.hazelcast.client.PacketWriter;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutRunnable
extends IORunnable {
    final PacketWriter writer;
    public final BlockingQueue<Call> queue = new LinkedBlockingQueue<Call>();
    final BlockingQueue<Call> temp = new LinkedBlockingQueue<Call>();
    private Connection connection = null;
    AtomicInteger counter = new AtomicInteger(0);
    ILogger logger = Logger.getLogger(this.getClass().toString());

    public OutRunnable(HazelcastClient client, Map<Long, Call> calls, PacketWriter writer) {
        super(client, calls);
        this.writer = writer;
    }

    @Override
    protected void customRun() throws InterruptedException {
        Call call = null;
        try {
            call = this.queue.poll(100L, TimeUnit.MILLISECONDS);
            if (call == null) {
                return;
            }
            this.counter.incrementAndGet();
            this.callMap.put(call.getId(), call);
            Connection oldConnection = this.connection;
            this.connection = this.client.getConnectionManager().getConnection();
            if (this.restoredConnection(oldConnection, this.connection)) {
                this.redoUnfinishedCalls(call, oldConnection);
            } else if (this.connection != null) {
                this.logger.log(Level.FINEST, "Sending: " + call);
                this.writer.write(this.connection, call.getRequest());
            } else {
                this.interruptWaitingCalls();
            }
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Throwable io) {
            this.logger.log(Level.FINE, "OutRunnable got an exception:" + io.getMessage());
            io.printStackTrace();
            this.enQueue(call);
            this.client.getConnectionManager().destroyConnection(this.connection);
        }
    }

    private void redoUnfinishedCalls(Call call, Connection oldConnection) {
        this.temp.add(call);
        this.queue.drainTo(this.temp);
        this.client.getListenerManager().getListenerCalls().drainTo(this.queue);
        this.temp.drainTo(this.queue);
        this.onDisconnect(oldConnection);
    }

    public void enQueue(Call call) {
        try {
            this.logger.log(Level.FINEST, "Enquing: " + call);
            this.queue.put(call);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

