/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.Call;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.Packet;
import com.hazelcast.client.ProxyHelper;
import com.hazelcast.client.Serializer;
import com.hazelcast.core.DistributedTask;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.core.MultiTask;
import com.hazelcast.impl.ClientDistributedTask;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.ExecutionManagerCallback;
import com.hazelcast.impl.InnerFutureTask;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutorServiceClientProxy
implements ExecutorService {
    final ProxyHelper proxyHelper;
    private final HazelcastClient client;
    private final String name;

    public ExecutorServiceClientProxy(HazelcastClient client, String name) {
        this.client = client;
        this.name = name;
        this.proxyHelper = new ProxyHelper(name, client);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public List<Runnable> shutdownNow() {
        return new ArrayList<Runnable>();
    }

    @Override
    public boolean isShutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isTerminated() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return false;
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        return this.submit(new DistributedTask<T>(callable));
    }

    private <T> Future<T> submit(DistributedTask dt) {
        ClientDistributedTask cdt = null;
        InnerFutureTask inner = (InnerFutureTask)dt.getInner();
        this.check(inner.getCallable());
        if (dt instanceof MultiTask && inner.getMembers() == null) {
            HashSet<Member> set = new HashSet<Member>();
            set.add(inner.getMember());
            cdt = new ClientDistributedTask(inner.getCallable(), null, set, null);
        }
        if (cdt == null) {
            cdt = new ClientDistributedTask(inner.getCallable(), inner.getMember(), inner.getMembers(), inner.getKey());
        }
        return this.submit(dt, cdt);
    }

    private <T> void check(Object o) {
        if (o == null) {
            throw new NullPointerException("Object cannot be null.");
        }
        if (!(o instanceof Serializable)) {
            throw new IllegalArgumentException(o.getClass().getName() + " is not Serializable.");
        }
    }

    private Future submit(final DistributedTask dt, ClientDistributedTask cdt) {
        Packet request = this.proxyHelper.prepareRequest(ClusterOperation.EXECUTE, cdt, null);
        final InnerFutureTask inner = (InnerFutureTask)dt.getInner();
        final Call call = new Call(ProxyHelper.newCallId(), request){

            public void onDisconnect(Member member) {
                this.setResponse(new MemberLeftException(member));
            }
        };
        inner.setExecutionManagerCallback(new ExecutionManagerCallback(){

            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            public void get() throws InterruptedException, ExecutionException {
                try {
                    Object response = call.getResponse();
                    this.handle(response);
                }
                catch (Throwable e) {
                    this.handle(e);
                }
            }

            public void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException {
                try {
                    Object response = call.getResponse(timeout, unit);
                    this.handle(response);
                }
                catch (Throwable e) {
                    this.handle(e);
                }
            }

            private void handle(Object response) {
                Object result = response;
                if (response == null) {
                    inner.innerSetException(new TimeoutException());
                } else {
                    if (response instanceof Packet) {
                        Packet responsePacket = (Packet)response;
                        result = Serializer.toObject(responsePacket.getValue());
                    }
                    if (result instanceof MemberLeftException) {
                        MemberLeftException memberLeftException = (MemberLeftException)result;
                        inner.innerSetMemberLeft(memberLeftException.getMember());
                    } else if (result instanceof Throwable) {
                        inner.innerSetException((Throwable)result);
                    } else if (dt instanceof MultiTask) {
                        if (result != null) {
                            Collection colResults = (Collection)result;
                            for (Object obj : colResults) {
                                inner.innerSet(obj);
                            }
                        } else {
                            inner.innerSet(result);
                        }
                    } else {
                        inner.innerSet(result);
                    }
                }
                inner.innerDone();
            }
        });
        this.proxyHelper.sendCall(call);
        return dt;
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t) {
        if (runnable instanceof DistributedTask) {
            return this.submit((DistributedTask)runnable);
        }
        return this.submit(DistributedTask.callable(runnable, t));
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        return this.submit(runnable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Future> invokeAll(Collection tasks) throws InterruptedException {
        if (tasks == null) {
            throw new NullPointerException();
        }
        ArrayList<Future> futures = new ArrayList<Future>(tasks.size());
        boolean done = false;
        try {
            for (Object command : tasks) {
                futures.add(this.submit((Callable)command));
            }
            for (Future f : futures) {
                if (f.isDone()) continue;
                try {
                    f.get();
                }
                catch (CancellationException ignore) {
                }
                catch (ExecutionException ignore) {}
            }
            done = true;
            ArrayList<Future> arrayList = futures;
            return arrayList;
        }
        finally {
            if (!done) {
                for (Future f : futures) {
                    f.cancel(true);
                }
            }
        }
    }

    public List invokeAll(Collection tasks, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    public Object invokeAny(Collection tasks) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException();
    }

    public Object invokeAny(Collection tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void execute(Runnable runnable) {
        this.submit(runnable, null);
    }
}

