/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.ClientBinder;
import com.hazelcast.client.Connection;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.Packet;
import com.hazelcast.client.Serializer;
import com.hazelcast.client.cluster.Bind;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.logging.Level;

public class DefaultClientBinder
implements ClientBinder {
    private HazelcastClient client;
    private final ILogger logger = Logger.getLogger(this.getClass().toString());

    public DefaultClientBinder(HazelcastClient client) {
        this.client = client;
    }

    public void bind(Connection connection) throws IOException {
        Bind b = null;
        try {
            b = new Bind(new Address(connection.getAddress().getHostName(), connection.getSocket().getLocalPort()));
        }
        catch (UnknownHostException e) {
            this.logger.log(Level.WARNING, e.getMessage() + " while creating the bind package.");
        }
        Packet bind = new Packet();
        bind.set("remotelyProcess", ClusterOperation.REMOTELY_PROCESS, Serializer.toByte(null), Serializer.toByte(b));
        this.client.getOutRunnable().writer.write(connection, bind);
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            return;
        }
    }
}

