/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.connector.map.impl;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.client.impl.clientside.HazelcastClientProxy;
import com.hazelcast.connector.map.AsyncMap;
import com.hazelcast.connector.map.Hz3MapAdapter;
import com.hazelcast.connector.map.Reader;
import com.hazelcast.connector.map.impl.AsyncMapImpl;
import com.hazelcast.connector.map.impl.MapReader;
import com.hazelcast.connector.map.impl.MigrationWatcher;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.internal.serialization.impl.HeapData;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import java.util.function.Function;

public class MapAdapterImpl
implements Hz3MapAdapter {
    private final HazelcastClientProxy client;
    private final MigrationWatcher migrationWatcher;

    public MapAdapterImpl(String clientXml) {
        this.client = (HazelcastClientProxy)HazelcastClient.newHazelcastClient((ClientConfig)MapAdapterImpl.asClientConfig(clientXml));
        this.migrationWatcher = new MigrationWatcher((HazelcastInstance)this.client);
    }

    private static ClientConfig asClientConfig(String xml) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
        return new XmlClientConfigBuilder((InputStream)inputStream).build();
    }

    public void shutdown() {
        if (this.migrationWatcher != null) {
            this.migrationWatcher.deregister();
        }
        if (this.client != null) {
            this.client.shutdown();
        }
    }

    public int getPartitionCount() {
        return this.client.client.getClientPartitionService().getPartitionCount();
    }

    public <F extends CompletableFuture, B, R> Reader<F, B, R> reader(String mapName, Function<Map.Entry<byte[], byte[]>, Object> toObject) {
        return new MapReader.RemoteMapReader((HazelcastInstance)this.client, mapName, toObject);
    }

    public BooleanSupplier createWatcher() {
        return this.migrationWatcher.createWatcher();
    }

    public <K, V> AsyncMap<K, V> getMap(String mapName) {
        IMap map = this.client.getMap(mapName);
        return new AsyncMapImpl(map);
    }

    public <V, K> Map<K, V> getReplicatedMap(String mapName) {
        return this.client.getReplicatedMap(mapName);
    }

    public Object toHz3Data(byte[] payload) {
        return new HeapData(payload);
    }
}

