/*
 * Decompiled with CFR 0.152.
 */
package com.haulmont.yarg.structure;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ReportOutputType
implements Serializable {
    public static final ReportOutputType xls = new ReportOutputType("xls");
    public static final ReportOutputType doc = new ReportOutputType("doc");
    public static final ReportOutputType docx = new ReportOutputType("docx");
    public static final ReportOutputType xlsx = new ReportOutputType("xlsx");
    public static final ReportOutputType html = new ReportOutputType("html");
    public static final ReportOutputType pdf = new ReportOutputType("pdf");
    public static final ReportOutputType csv = new ReportOutputType("csv");
    public static final ReportOutputType custom = new ReportOutputType("custom");
    protected static Map<String, ReportOutputType> values = new ConcurrentHashMap<String, ReportOutputType>();
    private final String id;

    protected static void registerOutputType(ReportOutputType outputType) {
        if (outputType == null) {
            throw new NullPointerException("\"outputType\" parameter can not be null");
        }
        values.put(outputType.id, outputType);
    }

    public static ReportOutputType getOutputTypeById(String id) {
        return values.get(id);
    }

    public ReportOutputType(String id) {
        if (id == null) {
            throw new NullPointerException("\"id\" field can not be null");
        }
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    private Object readResolve() throws ObjectStreamException {
        return ReportOutputType.getOutputTypeById(this.id);
    }

    static {
        values.put(ReportOutputType.xls.id, xls);
        values.put(ReportOutputType.doc.id, doc);
        values.put(ReportOutputType.docx.id, docx);
        values.put(ReportOutputType.html.id, html);
        values.put(ReportOutputType.pdf.id, pdf);
        values.put(ReportOutputType.csv.id, csv);
        values.put(ReportOutputType.custom.id, custom);
        values.put(ReportOutputType.xlsx.id, xlsx);
    }
}

