/*
 * Decompiled with CFR 0.152.
 */
package com.haulmont.yarg.reporting;

import com.google.common.base.Preconditions;
import com.haulmont.yarg.structure.Report;
import com.haulmont.yarg.structure.ReportTemplate;
import java.util.HashMap;
import java.util.Map;

public class RunParams {
    protected Report report;
    protected ReportTemplate reportTemplate;
    protected Map<String, Object> params = new HashMap<String, Object>();

    public RunParams(Report report) {
        this.report = report;
        this.reportTemplate = report.getReportTemplates().get("DEFAULT");
    }

    public RunParams templateCode(String templateCode) {
        Preconditions.checkNotNull((Object)templateCode, (Object)"\"templateCode\" parameter can not be null");
        this.reportTemplate = this.report.getReportTemplates().get(templateCode);
        Preconditions.checkNotNull((Object)this.reportTemplate, (Object)String.format("Report template not found for code [%s]", templateCode));
        return this;
    }

    public RunParams template(ReportTemplate reportTemplate) {
        Preconditions.checkNotNull((Object)reportTemplate, (Object)"\"reportTemplate\" parameter can not be null");
        this.reportTemplate = reportTemplate;
        return this;
    }

    public RunParams params(Map<String, Object> params) {
        Preconditions.checkNotNull(params, (Object)"\"params\" parameter can not be null");
        this.params.putAll(params);
        return this;
    }

    public RunParams param(String key, Object value) {
        this.params.put(key, value);
        return this;
    }
}

