/*
 * Copyright 2013 Haulmont
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

/**
 *
 * @author degtyarjov
 * @version $Id$
 */
package com.haulmont.yarg.structure;

import java.io.Serializable;

/**
 * This interface describes report input parameter
 */
public interface ReportParameter extends Serializable {
    /**
     * @return user friendly name
     */
    String getName();

    /**
     * @return alias which is used in formatters and data loaders
     */
    String getAlias();

    Boolean getRequired();

    /**
     * @return parameter class eg Date or String, etc
     */
    Class getParameterClass();
}
