/*
 * Decompiled with CFR 0.152.
 */
package com.haoxuer.discover.function.controller.rest;

import bsh.EvalError;
import bsh.Interpreter;
import com.haoxuer.discover.function.data.entity.Function;
import com.haoxuer.discover.function.data.service.FunctionService;
import com.haoxuer.discover.rest.base.ResponseObject;
import com.haoxuer.discover.web.controller.front.BaseController;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Scope;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

@Scope(value="prototype")
@RestController
public class FunctionRestController
extends BaseController
implements ApplicationContextAware {
    private ApplicationContext context;
    @Autowired
    private FunctionService functionService;

    @RequestMapping(value={"/function/{key}"})
    public ResponseObject function(@PathVariable(value="key") String key, HttpServletRequest request) {
        ResponseObject result = new ResponseObject();
        Function function = this.functionService.findByKey(key);
        if (function == null) {
            result.setCode(501);
            result.setMsg("\u65e0\u6548key");
            return result;
        }
        if (StringUtils.isEmpty((Object)function.getScript())) {
            result.setCode(502);
            result.setMsg("\u65e0\u6548\u811a\u672c");
            return result;
        }
        Interpreter interpreter = new Interpreter();
        try {
            interpreter.set("request", (Object)request);
            interpreter.set("context", (Object)this.context);
            this.context.getBean("FunctionService");
            StringBuffer buffer = new StringBuffer();
            buffer.append(function.getScript());
            interpreter.eval(buffer.toString());
            Object object = interpreter.get("result");
            if (object != null && object instanceof ResponseObject) {
                result = (ResponseObject)object;
            }
        }
        catch (EvalError evalError) {
            evalError.printStackTrace();
        }
        return result;
    }

    @RequestMapping(value={"/api/{key}"})
    public ModelAndView api(@PathVariable(value="key") String key, HttpServletRequest request) {
        ModelAndView result = new ModelAndView((View)new MappingJackson2JsonView());
        Function function = this.functionService.findByKey(key);
        if (function == null) {
            result.addObject("code", (Object)501);
            result.addObject("msg", (Object)"\u65e0\u6548key");
            return result;
        }
        if (StringUtils.isEmpty((Object)function.getScript())) {
            result.addObject("code", (Object)502);
            result.addObject("msg", (Object)"\u65e0\u6548\u811a\u672c");
            return result;
        }
        Interpreter interpreter = new Interpreter();
        try {
            interpreter.set("request", (Object)request);
            interpreter.set("context", (Object)this.context);
            interpreter.set("model", (Object)result);
            StringBuffer buffer = new StringBuffer();
            buffer.append(function.getScript());
            interpreter.eval(buffer.toString());
        }
        catch (EvalError evalError) {
            evalError.printStackTrace();
            result.addObject("code", (Object)503);
            result.addObject("msg", (Object)("" + evalError.getErrorText()));
        }
        return result;
    }

    @RequestMapping(value={"/page/{key}"})
    public String page(@PathVariable(value="key") String key, HttpServletRequest request) {
        String result = "";
        Function function = this.functionService.findByKey(key);
        Interpreter interpreter = new Interpreter();
        try {
            Object object;
            interpreter.set("request", (Object)request);
            interpreter.set("context", (Object)this.context);
            if (function != null && function.getScript() != null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(function.getScript());
                interpreter.eval(buffer.toString());
            }
            if ((object = interpreter.get("result")) != null && object instanceof String) {
                return this.getView((String)object);
            }
        }
        catch (EvalError evalError) {
            evalError.printStackTrace();
        }
        return this.getView("nofound");
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }
}

