/*
 * Decompiled with CFR 0.152.
 */
package com.haoxuer.discover.function.controller.admin;

import com.haoxuer.discover.data.page.Order;
import com.haoxuer.discover.data.page.Page;
import com.haoxuer.discover.data.page.Pageable;
import com.haoxuer.discover.data.utils.FilterUtils;
import com.haoxuer.discover.function.data.entity.Function;
import com.haoxuer.discover.function.data.service.FunctionService;
import com.haoxuer.discover.function.data.so.FunctionSo;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Scope(value="prototype")
@Controller
public class FunctionAction {
    public static final String MODEL = "model";
    public static final String REDIRECT_LIST_HTML = "redirect:/admin/function/view_list.htm";
    private static final Logger log = LoggerFactory.getLogger(FunctionAction.class);
    @Autowired
    private FunctionService manager;

    @RequiresPermissions(value={"function"})
    @RequestMapping(value={"/admin/function/view_list"})
    public String list(Pageable pageable, FunctionSo so, ModelMap model) {
        if (pageable == null) {
            pageable = new Pageable();
        }
        if (pageable.getOrders().isEmpty()) {
            pageable.getOrders().add(Order.desc((String)"id"));
        }
        pageable.getFilters().addAll(FilterUtils.getFilters((Object)so));
        Page<Function> pagination = this.manager.page(pageable);
        model.addAttribute("list", (Object)pagination.getContent());
        model.addAttribute("page", pagination);
        model.addAttribute("so", (Object)so);
        return "/admin/function/list";
    }

    @RequiresPermissions(value={"function"})
    @RequestMapping(value={"/admin/function/view_add"})
    public String add(ModelMap model) {
        return "/admin/function/add";
    }

    @RequiresPermissions(value={"function"})
    @RequestMapping(value={"/admin/function/view_edit"})
    public String edit(Pageable pageable, Long id, ModelMap model) {
        model.addAttribute(MODEL, (Object)this.manager.findById(id));
        model.addAttribute("page", (Object)pageable);
        return "/admin/function/edit";
    }

    @RequiresPermissions(value={"function"})
    @RequestMapping(value={"/admin/function/view_view"})
    public String view(Long id, ModelMap model) {
        model.addAttribute(MODEL, (Object)this.manager.findById(id));
        return "/admin/function/view";
    }

    @RequiresPermissions(value={"function"})
    @RequestMapping(value={"/admin/function/model_save"})
    public String save(Function bean, ModelMap model) {
        String view = REDIRECT_LIST_HTML;
        try {
            this.manager.save(bean);
            log.info("save object id={}", (Object)bean.getId());
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
            model.addAttribute("erro", (Object)e.getMessage());
            view = "/admin/function/add";
        }
        return view;
    }

    @RequiresPermissions(value={"function"})
    @RequestMapping(value={"/admin/function/model_update"})
    public String update(Pageable pageable, Function bean, RedirectAttributes redirectAttributes, ModelMap model) {
        String view = REDIRECT_LIST_HTML;
        try {
            this.manager.update(bean);
            this.initRedirectData(pageable, redirectAttributes);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u5931\u8d25", (Throwable)e);
            model.addAttribute("erro", (Object)e.getMessage());
            model.addAttribute(MODEL, (Object)bean);
            model.addAttribute("page", (Object)pageable);
            view = "/admin/function/edit";
        }
        return view;
    }

    @RequiresPermissions(value={"function"})
    @RequestMapping(value={"/admin/function/model_delete"})
    public String delete(Pageable pageable, Long id, RedirectAttributes redirectAttributes) {
        String view = REDIRECT_LIST_HTML;
        try {
            this.initRedirectData(pageable, redirectAttributes);
            this.manager.deleteById(id);
        }
        catch (DataIntegrityViolationException e) {
            log.error("\u5220\u9664\u5931\u8d25", (Throwable)e);
            redirectAttributes.addFlashAttribute("erro", (Object)"\u8be5\u6761\u6570\u636e\u4e0d\u80fd\u5220\u9664\uff0c\u8bf7\u5148\u5220\u9664\u548c\u4ed6\u76f8\u5173\u7684\u7c7b\u5bb9!");
        }
        return view;
    }

    @RequiresPermissions(value={"function"})
    @RequestMapping(value={"/admin/function/model_deletes"})
    public String deletes(Pageable pageable, Long[] ids, RedirectAttributes redirectAttributes) {
        String view = REDIRECT_LIST_HTML;
        try {
            this.initRedirectData(pageable, redirectAttributes);
            this.manager.deleteByIds(ids);
        }
        catch (DataIntegrityViolationException e) {
            log.error("\u6279\u91cf\u5220\u9664\u5931\u8d25", (Throwable)e);
            redirectAttributes.addFlashAttribute("erro", (Object)"\u8be5\u6761\u6570\u636e\u4e0d\u80fd\u5220\u9664\uff0c\u8bf7\u5148\u5220\u9664\u548c\u4ed6\u76f8\u5173\u7684\u7c7b\u5bb9!");
        }
        return view;
    }

    private void initRedirectData(Pageable pageable, RedirectAttributes redirectAttributes) {
        redirectAttributes.addAttribute("pageNumber", (Object)pageable.getPageNumber());
    }
}

