/*
 * Decompiled with CFR 0.152.
 */
package org.kobjects.mime;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.kobjects.base64.Base64;

public class Decoder {
    InputStream is;
    Hashtable header;
    boolean eof;
    boolean consumed;
    String boundary;
    String characterEncoding;
    char[] buf = new char[256];

    private final String readLine() throws IOException {
        int cnt = 0;
        int i;
        while ((i = this.is.read()) != -1 || cnt != 0) {
            if (i == -1 || i == 10) {
                return new String(this.buf, 0, cnt);
            }
            if (i == 13) continue;
            if (cnt >= this.buf.length) {
                char[] tmp = new char[this.buf.length * 3 / 2];
                System.arraycopy(this.buf, 0, tmp, 0, this.buf.length);
                this.buf = tmp;
            }
            this.buf[cnt++] = (char)i;
        }
        return null;
    }

    public static Hashtable getHeaderElements(String header) {
        String key = "";
        int pos = 0;
        Hashtable<String, String> result = new Hashtable<String, String>();
        int len = header.length();
        while (true) {
            int cut;
            if (pos < len && header.charAt(pos) <= ' ') {
                ++pos;
                continue;
            }
            if (pos >= len) break;
            if (header.charAt(pos) == '\"') {
                if ((cut = header.indexOf(34, ++pos)) == -1) {
                    throw new RuntimeException("End quote expected in " + header);
                }
                result.put(key, header.substring(pos, cut));
                pos = cut + 2;
                if (pos >= len) break;
                if (header.charAt(pos - 1) != ';') {
                    throw new RuntimeException("; expected in " + header);
                }
            } else {
                cut = header.indexOf(59, pos);
                if (cut == -1) {
                    result.put(key, header.substring(pos));
                    break;
                }
                result.put(key, header.substring(pos, cut));
                pos = cut + 1;
            }
            cut = header.indexOf(61, pos);
            if (cut == -1) break;
            key = header.substring(pos, cut).toLowerCase().trim();
            pos = cut + 1;
        }
        return result;
    }

    public Decoder(InputStream is, String _bound) throws IOException {
        this(is, _bound, null);
    }

    public Decoder(InputStream is, String _bound, String characterEncoding) throws IOException {
        this.characterEncoding = characterEncoding;
        this.is = is;
        this.boundary = "--" + _bound;
        String line = null;
        do {
            if ((line = this.readLine()) != null) continue;
            throw new IOException("Unexpected EOF");
        } while (!line.startsWith(this.boundary));
        if (line.endsWith("--")) {
            this.eof = true;
            is.close();
        }
        this.consumed = true;
    }

    public Enumeration getHeaderNames() {
        return this.header.keys();
    }

    public String getHeader(String key) {
        return (String)this.header.get(key.toLowerCase());
    }

    public String readContent() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.readContent(bos);
        String result = this.characterEncoding == null ? new String(bos.toByteArray()) : new String(bos.toByteArray(), this.characterEncoding);
        System.out.println("Field content: '" + result + "'");
        return result;
    }

    public void readContent(OutputStream os) throws IOException {
        if (this.consumed) {
            throw new RuntimeException("Content already consumed!");
        }
        String line = "";
        String contentType = this.getHeader("Content-Type");
        if ("base64".equals(this.getHeader("Content-Transfer-Encoding"))) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while (true) {
                if ((line = this.readLine()) == null) {
                    throw new IOException("Unexpected EOF");
                }
                if (!line.startsWith(this.boundary)) {
                    Base64.decode(line, os);
                    continue;
                }
                break;
            }
        } else {
            String deli = "\r\n" + this.boundary;
            int match = 0;
            while (true) {
                int i;
                if ((i = this.is.read()) == -1) {
                    throw new RuntimeException("Unexpected EOF");
                }
                if ((char)i == deli.charAt(match)) {
                    if (++match != deli.length()) continue;
                    break;
                }
                if (match > 0) {
                    for (int j = 0; j < match; ++j) {
                        os.write((byte)deli.charAt(j));
                    }
                    int n = match = (char)i == deli.charAt(0) ? 1 : 0;
                }
                if (match != 0) continue;
                os.write((byte)i);
            }
            line = this.readLine();
        }
        if (line.endsWith("--")) {
            this.eof = true;
        }
        this.consumed = true;
    }

    public boolean next() throws IOException {
        String line;
        if (!this.consumed) {
            this.readContent(null);
        }
        if (this.eof) {
            return false;
        }
        this.header = new Hashtable();
        while ((line = this.readLine()) != null && !line.equals("")) {
            int cut = line.indexOf(58);
            if (cut == -1) {
                throw new IOException("colon missing in multipart header line: " + line);
            }
            this.header.put(line.substring(0, cut).trim().toLowerCase(), line.substring(cut + 1).trim());
        }
        this.consumed = false;
        return true;
    }
}

