/*
 * Decompiled with CFR 0.152.
 */
package org.kobjects.io;

import java.io.IOException;
import java.io.Reader;

public class LookAheadReader
extends Reader {
    char[] buf = new char[Runtime.getRuntime().freeMemory() > 1000000L ? 16384 : 128];
    int bufPos = 0;
    int bufValid = 0;
    Reader reader;

    public LookAheadReader(Reader r) {
        this.reader = r;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.bufValid == 0 && this.peek(0) == -1) {
            return -1;
        }
        if (len > this.bufValid) {
            len = this.bufValid;
        }
        if (len > this.buf.length - this.bufPos) {
            len = this.buf.length - this.bufPos;
        }
        System.arraycopy(this.buf, this.bufPos, cbuf, off, len);
        this.bufValid -= len;
        this.bufPos += len;
        if (this.bufPos > this.buf.length) {
            this.bufPos -= this.buf.length;
        }
        return len;
    }

    public String readTo(String chars) throws IOException {
        StringBuffer buf = new StringBuffer();
        while (this.peek(0) != -1 && chars.indexOf((char)this.peek(0)) == -1) {
            buf.append((char)this.read());
        }
        return buf.toString();
    }

    public String readTo(char c) throws IOException {
        StringBuffer buf = new StringBuffer();
        while (this.peek(0) != -1 && this.peek(0) != c) {
            buf.append((char)this.read());
        }
        return buf.toString();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public int read() throws IOException {
        int result = this.peek(0);
        if (result != -1) {
            if (++this.bufPos == this.buf.length) {
                this.bufPos = 0;
            }
            --this.bufValid;
        }
        return result;
    }

    public int peek(int delta) throws IOException {
        if (delta > 127) {
            throw new RuntimeException("peek > 127 not supported!");
        }
        while (delta >= this.bufValid) {
            int startPos = (this.bufPos + this.bufValid) % this.buf.length;
            int count = Math.min(this.buf.length - startPos, this.buf.length - this.bufValid);
            if ((count = this.reader.read(this.buf, startPos, count)) == -1) {
                return -1;
            }
            this.bufValid += count;
        }
        return this.buf[this.bufPos + delta % this.buf.length];
    }

    public String readLine() throws IOException {
        if (this.peek(0) == -1) {
            return null;
        }
        String s = this.readTo("\r\n");
        if (this.read() == 13 && this.peek(0) == 10) {
            this.read();
        }
        return s;
    }

    public String readWhile(String chars) throws IOException {
        StringBuffer buf = new StringBuffer();
        while (this.peek(0) != -1 && chars.indexOf((char)this.peek(0)) != -1) {
            buf.append((char)this.read());
        }
        return buf.toString();
    }

    public void skip(String chars) throws IOException {
        StringBuffer buf = new StringBuffer();
        while (this.peek(0) != -1 && chars.indexOf((char)this.peek(0)) != -1) {
            this.read();
        }
    }
}

