/*
 * Decompiled with CFR 0.152.
 */
package com.hannesdorfmann.adapterdelegates4;

import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.hannesdorfmann.adapterdelegates4.AdapterDelegate;
import com.hannesdorfmann.adapterdelegates4.AdapterDelegatesManager;
import java.util.List;

public abstract class AbsDelegationAdapter<T>
extends RecyclerView.Adapter {
    protected AdapterDelegatesManager<T> delegatesManager;
    protected T items;

    public AbsDelegationAdapter() {
        this(new AdapterDelegatesManager());
    }

    public AbsDelegationAdapter(@NonNull AdapterDelegatesManager<T> delegatesManager) {
        if (delegatesManager == null) {
            throw new NullPointerException("AdapterDelegatesManager is null");
        }
        this.delegatesManager = delegatesManager;
    }

    public AbsDelegationAdapter(AdapterDelegate<T> ... delegates) {
        this();
        for (int i = 0; i < delegates.length; ++i) {
            this.delegatesManager.addDelegate(delegates[i]);
        }
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return this.delegatesManager.onCreateViewHolder(parent, viewType);
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        this.delegatesManager.onBindViewHolder(this.items, position, holder, null);
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position, @NonNull List payloads) {
        this.delegatesManager.onBindViewHolder(this.items, position, holder, payloads);
    }

    public int getItemViewType(int position) {
        return this.delegatesManager.getItemViewType(this.items, position);
    }

    public void onViewRecycled(@NonNull RecyclerView.ViewHolder holder) {
        this.delegatesManager.onViewRecycled(holder);
    }

    public boolean onFailedToRecycleView(@NonNull RecyclerView.ViewHolder holder) {
        return this.delegatesManager.onFailedToRecycleView(holder);
    }

    public void onViewAttachedToWindow(@NonNull RecyclerView.ViewHolder holder) {
        this.delegatesManager.onViewAttachedToWindow(holder);
    }

    public void onViewDetachedFromWindow(@NonNull RecyclerView.ViewHolder holder) {
        this.delegatesManager.onViewDetachedFromWindow(holder);
    }

    public T getItems() {
        return this.items;
    }

    public void setItems(T items) {
        this.items = items;
    }
}

