/*
 * Decompiled with CFR 0.152.
 */
package com.hannesdorfmann.adapterdelegates4.paging;

import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.paging.PagedListAdapter;
import androidx.recyclerview.widget.AsyncDifferConfig;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import com.hannesdorfmann.adapterdelegates4.AdapterDelegate;
import com.hannesdorfmann.adapterdelegates4.AdapterDelegatesManager;
import java.util.List;

public class PagedListDelegationAdapter<T>
extends PagedListAdapter<T, RecyclerView.ViewHolder> {
    protected final AdapterDelegatesManager<List<T>> delegatesManager;

    public PagedListDelegationAdapter(@NonNull DiffUtil.ItemCallback<T> diffCallback, AdapterDelegate<List<T>> ... delegates) {
        this(new AdapterDelegatesManager(), diffCallback);
        for (int i = 0; i < delegates.length; ++i) {
            this.delegatesManager.addDelegate(delegates[i]);
        }
    }

    public PagedListDelegationAdapter(@NonNull DiffUtil.ItemCallback<T> diffCallback) {
        this(new AdapterDelegatesManager(), diffCallback);
    }

    public PagedListDelegationAdapter(@NonNull AdapterDelegatesManager<List<T>> delegatesManager, @NonNull DiffUtil.ItemCallback<T> diffCallback) {
        super(diffCallback);
        if (diffCallback == null) {
            throw new NullPointerException("ItemCallback is null");
        }
        if (delegatesManager == null) {
            throw new NullPointerException("AdapterDelegatesManager is null");
        }
        this.delegatesManager = delegatesManager;
    }

    public PagedListDelegationAdapter(@NonNull AsyncDifferConfig<T> config) {
        this(new AdapterDelegatesManager(), config);
    }

    public PagedListDelegationAdapter(@NonNull AdapterDelegatesManager<List<T>> delegatesManager, @NonNull AsyncDifferConfig<T> config) {
        super(config);
        if (config == null) {
            throw new NullPointerException("AsyncDifferConfig is null");
        }
        if (delegatesManager == null) {
            throw new NullPointerException("AdapterDelegatesManager is null");
        }
        this.delegatesManager = delegatesManager;
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return this.delegatesManager.onCreateViewHolder(parent, viewType);
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        this.getItem(position);
        this.delegatesManager.onBindViewHolder((Object)this.getCurrentList(), position, holder, null);
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position, @NonNull List payloads) {
        this.getItem(position);
        this.delegatesManager.onBindViewHolder((Object)this.getCurrentList(), position, holder, payloads);
    }

    public int getItemViewType(int position) {
        return this.delegatesManager.getItemViewType((Object)this.getCurrentList(), position);
    }

    public void onViewRecycled(@NonNull RecyclerView.ViewHolder holder) {
        this.delegatesManager.onViewRecycled(holder);
    }

    public boolean onFailedToRecycleView(@NonNull RecyclerView.ViewHolder holder) {
        return this.delegatesManager.onFailedToRecycleView(holder);
    }

    public void onViewAttachedToWindow(@NonNull RecyclerView.ViewHolder holder) {
        this.delegatesManager.onViewAttachedToWindow(holder);
    }

    public void onViewDetachedFromWindow(@NonNull RecyclerView.ViewHolder holder) {
        this.delegatesManager.onViewDetachedFromWindow(holder);
    }
}

