/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.collection.trie.datrie;

import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.corpus.io.ICacheAble;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;

public class IntArrayList
implements Serializable,
ICacheAble {
    private static final long serialVersionUID = 1908530358259070518L;
    private int[] data;
    private int size;
    private int linearExpandFactor;
    private boolean exponentialExpanding = false;
    private double exponentialExpandFactor = 1.5;

    public void setLinearExpandFactor(int linearExpandFactor) {
        this.linearExpandFactor = linearExpandFactor;
    }

    public boolean isExponentialExpanding() {
        return this.exponentialExpanding;
    }

    public void setExponentialExpanding(boolean multiplyExpanding) {
        this.exponentialExpanding = multiplyExpanding;
    }

    public double getExponentialExpandFactor() {
        return this.exponentialExpandFactor;
    }

    public void setExponentialExpandFactor(double exponentialExpandFactor) {
        this.exponentialExpandFactor = exponentialExpandFactor;
    }

    public IntArrayList() {
        this(1024);
    }

    public IntArrayList(int capacity) {
        this(capacity, 10240);
    }

    public IntArrayList(int capacity, int linearExpandFactor) {
        this.data = new int[capacity];
        this.size = 0;
        this.linearExpandFactor = linearExpandFactor;
    }

    private void expand() {
        if (!this.exponentialExpanding) {
            int[] newData = new int[this.data.length + this.linearExpandFactor];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        } else {
            int[] newData = new int[(int)((double)this.data.length * this.exponentialExpandFactor)];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
    }

    public void append(int element) {
        if (this.size == this.data.length) {
            this.expand();
        }
        this.data[this.size] = element;
        ++this.size;
    }

    public void loseWeight() {
        if (this.size == this.data.length) {
            return;
        }
        int[] newData = new int[this.size];
        System.arraycopy(this.data, 0, newData, 0, this.size);
        this.data = newData;
    }

    public int size() {
        return this.size;
    }

    public int getLinearExpandFactor() {
        return this.linearExpandFactor;
    }

    public void set(int index, int value) {
        this.data[index] = value;
    }

    public int get(int index) {
        return this.data[index];
    }

    public void removeLast() {
        --this.size;
    }

    public int getLast() {
        return this.data[this.size - 1];
    }

    public void setLast(int value) {
        this.data[this.size - 1] = value;
    }

    public int pop() {
        return this.data[--this.size];
    }

    @Override
    public void save(DataOutputStream out) throws IOException {
        out.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            out.writeInt(this.data[i]);
        }
        out.writeInt(this.linearExpandFactor);
        out.writeBoolean(this.exponentialExpanding);
        out.writeDouble(this.exponentialExpandFactor);
    }

    @Override
    public boolean load(ByteArray byteArray) {
        if (byteArray == null) {
            return false;
        }
        this.size = byteArray.nextInt();
        this.data = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = byteArray.nextInt();
        }
        this.linearExpandFactor = byteArray.nextInt();
        this.exponentialExpanding = byteArray.nextBoolean();
        this.exponentialExpandFactor = byteArray.nextDouble();
        return true;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.loseWeight();
        out.writeInt(this.size);
        out.writeObject(this.data);
        out.writeInt(this.linearExpandFactor);
        out.writeBoolean(this.exponentialExpanding);
        out.writeDouble(this.exponentialExpandFactor);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.size = in.readInt();
        this.data = (int[])in.readObject();
        this.linearExpandFactor = in.readInt();
        this.exponentialExpanding = in.readBoolean();
        this.exponentialExpandFactor = in.readDouble();
    }

    public String toString() {
        ArrayList<Integer> head = new ArrayList<Integer>(20);
        for (int i = 0; i < Math.min(this.size, 20); ++i) {
            head.add(this.data[i]);
        }
        return head.toString();
    }
}

