/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.classification.statistics;

public class ContinuousDistributions {
    public static double ChisquareCdf(double x, int df) throws IllegalArgumentException {
        if (df <= 0) {
            throw new IllegalArgumentException();
        }
        return ContinuousDistributions.GammaCdf(x / 2.0, (double)df / 2.0);
    }

    public static double GaussCdf(double z) {
        double p;
        if (z == 0.0) {
            p = 0.0;
        } else {
            double y = Math.abs(z) / 2.0;
            if (y >= 3.0) {
                p = 1.0;
            } else if (y < 1.0) {
                double w = y * y;
                p = ((((((((1.24818987E-4 * w - 0.001075204047) * w + 0.005198775019) * w - 0.019198292004) * w + 0.059054035642) * w - 0.151968751364) * w + 0.319152932694) * w - 0.5319230073) * w + 0.797884560593) * y * 2.0;
            } else {
                p = (((((((((((((-4.5255659E-5 * (y -= 2.0) + 1.5252929E-4) * y - 1.9538132E-5) * y - 6.76904986E-4) * y + 0.001390604284) * y - 7.9462082E-4) * y - 0.002034254874) * y + 0.006549791214) * y - 0.010557625006) * y + 0.011630447319) * y - 0.009279453341) * y + 0.005353579108) * y - 0.002141268741) * y + 5.35310849E-4) * y + 0.999936657524;
            }
        }
        if (z > 0.0) {
            return (p + 1.0) / 2.0;
        }
        return (1.0 - p) / 2.0;
    }

    public static double LogGamma(double Z) {
        double S = 1.0 + 76.18009173 / Z - 86.50532033 / (Z + 1.0) + 24.01409822 / (Z + 2.0) - 1.231739516 / (Z + 3.0) + 0.00120858003 / (Z + 4.0) - 5.36382E-6 / (Z + 5.0);
        double LG = (Z - 0.5) * Math.log(Z + 4.5) - (Z + 4.5) + Math.log(S * 2.50662827465);
        return LG;
    }

    protected static double Gcf(double x, double A) {
        double A0 = 0.0;
        double B0 = 1.0;
        double A1 = 1.0;
        double B1 = x;
        double AOLD = 0.0;
        double N = 0.0;
        while (Math.abs((A1 - AOLD) / A1) > 1.0E-5) {
            AOLD = A1;
            A0 = A1 + ((N += 1.0) - A) * A0;
            B0 = B1 + (N - A) * B0;
            A1 = x * A0 + N * A1;
            B1 = x * B0 + N * B1;
            A0 /= B1;
            B0 /= B1;
            A1 /= B1;
            B1 = 1.0;
        }
        double Prob = Math.exp(A * Math.log(x) - x - ContinuousDistributions.LogGamma(A)) * A1;
        return 1.0 - Prob;
    }

    protected static double Gser(double x, double A) {
        double T9;
        double G = T9 = 1.0 / A;
        double I = 1.0;
        while (T9 > G * 1.0E-5) {
            T9 = T9 * x / (A + I);
            G += T9;
            I += 1.0;
        }
        return G *= Math.exp(A * Math.log(x) - x - ContinuousDistributions.LogGamma(A));
    }

    protected static double GammaCdf(double x, double a) throws IllegalArgumentException {
        if (x < 0.0) {
            throw new IllegalArgumentException();
        }
        double GI = 0.0;
        if (a > 200.0) {
            double z = (x - a) / Math.sqrt(a);
            double y = ContinuousDistributions.GaussCdf(z);
            double b1 = 2.0 / Math.sqrt(a);
            double phiz = 0.39894228 * Math.exp(-z * z / 2.0);
            double w = y - b1 * (z * z - 1.0) * phiz / 6.0;
            double b2 = 6.0 / a;
            int zXor4 = (int)z ^ 4;
            double u = 3.0 * b2 * (z * z - 3.0) + b1 * b1 * ((double)zXor4 - 10.0 * z * z + 15.0);
            GI = w - phiz * z * u / 72.0;
        } else {
            GI = x < a + 1.0 ? ContinuousDistributions.Gser(x, a) : ContinuousDistributions.Gcf(x, a);
        }
        return GI;
    }

    public static double ChisquareInverseCdf(double p, int df) {
        double CHI_EPSILON = 1.0E-6;
        double CHI_MAX = 99999.0;
        double minchisq = 0.0;
        double maxchisq = 99999.0;
        double chisqval = 0.0;
        if (p <= 0.0) {
            return 99999.0;
        }
        if (p >= 1.0) {
            return 0.0;
        }
        chisqval = (double)df / Math.sqrt(p);
        while (maxchisq - minchisq > 1.0E-6) {
            if (1.0 - ContinuousDistributions.ChisquareCdf(chisqval, df) < p) {
                maxchisq = chisqval;
            } else {
                minchisq = chisqval;
            }
            chisqval = (maxchisq + minchisq) * 0.5;
        }
        return chisqval;
    }
}

