/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.tokenizer.lexical;

import com.hankcs.hanlp.collection.AhoCorasick.AhoCorasickDoubleArrayTrie;
import com.hankcs.hanlp.corpus.document.sentence.Sentence;
import com.hankcs.hanlp.corpus.document.sentence.word.CompoundWord;
import com.hankcs.hanlp.corpus.document.sentence.word.IWord;
import com.hankcs.hanlp.corpus.document.sentence.word.Word;
import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.dictionary.CoreDictionary;
import com.hankcs.hanlp.dictionary.CustomDictionary;
import com.hankcs.hanlp.dictionary.other.CharTable;
import com.hankcs.hanlp.model.perceptron.tagset.NERTagSet;
import com.hankcs.hanlp.model.perceptron.utility.PosTagUtility;
import com.hankcs.hanlp.seg.CharacterBasedSegment;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.tokenizer.lexical.LexicalAnalyzer;
import com.hankcs.hanlp.tokenizer.lexical.NERecognizer;
import com.hankcs.hanlp.tokenizer.lexical.POSTagger;
import com.hankcs.hanlp.tokenizer.lexical.Segmenter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractLexicalAnalyzer
extends CharacterBasedSegment
implements LexicalAnalyzer {
    protected Segmenter segmenter;
    protected POSTagger posTagger;
    protected NERecognizer neRecognizer;

    @Override
    public void segment(final String sentence, final String normalized, final List<String> wordList) {
        if (this.config.useCustomDictionary) {
            final int[] offset = new int[]{0};
            CustomDictionary.parseLongestText(sentence, new AhoCorasickDoubleArrayTrie.IHit<CoreDictionary.Attribute>(){

                @Override
                public void hit(int begin, int end, CoreDictionary.Attribute value) {
                    if (AbstractLexicalAnalyzer.this.acceptCustomWord(begin, end, value)) {
                        if (begin != offset[0]) {
                            AbstractLexicalAnalyzer.this.segmenter.segment(sentence.substring(offset[0], begin), normalized.substring(offset[0], begin), wordList);
                        }
                        wordList.add(sentence.substring(begin, end));
                        offset[0] = end;
                    }
                }
            });
            if (offset[0] != sentence.length()) {
                this.segmenter.segment(sentence.substring(offset[0]), normalized.substring(offset[0]), wordList);
            }
        } else {
            this.segmenter.segment(sentence, normalized, wordList);
        }
    }

    @Override
    public List<String> segment(String sentence) {
        return this.segment(sentence, CharTable.convert(sentence));
    }

    @Override
    public String[] recognize(String[] wordArray, String[] posArray) {
        return this.neRecognizer.recognize(wordArray, posArray);
    }

    @Override
    public String[] tag(String ... words) {
        return this.posTagger.tag(words);
    }

    @Override
    public String[] tag(List<String> wordList) {
        return this.posTagger.tag(wordList);
    }

    @Override
    public NERTagSet getNERTagSet() {
        return this.neRecognizer.getNERTagSet();
    }

    @Override
    public Sentence analyze(String sentence) {
        ArrayList<IWord> termList;
        block8: {
            String[] wordArray;
            block6: {
                String[] posArray;
                block7: {
                    if (sentence.isEmpty()) {
                        return new Sentence(Collections.<IWord>emptyList());
                    }
                    String normalized = CharTable.convert(sentence);
                    List<String> wordList = this.segment(sentence, normalized);
                    wordArray = new String[wordList.size()];
                    int offset = 0;
                    int id = 0;
                    for (String word : wordList) {
                        wordArray[id] = normalized.substring(offset, offset + word.length());
                        ++id;
                        offset += word.length();
                    }
                    termList = new ArrayList<IWord>(wordList.size());
                    if (this.posTagger == null) break block6;
                    posArray = this.tag(wordArray);
                    if (this.neRecognizer == null) break block7;
                    String[] nerArray = this.neRecognizer.recognize(wordArray, posArray);
                    wordList.toArray(wordArray);
                    AbstractList result = new LinkedList<Word>();
                    result.add(new Word(wordArray[0], posArray[0]));
                    String prePos = posArray[0];
                    NERTagSet tagSet = this.getNERTagSet();
                    for (int i = 1; i < nerArray.length; ++i) {
                        if (nerArray[i].charAt(0) == tagSet.B_TAG_CHAR || nerArray[i].charAt(0) == tagSet.S_TAG_CHAR || nerArray[i].charAt(0) == tagSet.O_TAG_CHAR) {
                            termList.add(result.size() > 1 ? new CompoundWord(result, prePos) : (IWord)result.get(0));
                            result = new ArrayList();
                        }
                        result.add((Word)new Word(wordArray[i], posArray[i]));
                        prePos = nerArray[i].charAt(0) == tagSet.O_TAG_CHAR || nerArray[i].charAt(0) == tagSet.S_TAG_CHAR ? posArray[i] : NERTagSet.posOf(nerArray[i]);
                    }
                    if (result.size() == 0) break block8;
                    termList.add(result.size() > 1 ? new CompoundWord(result, prePos) : (IWord)result.get(0));
                    break block8;
                }
                for (int i = 0; i < wordArray.length; ++i) {
                    termList.add(new Word(wordArray[i], posArray[i]));
                }
                break block8;
            }
            for (String word : wordArray) {
                termList.add(new Word(word, null));
            }
        }
        return new Sentence(termList);
    }

    public List<String> segment(String sentence, String normalized) {
        LinkedList<String> wordList = new LinkedList<String>();
        this.segment(sentence, normalized, wordList);
        return wordList;
    }

    protected boolean acceptCustomWord(int begin, int end, CoreDictionary.Attribute value) {
        return end - begin >= 4 && !value.hasNatureStartsWith("nr") && !value.hasNatureStartsWith("ns") && !value.hasNatureStartsWith("nt");
    }

    @Override
    protected List<Term> roughSegSentence(char[] sentence) {
        return null;
    }

    @Override
    protected List<Term> segSentence(char[] sentence) {
        ArrayList<Term> termList;
        block15: {
            block16: {
                if (sentence.length == 0) {
                    return Collections.emptyList();
                }
                String original = new String(sentence);
                CharTable.normalization(sentence);
                String normalized = new String(sentence);
                LinkedList<String> wordList = new LinkedList<String>();
                this.segment(original, normalized, wordList);
                termList = new ArrayList<Term>(wordList.size());
                int offset = 0;
                for (String word : wordList) {
                    Term term = new Term(word, null);
                    term.offset = offset;
                    offset += term.length();
                    termList.add(term);
                }
                if (!this.config.speechTagging) break block15;
                if (this.posTagger == null) break block16;
                String[] wordArray = new String[wordList.size()];
                offset = 0;
                int id = 0;
                for (String word : wordList) {
                    wordArray[id] = normalized.substring(offset, offset + word.length());
                    ++id;
                    offset += word.length();
                }
                String[] posArray = this.tag(wordArray);
                Iterator iterator = termList.iterator();
                for (String pos : posArray) {
                    ((Term)iterator.next()).nature = Nature.create(pos);
                }
                if (!this.config.ner || this.neRecognizer == null) break block15;
                LinkedList childrenList = null;
                if (this.config.isIndexMode()) {
                    childrenList = new LinkedList();
                    iterator = termList.iterator();
                }
                termList = new ArrayList(termList.size());
                String[] nerArray = this.recognize(wordArray, posArray);
                wordList.toArray(wordArray);
                StringBuilder result = new StringBuilder();
                result.append(wordArray[0]);
                if (childrenList != null) {
                    childrenList.add(iterator.next());
                }
                String prePos = posArray[0];
                offset = 0;
                for (int i = 1; i < nerArray.length; ++i) {
                    NERTagSet tagSet = this.getNERTagSet();
                    if (nerArray[i].charAt(0) == tagSet.B_TAG_CHAR || nerArray[i].charAt(0) == tagSet.S_TAG_CHAR || nerArray[i].charAt(0) == tagSet.O_TAG_CHAR) {
                        Term term = new Term(result.toString(), Nature.create(prePos));
                        term.offset = offset;
                        offset += term.length();
                        termList.add(term);
                        if (childrenList != null) {
                            if (childrenList.size() > 1) {
                                for (Term shortTerm : childrenList) {
                                    if (shortTerm.length() < this.config.indexMode) continue;
                                    termList.add(shortTerm);
                                }
                            }
                            childrenList.clear();
                        }
                        result.setLength(0);
                    }
                    result.append(wordArray[i]);
                    if (childrenList != null) {
                        childrenList.add(iterator.next());
                    }
                    prePos = nerArray[i].charAt(0) == tagSet.O_TAG_CHAR || nerArray[i].charAt(0) == tagSet.S_TAG_CHAR ? posArray[i] : NERTagSet.posOf(nerArray[i]);
                }
                if (result.length() == 0) break block15;
                Term term = new Term(result.toString(), Nature.create(posArray[posArray.length - 1]));
                term.offset = offset;
                termList.add(term);
                if (childrenList == null || childrenList.size() <= 1) break block15;
                for (Term shortTerm : childrenList) {
                    if (shortTerm.length() < this.config.indexMode) continue;
                    termList.add(shortTerm);
                }
                break block15;
            }
            for (Term term : termList) {
                CoreDictionary.Attribute attribute = CoreDictionary.get(term.word);
                if (attribute != null) {
                    term.nature = Nature.create(PosTagUtility.convert(attribute.nature[0]));
                    continue;
                }
                term.nature = Nature.n;
            }
        }
        return termList;
    }
}

