/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.perceptron;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.corpus.document.sentence.Sentence;
import com.hankcs.hanlp.model.perceptron.PerceptronTagger;
import com.hankcs.hanlp.model.perceptron.common.TaskType;
import com.hankcs.hanlp.model.perceptron.feature.FeatureMap;
import com.hankcs.hanlp.model.perceptron.instance.Instance;
import com.hankcs.hanlp.model.perceptron.instance.POSInstance;
import com.hankcs.hanlp.model.perceptron.model.LinearModel;
import com.hankcs.hanlp.tokenizer.lexical.POSTagger;
import java.io.IOException;
import java.util.List;

public class PerceptronPOSTagger
extends PerceptronTagger
implements POSTagger {
    public PerceptronPOSTagger(LinearModel model) {
        super(model);
        if (model.featureMap.tagSet.type != TaskType.POS) {
            throw new IllegalArgumentException(String.format("\u9519\u8bef\u7684\u6a21\u578b\u7c7b\u578b: \u4f20\u5165\u7684\u4e0d\u662f\u8bcd\u6027\u6807\u6ce8\u6a21\u578b\uff0c\u800c\u662f %s \u6a21\u578b", new Object[]{model.featureMap.tagSet.type}));
        }
    }

    public PerceptronPOSTagger(String modelPath) throws IOException {
        this(new LinearModel(modelPath));
    }

    public PerceptronPOSTagger() throws IOException {
        this(HanLP.Config.PerceptronPOSModelPath);
    }

    @Override
    public String[] tag(String ... words) {
        POSInstance instance = new POSInstance(words, this.model.featureMap);
        instance.tagArray = new int[words.length];
        this.model.viterbiDecode(instance, instance.tagArray);
        return instance.tags(this.model.tagSet());
    }

    @Override
    public String[] tag(List<String> wordList) {
        String[] termArray = new String[wordList.size()];
        wordList.toArray(termArray);
        return this.tag(termArray);
    }

    public boolean learn(String segmentedTaggedSentence) {
        return this.learn(POSInstance.create(segmentedTaggedSentence, this.model.featureMap));
    }

    public boolean learn(String ... wordTags) {
        String[] words = new String[wordTags.length];
        String[] tags = new String[wordTags.length];
        for (int i = 0; i < wordTags.length; ++i) {
            String[] wordTag = wordTags[i].split("//");
            words[i] = wordTag[0];
            tags[i] = wordTag[1];
        }
        return this.learn(new POSInstance(words, tags, this.model.featureMap));
    }

    @Override
    protected Instance createInstance(Sentence sentence, FeatureMap featureMap) {
        return POSInstance.create(sentence, featureMap);
    }
}

