/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.crf;

import com.hankcs.hanlp.corpus.document.sentence.Sentence;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.model.crf.crfpp.Encoder;
import com.hankcs.hanlp.model.crf.crfpp.ModelImpl;
import com.hankcs.hanlp.model.crf.crfpp.TaggerImpl;
import com.hankcs.hanlp.model.crf.crfpp.crf_learn;
import com.hankcs.hanlp.model.perceptron.instance.InstanceHandler;
import com.hankcs.hanlp.model.perceptron.utility.IOUtility;
import com.hankcs.hanlp.model.perceptron.utility.Utility;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.Date;

public abstract class CRFTagger {
    protected ModelImpl model;

    public CRFTagger() {
    }

    public CRFTagger(String modelPath) throws IOException {
        if (modelPath == null) {
            return;
        }
        this.model = new ModelImpl();
        if (!this.model.open(IOUtil.newInputStream(modelPath), 0, 0, 1.0)) {
            throw new IOException(String.format("%s \u52a0\u8f7d\u5931\u8d25", modelPath));
        }
    }

    public void train(String templFile, String trainFile, String modelFile, boolean textModelFile, int maxitr, int freq, double eta, double C, int threadNum, int shrinkingSize, Encoder.Algorithm algorithm) throws IOException {
        Encoder encoder = new Encoder();
        if (!encoder.learn(templFile, trainFile, modelFile, textModelFile, maxitr, freq, eta, C, threadNum, shrinkingSize, algorithm)) {
            throw new IOException("fail to learn model");
        }
    }

    public void train(String trainCorpusPath, String modelPath) throws IOException {
        crf_learn.Option option = new crf_learn.Option();
        this.train(trainCorpusPath, modelPath, option.textmodel, option.maxiter, option.freq, option.eta, option.cost, option.thread, option.shrinking_size, Encoder.Algorithm.fromString(option.algorithm));
    }

    public void train(String trainFile, String modelFile, boolean textModelFile, int maxitr, int freq, double eta, double C, int threadNum, int shrinkingSize, Encoder.Algorithm algorithm) throws IOException {
        String templFile = null;
        File tmpTemplate = File.createTempFile("crfpp-template-" + new Date().getTime(), ".txt");
        tmpTemplate.deleteOnExit();
        templFile = tmpTemplate.getAbsolutePath();
        String template = this.getDefaultFeatureTemplate();
        IOUtil.saveTxt(templFile, template);
        File tmpTrain = File.createTempFile("crfpp-train-" + new Date().getTime(), ".txt");
        tmpTrain.deleteOnExit();
        this.convertCorpus(trainFile, tmpTrain.getAbsolutePath());
        trainFile = tmpTrain.getAbsolutePath();
        Encoder encoder = new Encoder();
        if (!encoder.learn(templFile, trainFile, modelFile, textModelFile, maxitr, freq, eta, C, threadNum, shrinkingSize, algorithm)) {
            throw new IOException("fail to learn model");
        }
    }

    protected abstract void convertCorpus(Sentence var1, BufferedWriter var2) throws IOException;

    protected TaggerImpl createTagger() {
        TaggerImpl tagger = new TaggerImpl(TaggerImpl.Mode.TEST);
        tagger.setModel(this.model);
        return tagger;
    }

    protected abstract String getDefaultFeatureTemplate();

    public void convertCorpus(String pkuPath, String tsvPath) throws IOException {
        final BufferedWriter bw = IOUtil.newBufferedWriter(tsvPath);
        IOUtility.loadInstance(pkuPath, new InstanceHandler(){

            @Override
            public boolean process(Sentence sentence) {
                Utility.normalize(sentence);
                try {
                    CRFTagger.this.convertCorpus(sentence, bw);
                    bw.newLine();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return false;
            }
        });
        bw.close();
    }

    public void dumpTemplate(String templatePath) throws IOException {
        BufferedWriter bw = IOUtil.newBufferedWriter(templatePath);
        String template = this.getTemplate();
        bw.write(template);
        bw.close();
    }

    public String getTemplate() {
        String template = this.getDefaultFeatureTemplate();
        if (this.model != null && this.model.getTemplate() != null) {
            template = this.model.getTemplate();
        }
        return template;
    }
}

