/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.collection.trie.bintrie;

import com.hankcs.hanlp.collection.trie.ITrie;
import com.hankcs.hanlp.collection.trie.bintrie.BaseNode;
import com.hankcs.hanlp.collection.trie.bintrie.Node;
import com.hankcs.hanlp.collection.trie.bintrie._EmptyValueArray;
import com.hankcs.hanlp.collection.trie.bintrie._ValueArray;
import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.utility.Predefine;
import com.hankcs.hanlp.utility.TextUtility;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class BinTrie<V>
extends BaseNode<V>
implements ITrie<V>,
Externalizable {
    private int size;

    public BinTrie() {
        this.child = new BaseNode[65536];
        this.size = 0;
        this.status = BaseNode.Status.NOT_WORD_1;
    }

    public void put(String key, V value) {
        if (key.length() == 0) {
            return;
        }
        BaseNode branch = this;
        char[] chars = key.toCharArray();
        for (int i = 0; i < chars.length - 1; ++i) {
            ((BaseNode)branch).addChild(new Node<Object>(chars[i], BaseNode.Status.NOT_WORD_1, null));
            branch = ((BaseNode)branch).getChild(chars[i]);
        }
        if (((BaseNode)branch).addChild(new Node<V>(chars[chars.length - 1], BaseNode.Status.WORD_END_3, value))) {
            ++this.size;
        }
    }

    public void put(char[] key, V value) {
        BaseNode branch = this;
        for (int i = 0; i < key.length - 1; ++i) {
            ((BaseNode)branch).addChild(new Node<Object>(key[i], BaseNode.Status.NOT_WORD_1, null));
            branch = ((BaseNode)branch).getChild(key[i]);
        }
        if (((BaseNode)branch).addChild(new Node<V>(key[key.length - 1], BaseNode.Status.WORD_END_3, value))) {
            ++this.size;
        }
    }

    public void set(String key, V value) {
        this.put(key.toCharArray(), value);
    }

    public void remove(String key) {
        BaseNode branch = this;
        char[] chars = key.toCharArray();
        for (int i = 0; i < chars.length - 1; ++i) {
            if (branch == null) {
                return;
            }
            branch = ((BaseNode)branch).getChild(chars[i]);
        }
        if (branch == null) {
            return;
        }
        if (((BaseNode)branch).addChild(new Node<Object>(chars[chars.length - 1], BaseNode.Status.UNDEFINED_0, this.value))) {
            --this.size;
        }
    }

    @Override
    public boolean containsKey(String key) {
        char[] chars;
        BaseNode branch = this;
        for (char aChar : chars = key.toCharArray()) {
            if (branch == null) {
                return false;
            }
            branch = ((BaseNode)branch).getChild(aChar);
        }
        return branch != null && (branch.status == BaseNode.Status.WORD_END_3 || branch.status == BaseNode.Status.WORD_MIDDLE_2);
    }

    @Override
    public V get(String key) {
        char[] chars;
        BaseNode branch = this;
        for (char aChar : chars = key.toCharArray()) {
            if (branch == null) {
                return null;
            }
            branch = ((BaseNode)branch).getChild(aChar);
        }
        if (branch == null) {
            return null;
        }
        if (branch.status != BaseNode.Status.WORD_END_3 && branch.status != BaseNode.Status.WORD_MIDDLE_2) {
            return null;
        }
        return branch.getValue();
    }

    @Override
    public V get(char[] key) {
        BaseNode branch = this;
        for (char aChar : key) {
            if (branch == null) {
                return null;
            }
            branch = ((BaseNode)branch).getChild(aChar);
        }
        if (branch == null) {
            return null;
        }
        if (branch.status != BaseNode.Status.WORD_END_3 && branch.status != BaseNode.Status.WORD_MIDDLE_2) {
            return null;
        }
        return branch.getValue();
    }

    @Override
    public V[] getValueArray(V[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        int i = 0;
        for (Map.Entry<String, V> entry : this.entrySet()) {
            a[i++] = entry.getValue();
        }
        return a;
    }

    public Set<Map.Entry<String, V>> entrySet() {
        TreeSet<Map.Entry<String, V>> entrySet = new TreeSet<Map.Entry<String, V>>();
        StringBuilder sb = new StringBuilder();
        for (BaseNode node : this.child) {
            if (node == null) continue;
            node.walk(new StringBuilder(sb.toString()), entrySet);
        }
        return entrySet;
    }

    public Set<String> keySet() {
        TreeSet<String> keySet = new TreeSet<String>();
        for (Map.Entry<String, V> entry : this.entrySet()) {
            keySet.add(entry.getKey());
        }
        return keySet;
    }

    public Set<Map.Entry<String, V>> prefixSearch(String key) {
        char[] chars;
        TreeSet<Map.Entry<String, V>> entrySet = new TreeSet<Map.Entry<String, V>>();
        StringBuilder sb = new StringBuilder(key.substring(0, key.length() - 1));
        BaseNode branch = this;
        for (char aChar : chars = key.toCharArray()) {
            if (branch == null) {
                return entrySet;
            }
            branch = ((BaseNode)branch).getChild(aChar);
        }
        if (branch == null) {
            return entrySet;
        }
        branch.walk(sb, entrySet);
        return entrySet;
    }

    public LinkedList<Map.Entry<String, V>> commonPrefixSearchWithValue(String key) {
        char[] chars = key.toCharArray();
        return this.commonPrefixSearchWithValue(chars, 0);
    }

    public LinkedList<Map.Entry<String, V>> commonPrefixSearchWithValue(char[] chars, int begin) {
        LinkedList<Map.Entry<String, V>> result = new LinkedList<Map.Entry<String, V>>();
        StringBuilder sb = new StringBuilder();
        BaseNode branch = this;
        for (int i = begin; i < chars.length; ++i) {
            char aChar = chars[i];
            if ((branch = ((BaseNode)branch).getChild(aChar)) == null || branch.status == BaseNode.Status.UNDEFINED_0) {
                return result;
            }
            sb.append(aChar);
            if (branch.status != BaseNode.Status.WORD_MIDDLE_2 && branch.status != BaseNode.Status.WORD_END_3) continue;
            result.add(new AbstractMap.SimpleEntry(sb.toString(), branch.value));
        }
        return result;
    }

    @Override
    protected boolean addChild(BaseNode node) {
        boolean add = false;
        char c = node.getChar();
        BaseNode target = this.getChild(c);
        if (target == null) {
            this.child[c] = node;
            add = true;
        } else {
            switch (node.status) {
                case UNDEFINED_0: {
                    if (target.status == BaseNode.Status.NOT_WORD_1) break;
                    target.status = BaseNode.Status.NOT_WORD_1;
                    add = true;
                    break;
                }
                case NOT_WORD_1: {
                    if (target.status != BaseNode.Status.WORD_END_3) break;
                    target.status = BaseNode.Status.WORD_MIDDLE_2;
                    break;
                }
                case WORD_END_3: {
                    if (target.status == BaseNode.Status.NOT_WORD_1) {
                        target.status = BaseNode.Status.WORD_MIDDLE_2;
                    }
                    if (target.getValue() == null) {
                        add = true;
                    }
                    target.setValue(node.getValue());
                }
            }
        }
        return add;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    protected char getChar() {
        return '\u0000';
    }

    @Override
    public BaseNode getChild(char c) {
        return this.child[c];
    }

    public boolean save(String path) {
        try {
            DataOutputStream out = new DataOutputStream(IOUtil.newOutputStream(path));
            for (BaseNode node : this.child) {
                if (node == null) {
                    out.writeInt(0);
                    continue;
                }
                out.writeInt(1);
                node.walkToSave(out);
            }
            out.close();
        }
        catch (Exception e) {
            Predefine.logger.warning("\u4fdd\u5b58\u5230" + path + "\u5931\u8d25" + TextUtility.exceptionToString(e));
            return false;
        }
        return true;
    }

    @Override
    public int build(TreeMap<String, V> keyValueMap) {
        for (Map.Entry<String, V> entry : keyValueMap.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
        return 0;
    }

    @Override
    public boolean save(DataOutputStream out) {
        try {
            for (BaseNode node : this.child) {
                if (node == null) {
                    out.writeInt(0);
                    continue;
                }
                out.writeInt(1);
                node.walkToSave(out);
            }
        }
        catch (Exception e) {
            Predefine.logger.warning("\u4fdd\u5b58\u5230" + out + "\u5931\u8d25" + TextUtility.exceptionToString(e));
            return false;
        }
        return true;
    }

    public boolean load(String path, V[] value) {
        byte[] bytes = IOUtil.readBytes(path);
        if (bytes == null) {
            return false;
        }
        _ValueArray<V> valueArray = new _ValueArray<V>(value);
        ByteArray byteArray = new ByteArray(bytes);
        for (int i = 0; i < this.child.length; ++i) {
            int flag = byteArray.nextInt();
            if (flag != 1) continue;
            this.child[i] = new Node();
            this.child[i].walkToLoad(byteArray, valueArray);
        }
        this.size = value.length;
        return true;
    }

    public boolean load(String path) {
        byte[] bytes = IOUtil.readBytes(path);
        if (bytes == null) {
            return false;
        }
        _EmptyValueArray valueArray = new _EmptyValueArray();
        ByteArray byteArray = new ByteArray(bytes);
        for (int i = 0; i < this.child.length; ++i) {
            int flag = byteArray.nextInt();
            if (flag != 1) continue;
            this.child[i] = new Node();
            this.child[i].walkToLoad(byteArray, valueArray);
        }
        this.size = -1;
        return true;
    }

    public boolean load(ByteArray byteArray, _ValueArray valueArray) {
        for (int i = 0; i < this.child.length; ++i) {
            int flag = byteArray.nextInt();
            if (flag != 1) continue;
            this.child[i] = new Node();
            this.child[i].walkToLoad(byteArray, valueArray);
        }
        this.size = valueArray.value.length;
        return true;
    }

    @Override
    public boolean load(ByteArray byteArray, V[] value) {
        return this.load(byteArray, this.newValueArray().setValue(value));
    }

    public _ValueArray newValueArray() {
        return new _ValueArray();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size);
        for (BaseNode node : this.child) {
            if (node == null) {
                out.writeInt(0);
                continue;
            }
            out.writeInt(1);
            node.walkToSave(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readInt();
        for (int i = 0; i < this.child.length; ++i) {
            int flag = in.readInt();
            if (flag != 1) continue;
            this.child[i] = new Node();
            this.child[i].walkToLoad(in);
        }
    }
}

