/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary.nr;

import com.hankcs.hanlp.corpus.dictionary.item.EnumItem;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.corpus.tag.NR;
import com.hankcs.hanlp.dictionary.common.CommonDictionary;
import com.hankcs.hanlp.utility.ByteUtil;
import com.hankcs.hanlp.utility.Predefine;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.Map;

public class NRDictionary
extends CommonDictionary<EnumItem<NR>> {
    protected EnumItem<NR>[] onLoadValue(String path) {
        EnumItem<NR>[] valueArray = this.loadDat(path + ".value.dat");
        if (valueArray != null) {
            return valueArray;
        }
        LinkedList valueList = new LinkedList();
        String line = null;
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8"));
            while ((line = br.readLine()) != null) {
                Map.Entry<String, Map.Entry<String, Integer>[]> args = EnumItem.create(line);
                EnumItem nrEnumItem = new EnumItem();
                for (Map.Entry<String, Integer> e : args.getValue()) {
                    nrEnumItem.labelMap.put(NR.valueOf(e.getKey()), e.getValue());
                }
                valueList.add(nrEnumItem);
            }
            br.close();
        }
        catch (Exception e) {
            Predefine.logger.severe("\u8bfb\u53d6" + path + "\u5931\u8d25[" + e + "]\n\u8be5\u8bcd\u5178\u8fd9\u4e00\u884c\u683c\u5f0f\u4e0d\u5bf9\uff1a" + line);
            return null;
        }
        valueArray = valueList.toArray(new EnumItem[0]);
        return valueArray;
    }

    protected boolean onSaveValue(EnumItem<NR>[] valueArray, String path) {
        return this.saveDat(path + ".value.dat", valueArray);
    }

    private EnumItem<NR>[] loadDat(String path) {
        byte[] bytes = IOUtil.readBytes(path);
        if (bytes == null) {
            return null;
        }
        NR[] nrArray = NR.values();
        int index = 0;
        int size = ByteUtil.bytesHighFirstToInt(bytes, index);
        index += 4;
        EnumItem[] valueArray = new EnumItem[size];
        for (int i = 0; i < size; ++i) {
            int currentSize = ByteUtil.bytesHighFirstToInt(bytes, index);
            index += 4;
            EnumItem item = new EnumItem();
            for (int j = 0; j < currentSize; ++j) {
                NR nr = nrArray[ByteUtil.bytesHighFirstToInt(bytes, index)];
                int frequency = ByteUtil.bytesHighFirstToInt(bytes, index += 4);
                index += 4;
                item.labelMap.put(nr, frequency);
            }
            valueArray[i] = item;
        }
        return valueArray;
    }

    private boolean saveDat(String path, EnumItem<NR>[] valueArray) {
        try {
            DataOutputStream out = new DataOutputStream(new FileOutputStream(path));
            out.writeInt(valueArray.length);
            for (EnumItem<NR> item : valueArray) {
                out.writeInt(item.labelMap.size());
                for (Map.Entry entry : item.labelMap.entrySet()) {
                    out.writeInt(((NR)((Object)entry.getKey())).ordinal());
                    out.writeInt(entry.getValue());
                }
            }
            out.close();
        }
        catch (Exception e) {
            Predefine.logger.warning("\u4fdd\u5b58\u5931\u8d25" + e);
            return false;
        }
        return true;
    }
}

