/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.trie.DoubleArrayTrie;
import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.dictionary.CoreDictionary;
import com.hankcs.hanlp.utility.ByteUtil;
import com.hankcs.hanlp.utility.Predefine;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.TreeMap;
import java.util.logging.Level;

public class CoreBiGramMixDictionary {
    static DoubleArrayTrie<Integer> trie;
    public static final String path;
    static final String datPath;

    static boolean load(String path) {
        trie = new DoubleArrayTrie();
        if (CoreBiGramMixDictionary.loadDat(datPath)) {
            return true;
        }
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(IOUtil.newInputStream(path), "UTF-8"));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                String[] params = line.split("\\s");
                String[] twoWord = params[0].split("@", 2);
                CoreBiGramMixDictionary.buildID(twoWord[0], sb);
                sb.append('@');
                CoreBiGramMixDictionary.buildID(twoWord[1], sb);
                int freq = Integer.parseInt(params[1]);
                map.put(sb.toString(), freq);
                sb.setLength(0);
            }
            br.close();
            Predefine.logger.info("\u4e8c\u5143\u8bcd\u5178\u8bfb\u53d6\u5b8c\u6bd5:" + path + "\uff0c\u5f00\u59cb\u6784\u5efa\u53cc\u6570\u7ec4Trie\u6811(DoubleArrayTrie)\u2026\u2026");
            trie.build(map);
        }
        catch (FileNotFoundException e) {
            Predefine.logger.severe("\u4e8c\u5143\u8bcd\u5178" + path + "\u4e0d\u5b58\u5728\uff01" + e);
            return false;
        }
        catch (IOException e) {
            Predefine.logger.severe("\u4e8c\u5143\u8bcd\u5178" + path + "\u8bfb\u53d6\u9519\u8bef\uff01" + e);
            return false;
        }
        Predefine.logger.info("\u5f00\u59cb\u7f13\u5b58\u4e8c\u5143\u8bcd\u5178\u5230" + datPath);
        if (!CoreBiGramMixDictionary.saveDat(datPath, map)) {
            Predefine.logger.warning("\u7f13\u5b58\u4e8c\u5143\u8bcd\u5178\u5230" + datPath + "\u5931\u8d25");
        }
        return true;
    }

    static boolean saveDat(String path, TreeMap<String, Integer> map) {
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(IOUtil.newOutputStream(path)));
            Collection<Integer> freqList = map.values();
            out.writeInt(freqList.size());
            for (int freq : freqList) {
                out.writeInt(freq);
            }
            trie.save(out);
            out.close();
        }
        catch (Exception e) {
            Predefine.logger.log(Level.WARNING, "\u5728\u7f13\u5b58" + path + "\u65f6\u53d1\u751f\u5f02\u5e38", e);
            return false;
        }
        return true;
    }

    static boolean loadDat(String path) {
        try {
            ByteArray byteArray = ByteArray.createByteArray(path);
            if (byteArray == null) {
                return false;
            }
            int size = byteArray.nextInt();
            Integer[] value = new Integer[size];
            for (int i = 0; i < size; ++i) {
                value[i] = byteArray.nextInt();
            }
            if (!trie.load(byteArray, (Integer[])value)) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    static int binarySearch(int[][] a, int key) {
        int low = 0;
        int high = a.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = a[mid][0];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    static void buildID(String word, StringBuilder sbStorage) {
        int id = CoreDictionary.trie.exactMatchSearch(word);
        if (id == -1) {
            sbStorage.append(word);
        } else {
            char[] twoChar = ByteUtil.convertIntToTwoChar(id);
            sbStorage.append(twoChar);
        }
    }

    public static int getWordID(String a) {
        return CoreDictionary.trie.exactMatchSearch(a);
    }

    static {
        path = HanLP.Config.BiGramDictionaryPath;
        datPath = HanLP.Config.BiGramDictionaryPath + ".mix" + ".bin";
        Predefine.logger.info("\u5f00\u59cb\u52a0\u8f7d\u4e8c\u5143\u8bcd\u5178" + path + ".mix");
        long start = System.currentTimeMillis();
        if (!CoreBiGramMixDictionary.load(path)) {
            Predefine.logger.severe("\u4e8c\u5143\u8bcd\u5178\u52a0\u8f7d\u5931\u8d25");
            System.exit(-1);
        } else {
            Predefine.logger.info(path + ".mix" + "\u52a0\u8f7d\u6210\u529f\uff0c\u8017\u65f6" + (System.currentTimeMillis() - start) + "ms");
        }
    }
}

