/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.corpus.util;

import com.hankcs.hanlp.corpus.util.ReflectionHelper;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import sun.reflect.ConstructorAccessor;
import sun.reflect.ReflectionFactory;

public class EnumBuster<E extends Enum<E>> {
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final String VALUES_FIELD = "$VALUES";
    private static final String ORDINAL_FIELD = "ordinal";
    private final ReflectionFactory reflection = ReflectionFactory.getReflectionFactory();
    private final Class<E> clazz;
    private final Collection<Field> switchFields;
    private final Deque<Memento> undoStack = new LinkedList<Memento>();

    public EnumBuster(Class<E> clazz, Class ... switchUsers) {
        try {
            this.clazz = clazz;
            this.switchFields = this.findRelatedSwitchFields(switchUsers);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not create the class", e);
        }
    }

    public E make(String value) {
        return this.make(value, 0, EMPTY_CLASS_ARRAY, EMPTY_OBJECT_ARRAY);
    }

    public E make(String value, int ordinal) {
        return this.make(value, ordinal, EMPTY_CLASS_ARRAY, EMPTY_OBJECT_ARRAY);
    }

    public E make(String value, int ordinal, Class[] additionalTypes, Object[] additional) {
        try {
            this.undoStack.push(new Memento());
            ConstructorAccessor ca = this.findConstructorAccessor(additionalTypes, this.clazz);
            return this.constructEnum(this.clazz, ca, value, ordinal, additional);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not create enum", e);
        }
    }

    public void addByValue(E e) {
        try {
            this.undoStack.push(new Memento());
            Field valuesField = this.findValuesField();
            Enum[] values = this.values();
            for (int i = 0; i < values.length; ++i) {
                Enum value = values[i];
                if (!value.name().equals(((Enum)e).name())) continue;
                this.setOrdinal(e, value.ordinal());
                values[i] = e;
                this.replaceConstant(e);
                return;
            }
            Enum[] newValues = Arrays.copyOf(values, values.length + 1);
            newValues[newValues.length - 1] = e;
            ReflectionHelper.setStaticFinalField(valuesField, newValues);
            int ordinal = newValues.length - 1;
            this.setOrdinal(e, ordinal);
            this.addSwitchCase();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Could not set the enum", ex);
        }
    }

    public boolean deleteByValue(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        try {
            this.undoStack.push(new Memento());
            Enum[] values = this.values();
            for (int i = 0; i < values.length; ++i) {
                Enum value = values[i];
                if (!value.name().equals(((Enum)e).name())) continue;
                Enum[] newValues = Arrays.copyOf(values, values.length - 1);
                System.arraycopy(values, i + 1, newValues, i, values.length - i - 1);
                for (int j = i; j < newValues.length; ++j) {
                    this.setOrdinal(newValues[j], j);
                }
                Field valuesField = this.findValuesField();
                ReflectionHelper.setStaticFinalField(valuesField, newValues);
                this.removeSwitchCase(i);
                this.blankOutConstant(e);
                return true;
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Could not set the enum", ex);
        }
        return false;
    }

    public void restore() {
        while (this.undo()) {
        }
    }

    public boolean undo() {
        try {
            Memento memento = this.undoStack.poll();
            if (memento == null) {
                return false;
            }
            memento.undo();
            return true;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not undo", e);
        }
    }

    private ConstructorAccessor findConstructorAccessor(Class[] additionalParameterTypes, Class<E> clazz) throws NoSuchMethodException {
        Class[] parameterTypes = new Class[additionalParameterTypes.length + 2];
        parameterTypes[0] = String.class;
        parameterTypes[1] = Integer.TYPE;
        System.arraycopy(additionalParameterTypes, 0, parameterTypes, 2, additionalParameterTypes.length);
        Constructor<E> cstr = clazz.getDeclaredConstructor(parameterTypes);
        return this.reflection.newConstructorAccessor(cstr);
    }

    private E constructEnum(Class<E> clazz, ConstructorAccessor ca, String value, int ordinal, Object[] additional) throws Exception {
        Object[] parms = new Object[additional.length + 2];
        parms[0] = value;
        parms[1] = ordinal;
        System.arraycopy(additional, 0, parms, 2, additional.length);
        return (E)((Enum)clazz.cast(ca.newInstance(parms)));
    }

    private void addSwitchCase() {
        try {
            for (Field switchField : this.switchFields) {
                int[] switches = (int[])switchField.get(null);
                switches = Arrays.copyOf(switches, switches.length + 1);
                ReflectionHelper.setStaticFinalField(switchField, switches);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not fix switch", e);
        }
    }

    private void replaceConstant(E e) throws IllegalAccessException, NoSuchFieldException {
        Field[] fields;
        for (Field field : fields = this.clazz.getDeclaredFields()) {
            if (!field.getName().equals(((Enum)e).name())) continue;
            ReflectionHelper.setStaticFinalField(field, e);
        }
    }

    private void blankOutConstant(E e) throws IllegalAccessException, NoSuchFieldException {
        Field[] fields;
        for (Field field : fields = this.clazz.getDeclaredFields()) {
            if (!field.getName().equals(((Enum)e).name())) continue;
            ReflectionHelper.setStaticFinalField(field, null);
        }
    }

    private void setOrdinal(E e, int ordinal) throws NoSuchFieldException, IllegalAccessException {
        Field ordinalField = Enum.class.getDeclaredField(ORDINAL_FIELD);
        ordinalField.setAccessible(true);
        ordinalField.set(e, ordinal);
    }

    private Field findValuesField() throws NoSuchFieldException {
        Field valuesField = null;
        try {
            valuesField = this.clazz.getDeclaredField(VALUES_FIELD);
        }
        catch (NoSuchFieldException e) {
            Field[] fields;
            for (Field field : fields = this.clazz.getDeclaredFields()) {
                if (!field.getName().contains(VALUES_FIELD)) continue;
                valuesField = field;
                break;
            }
        }
        if (valuesField == null) {
            throw new RuntimeException("\u672c\u5730JVM\u4e0d\u652f\u6301\u81ea\u5b9a\u4e49\u8bcd\u6027");
        }
        valuesField.setAccessible(true);
        return valuesField;
    }

    public void registerSwitchClass(Class[] switchUsers) {
        this.switchFields.addAll(this.findRelatedSwitchFields(switchUsers));
    }

    private Collection<Field> findRelatedSwitchFields(Class[] switchUsers) {
        LinkedList<Field> result = new LinkedList<Field>();
        try {
            for (Class switchUser : switchUsers) {
                String name = switchUser.getName();
                int i = 0;
                try {
                    block5: while (true) {
                        Field[] fields;
                        Class<?> suspect = Class.forName(String.format("%s$%d", name, ++i));
                        Field[] fieldArray = fields = suspect.getDeclaredFields();
                        int n = fieldArray.length;
                        int n2 = 0;
                        while (true) {
                            if (n2 >= n) continue block5;
                            Field field = fieldArray[n2];
                            String fieldName = field.getName();
                            if (fieldName.startsWith("$SwitchMap$") && fieldName.endsWith(this.clazz.getSimpleName())) {
                                field.setAccessible(true);
                                result.add(field);
                            }
                            ++n2;
                        }
                        break;
                    }
                }
                catch (ClassNotFoundException e) {
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not fix switch", e);
        }
        return result;
    }

    private void removeSwitchCase(int ordinal) {
        try {
            for (Field switchField : this.switchFields) {
                int[] switches = (int[])switchField.get(null);
                int[] newSwitches = Arrays.copyOf(switches, switches.length - 1);
                System.arraycopy(switches, ordinal + 1, newSwitches, ordinal, switches.length - ordinal - 1);
                ReflectionHelper.setStaticFinalField(switchField, newSwitches);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not fix switch", e);
        }
    }

    private E[] values() throws NoSuchFieldException, IllegalAccessException {
        Field valuesField = this.findValuesField();
        return (Enum[])valuesField.get(null);
    }

    private class Memento {
        private final E[] values;
        private final Map<Field, int[]> savedSwitchFieldValues = new HashMap<Field, int[]>();

        private Memento() throws IllegalAccessException {
            try {
                this.values = (Enum[])EnumBuster.this.values().clone();
                for (Field switchField : EnumBuster.this.switchFields) {
                    int[] switchArray = (int[])switchField.get(null);
                    this.savedSwitchFieldValues.put(switchField, (int[])switchArray.clone());
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not create the class", e);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void undo() throws NoSuchFieldException, IllegalAccessException {
            void var5_8;
            Field valuesField = EnumBuster.this.findValuesField();
            ReflectionHelper.setStaticFinalField(valuesField, this.values);
            for (int i = 0; i < this.values.length; ++i) {
                EnumBuster.this.setOrdinal(this.values[i], i);
            }
            HashMap valuesMap = new HashMap();
            E[] EArray = this.values;
            int n = EArray.length;
            boolean bl = false;
            while (var5_8 < n) {
                Object e = EArray[var5_8];
                valuesMap.put(((Enum)e).name(), e);
                ++var5_8;
            }
            Field[] constantEnumFields = EnumBuster.this.clazz.getDeclaredFields();
            for (Field constantEnumField : constantEnumFields) {
                Enum en = (Enum)valuesMap.get(constantEnumField.getName());
                if (en == null) continue;
                ReflectionHelper.setStaticFinalField(constantEnumField, en);
            }
            for (Map.Entry entry : this.savedSwitchFieldValues.entrySet()) {
                Field field = (Field)entry.getKey();
                int[] mappings = (int[])entry.getValue();
                ReflectionHelper.setStaticFinalField(field, mappings);
            }
        }
    }
}

