/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dependency;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.corpus.dependency.CoNll.CoNLLSentence;
import com.hankcs.hanlp.corpus.dependency.CoNll.CoNLLWord;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.dependency.IDependencyParser;
import com.hankcs.hanlp.seg.Segment;
import com.hankcs.hanlp.utility.GlobalObjectPool;
import java.util.Map;
import java.util.TreeMap;

public abstract class AbstractDependencyParser
implements IDependencyParser {
    private Segment segment = HanLP.newSegment().enablePartOfSpeechTagging(true);
    private Map<String, String> deprelTranslater;
    private boolean enableDeprelTranslater;

    @Override
    public CoNLLSentence parse(String sentence) {
        assert (sentence != null);
        CoNLLSentence output = this.parse(this.segment.seg(sentence.toCharArray()));
        if (this.enableDeprelTranslater && this.deprelTranslater != null) {
            for (CoNLLWord word : output) {
                String translatedDeprel;
                word.DEPREL = translatedDeprel = this.deprelTranslater.get(word.DEPREL);
            }
        }
        return output;
    }

    @Override
    public Segment getSegment() {
        return this.segment;
    }

    @Override
    public IDependencyParser setSegment(Segment segment) {
        this.segment = segment;
        return this;
    }

    @Override
    public Map<String, String> getDeprelTranslator() {
        return this.deprelTranslater;
    }

    @Override
    public IDependencyParser setDeprelTranslator(Map<String, String> deprelTranslator) {
        this.deprelTranslater = deprelTranslator;
        return this;
    }

    public IDependencyParser setDeprelTranslater(String deprelTranslatorPath) {
        this.deprelTranslater = (Map)GlobalObjectPool.get(deprelTranslatorPath);
        if (this.deprelTranslater != null) {
            return this;
        }
        IOUtil.LineIterator iterator = new IOUtil.LineIterator(deprelTranslatorPath);
        this.deprelTranslater = new TreeMap<String, String>();
        while (iterator.hasNext()) {
            String[] args = iterator.next().split("\\s");
            this.deprelTranslater.put(args[0], args[1]);
        }
        if (this.deprelTranslater.size() == 0) {
            this.deprelTranslater = null;
        }
        GlobalObjectPool.put(deprelTranslatorPath, this.deprelTranslater);
        return this;
    }

    @Override
    public IDependencyParser enableDeprelTranslator(boolean enable) {
        this.enableDeprelTranslater = enable;
        return this;
    }
}

