/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.utility;

import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.corpus.util.CustomNatureUtility;
import com.hankcs.hanlp.dictionary.CoreDictionary;
import com.hankcs.hanlp.dictionary.CustomDictionary;
import com.hankcs.hanlp.seg.common.Term;
import java.util.Arrays;
import java.util.LinkedHashSet;

public class LexiconUtility {
    public static CoreDictionary.Attribute getAttribute(String word) {
        CoreDictionary.Attribute attribute = CoreDictionary.get(word);
        if (attribute != null) {
            return attribute;
        }
        return CustomDictionary.get(word);
    }

    public static CoreDictionary.Attribute getAttribute(Term term) {
        return LexiconUtility.getAttribute(term.word);
    }

    public static int getFrequency(String word) {
        CoreDictionary.Attribute attribute = LexiconUtility.getAttribute(word);
        if (attribute == null) {
            return 0;
        }
        return attribute.totalFrequency;
    }

    public static boolean setAttribute(String word, CoreDictionary.Attribute attribute) {
        if (attribute == null) {
            return false;
        }
        if (CoreDictionary.trie.set(word, attribute)) {
            return true;
        }
        if (CustomDictionary.dat.set(word, attribute)) {
            return true;
        }
        if (CustomDictionary.trie == null) {
            CustomDictionary.add(word);
        }
        CustomDictionary.trie.put(word, attribute);
        return true;
    }

    public static boolean setAttribute(String word, Nature ... natures) {
        if (natures == null) {
            return false;
        }
        CoreDictionary.Attribute attribute = new CoreDictionary.Attribute(natures, new int[natures.length]);
        Arrays.fill(attribute.frequency, 1);
        return LexiconUtility.setAttribute(word, attribute);
    }

    public static boolean setAttribute(String word, String ... natures) {
        if (natures == null) {
            return false;
        }
        Nature[] natureArray = new Nature[natures.length];
        for (int i = 0; i < natureArray.length; ++i) {
            natureArray[i] = Nature.create(natures[i]);
        }
        return LexiconUtility.setAttribute(word, natureArray);
    }

    public static boolean setAttribute(String word, String natureWithFrequency) {
        CoreDictionary.Attribute attribute = CoreDictionary.Attribute.create(natureWithFrequency);
        return LexiconUtility.setAttribute(word, attribute);
    }

    public static Nature convertStringToNature(String name, LinkedHashSet<Nature> customNatureCollector) {
        try {
            return Nature.valueOf(name);
        }
        catch (Exception e) {
            Nature nature = CustomNatureUtility.addNature(name);
            if (customNatureCollector != null) {
                customNatureCollector.add(nature);
            }
            return nature;
        }
    }
}

