/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary.common;

import com.hankcs.hanlp.algoritm.ArrayDistance;
import com.hankcs.hanlp.collection.trie.DoubleArrayTrie;
import com.hankcs.hanlp.corpus.synonym.Synonym;
import com.hankcs.hanlp.utility.Predefine;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class CommonSynonymDictionaryEx {
    DoubleArrayTrie<Long[]> trie;

    private CommonSynonymDictionaryEx() {
    }

    public static CommonSynonymDictionaryEx create(InputStream inputStream) {
        CommonSynonymDictionaryEx dictionary = new CommonSynonymDictionaryEx();
        if (dictionary.load(inputStream)) {
            return dictionary;
        }
        return null;
    }

    public boolean load(InputStream inputStream) {
        this.trie = new DoubleArrayTrie();
        TreeMap<String, TreeSet<Long>> treeMap = new TreeMap<String, TreeSet<Long>>();
        String line = null;
        try {
            BufferedReader bw = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            while ((line = bw.readLine()) != null) {
                String[] args = line.split(" ");
                ArrayList<Synonym> synonymList = Synonym.create(args);
                Iterator iterator = synonymList.iterator();
                while (iterator.hasNext()) {
                    Synonym synonym = (Synonym)iterator.next();
                    TreeSet<Long> idSet = (TreeSet<Long>)treeMap.get(synonym.realWord);
                    if (idSet == null) {
                        idSet = new TreeSet<Long>();
                        treeMap.put(synonym.realWord, idSet);
                    }
                    idSet.add(synonym.id);
                }
            }
            bw.close();
            ArrayList<String> keyList = new ArrayList<String>(treeMap.size());
            for (Object key : treeMap.keySet()) {
                keyList.add((String)key);
            }
            ArrayList<Long[]> valueList = new ArrayList<Long[]>(treeMap.size());
            for (Set idSet : treeMap.values()) {
                valueList.add(idSet.toArray(new Long[0]));
            }
            int resultCode = this.trie.build(keyList, valueList);
            if (resultCode != 0) {
                Predefine.logger.warning("\u6784\u5efa" + inputStream + "\u5931\u8d25\uff0c\u9519\u8bef\u7801" + resultCode);
                return false;
            }
        }
        catch (Exception e) {
            Predefine.logger.warning("\u8bfb\u53d6" + inputStream + "\u5931\u8d25\uff0c\u53ef\u80fd\u7531\u884c" + line + "\u9020\u6210" + e);
            return false;
        }
        return true;
    }

    public Long[] get(String key) {
        return this.trie.get(key);
    }

    public long distance(String a, String b) {
        Long[] itemA = this.get(a);
        if (itemA == null) {
            return 0x2AAAAAAAAAAAAAAAL;
        }
        Long[] itemB = this.get(b);
        if (itemB == null) {
            return 0x2AAAAAAAAAAAAAAAL;
        }
        return ArrayDistance.computeAverageDistance(itemA, itemB);
    }

    public static class SynonymItem
    extends Synonym {
        public Map<String, Synonym> synonymMap;

        public SynonymItem(Synonym entry, Map<String, Synonym> synonymMap) {
            super(entry.realWord, entry.id, entry.type);
            this.synonymMap = synonymMap;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            sb.append(' ');
            sb.append(this.synonymMap);
            return sb.toString();
        }
    }
}

