/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.collection.MDAG;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.MDAG.MDAGNode;
import com.hankcs.hanlp.collection.MDAG.SimpleMDAGNode;
import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.corpus.io.ICacheAble;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;

public class MDAG
implements ICacheAble {
    protected MDAGNode sourceNode = new MDAGNode(false);
    protected SimpleMDAGNode simplifiedSourceNode;
    protected HashMap<MDAGNode, MDAGNode> equivalenceClassMDAGNodeHashMap = new HashMap();
    protected SimpleMDAGNode[] mdagDataArray;
    protected TreeSet<Character> charTreeSet = new TreeSet();
    protected int transitionCount;

    @Override
    public void save(DataOutputStream out) throws Exception {
        this.simplify();
        out.writeInt(this.charTreeSet.size());
        for (Character character : this.charTreeSet) {
            out.writeChar(character.charValue());
        }
        this.simplifiedSourceNode.save(out);
        out.writeInt(this.mdagDataArray.length);
        for (SimpleMDAGNode simpleMDAGNode : this.mdagDataArray) {
            simpleMDAGNode.save(out);
        }
    }

    @Override
    public boolean load(ByteArray byteArray) {
        int i;
        int length = byteArray.nextInt();
        for (i = 0; i < length; ++i) {
            this.charTreeSet.add(Character.valueOf(byteArray.nextChar()));
        }
        this.simplifiedSourceNode = new SimpleMDAGNode();
        this.simplifiedSourceNode.load(byteArray);
        length = byteArray.nextInt();
        this.mdagDataArray = new SimpleMDAGNode[length];
        for (i = 0; i < length; ++i) {
            this.mdagDataArray[i] = new SimpleMDAGNode();
            this.mdagDataArray[i].load(byteArray);
        }
        this.sourceNode = null;
        return true;
    }

    public MDAG(File dataFile) throws IOException {
        BufferedReader dataFileBufferedReader = new BufferedReader(new InputStreamReader(HanLP.Config.IOAdapter == null ? new FileInputStream(dataFile) : HanLP.Config.IOAdapter.open(dataFile.getAbsolutePath()), "UTF-8"));
        String currentString = "";
        String previousString = "";
        while ((currentString = dataFileBufferedReader.readLine()) != null) {
            int mpsIndex = this.calculateMinimizationProcessingStartIndex(previousString, currentString);
            if (mpsIndex != -1) {
                String transitionSubstring = previousString.substring(0, mpsIndex);
                String minimizationProcessingSubstring = previousString.substring(mpsIndex);
                this.replaceOrRegister(this.sourceNode.transition(transitionSubstring), minimizationProcessingSubstring);
            }
            this.addStringInternal(currentString);
            previousString = currentString;
        }
        this.replaceOrRegister(this.sourceNode, previousString);
    }

    public MDAG(Collection<String> strCollection) {
        this.addStrings(strCollection);
    }

    public MDAG() {
    }

    public final void addStrings(Collection<String> strCollection) {
        if (this.sourceNode != null) {
            String previousString = "";
            for (String currentString : strCollection) {
                int mpsIndex = this.calculateMinimizationProcessingStartIndex(previousString, currentString);
                if (mpsIndex != -1) {
                    String transitionSubstring = previousString.substring(0, mpsIndex);
                    String minimizationProcessingSubString = previousString.substring(mpsIndex);
                    this.replaceOrRegister(this.sourceNode.transition(transitionSubstring), minimizationProcessingSubString);
                }
                this.addStringInternal(currentString);
                previousString = currentString;
            }
            this.replaceOrRegister(this.sourceNode, previousString);
        } else {
            this.unSimplify();
            this.addStrings(strCollection);
        }
    }

    public void addString(String str) {
        if (this.sourceNode != null) {
            this.addStringInternal(str);
            this.replaceOrRegister(this.sourceNode, str);
        } else {
            this.unSimplify();
            this.addString(str);
        }
    }

    private void splitTransitionPath(MDAGNode originNode, String storedStringSubstr) {
        HashMap<String, Object> firstConfluenceNodeDataHashMap = this.getTransitionPathFirstConfluenceNodeData(originNode, storedStringSubstr);
        Integer toFirstConfluenceNodeTransitionCharIndex = (Integer)firstConfluenceNodeDataHashMap.get("toConfluenceNodeTransitionCharIndex");
        MDAGNode firstConfluenceNode = (MDAGNode)firstConfluenceNodeDataHashMap.get("confluenceNode");
        if (firstConfluenceNode != null) {
            MDAGNode firstConfluenceNodeParent = originNode.transition(storedStringSubstr.substring(0, toFirstConfluenceNodeTransitionCharIndex));
            MDAGNode firstConfluenceNodeClone = firstConfluenceNode.clone(firstConfluenceNodeParent, storedStringSubstr.charAt(toFirstConfluenceNodeTransitionCharIndex));
            this.transitionCount += firstConfluenceNodeClone.getOutgoingTransitionCount();
            String unprocessedSubString = storedStringSubstr.substring(toFirstConfluenceNodeTransitionCharIndex + 1);
            this.splitTransitionPath(firstConfluenceNodeClone, unprocessedSubString);
        }
    }

    private int calculateSoleTransitionPathLength(String str) {
        MDAGNode currentNode;
        Stack<MDAGNode> transitionPathNodeStack = this.sourceNode.getTransitionPathNodes(str);
        transitionPathNodeStack.pop();
        transitionPathNodeStack.trimToSize();
        while (!transitionPathNodeStack.isEmpty() && (currentNode = transitionPathNodeStack.peek()).getOutgoingTransitions().size() <= 1 && !currentNode.isAcceptNode()) {
            transitionPathNodeStack.pop();
        }
        return transitionPathNodeStack.capacity() - transitionPathNodeStack.size();
    }

    public void removeString(String str) {
        if (this.sourceNode != null) {
            this.splitTransitionPath(this.sourceNode, str);
            this.removeTransitionPathRegisterEntries(str);
            MDAGNode strEndNode = this.sourceNode.transition(str);
            if (strEndNode == null) {
                return;
            }
            if (!strEndNode.hasTransitions()) {
                int internalTransitionPathLength;
                int soleInternalTransitionPathLength = this.calculateSoleTransitionPathLength(str);
                if (soleInternalTransitionPathLength == (internalTransitionPathLength = str.length() - 1)) {
                    this.sourceNode.removeOutgoingTransition(str.charAt(0));
                    this.transitionCount -= str.length();
                } else {
                    int toBeRemovedTransitionLabelCharIndex = internalTransitionPathLength - soleInternalTransitionPathLength;
                    MDAGNode latestNonSoloTransitionPathNode = this.sourceNode.transition(str.substring(0, toBeRemovedTransitionLabelCharIndex));
                    latestNonSoloTransitionPathNode.removeOutgoingTransition(str.charAt(toBeRemovedTransitionLabelCharIndex));
                    this.transitionCount -= str.substring(toBeRemovedTransitionLabelCharIndex).length();
                    this.replaceOrRegister(this.sourceNode, str.substring(0, toBeRemovedTransitionLabelCharIndex));
                }
            } else {
                strEndNode.setAcceptStateStatus(false);
                this.replaceOrRegister(this.sourceNode, str);
            }
        } else {
            this.unSimplify();
        }
    }

    private int calculateMinimizationProcessingStartIndex(String prevStr, String currStr) {
        int mpsIndex;
        if (!currStr.startsWith(prevStr)) {
            int shortestStringLength = Math.min(prevStr.length(), currStr.length());
            for (mpsIndex = 0; mpsIndex < shortestStringLength && prevStr.charAt(mpsIndex) == currStr.charAt(mpsIndex); ++mpsIndex) {
            }
        } else {
            mpsIndex = -1;
        }
        return mpsIndex;
    }

    private String determineLongestPrefixInMDAG(String str) {
        char currentChar;
        MDAGNode currentNode = this.sourceNode;
        int numberOfChars = str.length();
        int onePastPrefixEndIndex = 0;
        int i = 0;
        while (i < numberOfChars && currentNode.hasOutgoingTransition(currentChar = str.charAt(i))) {
            currentNode = currentNode.transition(currentChar);
            ++i;
            ++onePastPrefixEndIndex;
        }
        return str.substring(0, onePastPrefixEndIndex);
    }

    private HashMap<String, Object> getTransitionPathFirstConfluenceNodeData(MDAGNode originNode, String str) {
        int currentIndex;
        int charCount = str.length();
        MDAGNode currentNode = originNode;
        for (currentIndex = 0; currentIndex < charCount; ++currentIndex) {
            char currentChar = str.charAt(currentIndex);
            MDAGNode mDAGNode = currentNode = currentNode.hasOutgoingTransition(currentChar) ? currentNode.transition(currentChar) : null;
            if (currentNode == null || currentNode.isConfluenceNode()) break;
        }
        boolean noConfluenceNode = currentNode == originNode || currentIndex == charCount;
        HashMap<String, Object> confluenceNodeDataHashMap = new HashMap<String, Object>(2);
        confluenceNodeDataHashMap.put("toConfluenceNodeTransitionCharIndex", noConfluenceNode ? null : Integer.valueOf(currentIndex));
        confluenceNodeDataHashMap.put("confluenceNode", noConfluenceNode ? null : currentNode);
        return confluenceNodeDataHashMap;
    }

    private void replaceOrRegister(MDAGNode originNode, String str) {
        MDAGNode equivalentNode;
        char transitionLabelChar = str.charAt(0);
        MDAGNode relevantTargetNode = originNode.transition(transitionLabelChar);
        if (relevantTargetNode.hasTransitions() && !str.substring(1).isEmpty()) {
            this.replaceOrRegister(relevantTargetNode, str.substring(1));
        }
        if ((equivalentNode = this.equivalenceClassMDAGNodeHashMap.get(relevantTargetNode)) == null) {
            this.equivalenceClassMDAGNodeHashMap.put(relevantTargetNode, relevantTargetNode);
        } else if (equivalentNode != relevantTargetNode) {
            relevantTargetNode.decrementTargetIncomingTransitionCounts();
            this.transitionCount -= relevantTargetNode.getOutgoingTransitionCount();
            originNode.reassignOutgoingTransition(transitionLabelChar, relevantTargetNode, equivalentNode);
        }
    }

    private void addTransitionPath(MDAGNode originNode, String str) {
        if (!str.isEmpty()) {
            MDAGNode currentNode = originNode;
            int charCount = str.length();
            int i = 0;
            while (i < charCount) {
                char currentChar = str.charAt(i);
                boolean isLastChar = i == charCount - 1;
                currentNode = currentNode.addOutgoingTransition(currentChar, isLastChar);
                this.charTreeSet.add(Character.valueOf(currentChar));
                ++i;
                ++this.transitionCount;
            }
        } else {
            originNode.setAcceptStateStatus(true);
        }
    }

    private void removeTransitionPathRegisterEntries(String str) {
        MDAGNode currentNode = this.sourceNode;
        int charCount = str.length();
        for (int i = 0; i < charCount; ++i) {
            if (this.equivalenceClassMDAGNodeHashMap.get(currentNode = currentNode.transition(str.charAt(i))) == currentNode) {
                this.equivalenceClassMDAGNodeHashMap.remove(currentNode);
            }
            if (currentNode == null) continue;
            currentNode.clearStoredHashCode();
        }
    }

    private void cloneTransitionPath(MDAGNode pivotConfluenceNode, String transitionStringToPivotNode, String str) {
        MDAGNode lastTargetNode = pivotConfluenceNode.transition(str);
        MDAGNode lastClonedNode = null;
        char lastTransitionLabelChar = '\u0000';
        for (int i = str.length(); i >= 0; --i) {
            MDAGNode clonedNode;
            MDAGNode currentTargetNode;
            String currentTransitionString = i > 0 ? str.substring(0, i) : null;
            MDAGNode mDAGNode = currentTargetNode = i > 0 ? pivotConfluenceNode.transition(currentTransitionString) : pivotConfluenceNode;
            if (i == 0) {
                String transitionStringToPivotNodeParent = transitionStringToPivotNode.substring(0, transitionStringToPivotNode.length() - 1);
                char parentTransitionLabelChar = transitionStringToPivotNode.charAt(transitionStringToPivotNode.length() - 1);
                clonedNode = pivotConfluenceNode.clone(this.sourceNode.transition(transitionStringToPivotNodeParent), parentTransitionLabelChar);
            } else {
                clonedNode = currentTargetNode.clone();
            }
            this.transitionCount += clonedNode.getOutgoingTransitionCount();
            if (lastClonedNode != null) {
                clonedNode.reassignOutgoingTransition(lastTransitionLabelChar, lastTargetNode, lastClonedNode);
                lastTargetNode = currentTargetNode;
            }
            lastClonedNode = clonedNode;
            lastTransitionLabelChar = i > 0 ? str.charAt(i - 1) : (char)'\u0000';
        }
    }

    private void addStringInternal(String str) {
        String prefixString = this.determineLongestPrefixInMDAG(str);
        String suffixString = str.substring(prefixString.length());
        HashMap<String, Object> firstConfluenceNodeDataHashMap = this.getTransitionPathFirstConfluenceNodeData(this.sourceNode, prefixString);
        MDAGNode firstConfluenceNodeInPrefix = (MDAGNode)firstConfluenceNodeDataHashMap.get("confluenceNode");
        Integer toFirstConfluenceNodeTransitionCharIndex = (Integer)firstConfluenceNodeDataHashMap.get("toConfluenceNodeTransitionCharIndex");
        this.removeTransitionPathRegisterEntries(toFirstConfluenceNodeTransitionCharIndex == null ? prefixString : prefixString.substring(0, toFirstConfluenceNodeTransitionCharIndex));
        if (firstConfluenceNodeInPrefix != null) {
            String transitionStringOfPathToFirstConfluenceNode = prefixString.substring(0, toFirstConfluenceNodeTransitionCharIndex + 1);
            String transitionStringOfToBeDuplicatedPath = prefixString.substring(toFirstConfluenceNodeTransitionCharIndex + 1);
            this.cloneTransitionPath(firstConfluenceNodeInPrefix, transitionStringOfPathToFirstConfluenceNode, transitionStringOfToBeDuplicatedPath);
        }
        this.addTransitionPath(this.sourceNode.transition(prefixString), suffixString);
    }

    private int createSimpleMDAGTransitionSet(MDAGNode node, SimpleMDAGNode[] mdagDataArray, int onePastLastCreatedTransitionSetIndex) {
        int pivotIndex = onePastLastCreatedTransitionSetIndex;
        node.setTransitionSetBeginIndex(pivotIndex);
        onePastLastCreatedTransitionSetIndex += node.getOutgoingTransitionCount();
        TreeMap<Character, MDAGNode> transitionTreeMap = node.getOutgoingTransitions();
        for (Map.Entry<Character, MDAGNode> transitionKeyValuePair : transitionTreeMap.entrySet()) {
            char transitionLabelChar = transitionKeyValuePair.getKey().charValue();
            MDAGNode transitionTargetNode = transitionKeyValuePair.getValue();
            mdagDataArray[pivotIndex] = new SimpleMDAGNode(transitionLabelChar, transitionTargetNode.isAcceptNode(), transitionTargetNode.getOutgoingTransitionCount());
            if (transitionTargetNode.getTransitionSetBeginIndex() == -1) {
                onePastLastCreatedTransitionSetIndex = this.createSimpleMDAGTransitionSet(transitionTargetNode, mdagDataArray, onePastLastCreatedTransitionSetIndex);
            }
            mdagDataArray[pivotIndex++].setTransitionSetBeginIndex(transitionTargetNode.getTransitionSetBeginIndex());
        }
        return onePastLastCreatedTransitionSetIndex;
    }

    public void simplify() {
        if (this.sourceNode != null) {
            this.mdagDataArray = new SimpleMDAGNode[this.transitionCount];
            this.createSimpleMDAGTransitionSet(this.sourceNode, this.mdagDataArray, 0);
            this.simplifiedSourceNode = new SimpleMDAGNode('\u0000', false, this.sourceNode.getOutgoingTransitionCount());
            this.sourceNode = null;
            this.equivalenceClassMDAGNodeHashMap = null;
        }
    }

    public void unSimplify() {
        if (this.sourceNode == null) {
            this.sourceNode = new MDAGNode(false);
            this.equivalenceClassMDAGNodeHashMap = new HashMap();
            MDAGNode[] toNodeArray = new MDAGNode[this.mdagDataArray.length];
            this.createMDAGNode(this.simplifiedSourceNode, -1, toNodeArray, new MDAGNode[this.mdagDataArray.length]);
            for (MDAGNode mdagNode : toNodeArray) {
                this.equivalenceClassMDAGNodeHashMap.put(mdagNode, mdagNode);
            }
            this.simplifiedSourceNode = null;
        }
    }

    private void createMDAGNode(SimpleMDAGNode current, int fromIndex, MDAGNode[] toNodeArray, MDAGNode[] fromNodeArray) {
        MDAGNode from = fromIndex == -1 ? this.sourceNode : toNodeArray[fromIndex];
        int transitionSetBegin = current.getTransitionSetBeginIndex();
        int onePastTransitionSetEnd = transitionSetBegin + current.getOutgoingTransitionSetSize();
        for (int i = transitionSetBegin; i < onePastTransitionSetEnd; ++i) {
            SimpleMDAGNode targetNode = this.mdagDataArray[i];
            if (toNodeArray[i] != null) {
                fromNodeArray[fromIndex].addOutgoingTransition(current.getLetter(), fromNodeArray[i]);
                toNodeArray[fromIndex] = fromNodeArray[i];
                continue;
            }
            toNodeArray[i] = from.addOutgoingTransition(targetNode.getLetter(), targetNode.isAcceptNode());
            fromNodeArray[i] = from;
            this.createMDAGNode(targetNode, i, toNodeArray, fromNodeArray);
        }
    }

    public boolean contains(String str) {
        if (this.sourceNode != null) {
            MDAGNode targetNode = this.sourceNode.transition(str.toCharArray());
            return targetNode != null && targetNode.isAcceptNode();
        }
        SimpleMDAGNode targetNode = this.simplifiedSourceNode.transition(this.mdagDataArray, str.toCharArray());
        return targetNode != null && targetNode.isAcceptNode();
    }

    private void getStrings(HashSet<String> strHashSet, SearchCondition searchCondition, String searchConditionString, String prefixString, TreeMap<Character, MDAGNode> transitionTreeMap) {
        for (Map.Entry<Character, MDAGNode> transitionKeyValuePair : transitionTreeMap.entrySet()) {
            String newPrefixString = prefixString + transitionKeyValuePair.getKey();
            MDAGNode currentNode = transitionKeyValuePair.getValue();
            if (currentNode.isAcceptNode() && searchCondition.satisfiesCondition(newPrefixString, searchConditionString)) {
                strHashSet.add(newPrefixString);
            }
            this.getStrings(strHashSet, searchCondition, searchConditionString, newPrefixString, currentNode.getOutgoingTransitions());
        }
    }

    private void getStrings(HashSet<String> strHashSet, SearchCondition searchCondition, String searchConditionString, String prefixString, SimpleMDAGNode node) {
        int transitionSetBegin = node.getTransitionSetBeginIndex();
        int onePastTransitionSetEnd = transitionSetBegin + node.getOutgoingTransitionSetSize();
        for (int i = transitionSetBegin; i < onePastTransitionSetEnd; ++i) {
            SimpleMDAGNode currentNode = this.mdagDataArray[i];
            String newPrefixString = prefixString + currentNode.getLetter();
            if (currentNode.isAcceptNode() && searchCondition.satisfiesCondition(newPrefixString, searchConditionString)) {
                strHashSet.add(newPrefixString);
            }
            this.getStrings(strHashSet, searchCondition, searchConditionString, newPrefixString, currentNode);
        }
    }

    public HashSet<String> getAllStrings() {
        LinkedHashSet<String> strHashSet = new LinkedHashSet<String>();
        if (this.sourceNode != null) {
            this.getStrings(strHashSet, SearchCondition.NO_SEARCH_CONDITION, null, "", this.sourceNode.getOutgoingTransitions());
        } else {
            this.getStrings(strHashSet, SearchCondition.NO_SEARCH_CONDITION, null, "", this.simplifiedSourceNode);
        }
        return strHashSet;
    }

    public HashSet<String> getStringsStartingWith(String prefixStr) {
        HashSet<String> strHashSet = new HashSet<String>();
        if (this.sourceNode != null) {
            MDAGNode originNode = this.sourceNode.transition(prefixStr);
            if (originNode != null) {
                if (originNode.isAcceptNode()) {
                    strHashSet.add(prefixStr);
                }
                this.getStrings(strHashSet, SearchCondition.PREFIX_SEARCH_CONDITION, prefixStr, prefixStr, originNode.getOutgoingTransitions());
            }
        } else {
            SimpleMDAGNode originNode = SimpleMDAGNode.traverseMDAG(this.mdagDataArray, this.simplifiedSourceNode, prefixStr);
            if (originNode != null) {
                if (originNode.isAcceptNode()) {
                    strHashSet.add(prefixStr);
                }
                this.getStrings(strHashSet, SearchCondition.PREFIX_SEARCH_CONDITION, prefixStr, prefixStr, originNode);
            }
        }
        return strHashSet;
    }

    public HashSet<String> getStringsWithSubstring(String str) {
        HashSet<String> strHashSet = new HashSet<String>();
        if (this.sourceNode != null) {
            this.getStrings(strHashSet, SearchCondition.SUBSTRING_SEARCH_CONDITION, str, "", this.sourceNode.getOutgoingTransitions());
        } else {
            this.getStrings(strHashSet, SearchCondition.SUBSTRING_SEARCH_CONDITION, str, "", this.simplifiedSourceNode);
        }
        return strHashSet;
    }

    public HashSet<String> getStringsEndingWith(String suffixStr) {
        HashSet<String> strHashSet = new HashSet<String>();
        if (this.sourceNode != null) {
            this.getStrings(strHashSet, SearchCondition.SUFFIX_SEARCH_CONDITION, suffixStr, "", this.sourceNode.getOutgoingTransitions());
        } else {
            this.getStrings(strHashSet, SearchCondition.SUFFIX_SEARCH_CONDITION, suffixStr, "", this.simplifiedSourceNode);
        }
        return strHashSet;
    }

    private Object getSourceNode() {
        return this.sourceNode != null ? this.sourceNode : this.simplifiedSourceNode;
    }

    public SimpleMDAGNode[] getSimpleMDAGArray() {
        return this.mdagDataArray;
    }

    private TreeSet<Character> getTransitionLabelSet() {
        return this.charTreeSet;
    }

    private static boolean isAcceptNode(Object nodeObj) {
        if (nodeObj != null) {
            Class<?> nodeObjClass = nodeObj.getClass();
            if (nodeObjClass.equals(MDAGNode.class)) {
                return ((MDAGNode)nodeObj).isAcceptNode();
            }
            if (nodeObjClass.equals(SimpleMDAGNode.class)) {
                return ((SimpleMDAGNode)nodeObj).isAcceptNode();
            }
        }
        throw new IllegalArgumentException("Argument is not an MDAGNode or SimpleMDAGNode");
    }

    public HashMap<MDAGNode, MDAGNode> _getEquivalenceClassMDAGNodeHashMap() {
        return new HashMap<MDAGNode, MDAGNode>(this.equivalenceClassMDAGNodeHashMap);
    }

    private static enum SearchCondition {
        NO_SEARCH_CONDITION,
        PREFIX_SEARCH_CONDITION,
        SUBSTRING_SEARCH_CONDITION,
        SUFFIX_SEARCH_CONDITION;


        public boolean satisfiesCondition(String str1, String str2) {
            boolean satisfiesSearchCondition;
            switch (this) {
                case PREFIX_SEARCH_CONDITION: {
                    satisfiesSearchCondition = str1.startsWith(str2);
                    break;
                }
                case SUBSTRING_SEARCH_CONDITION: {
                    satisfiesSearchCondition = str1.contains(str2);
                    break;
                }
                case SUFFIX_SEARCH_CONDITION: {
                    satisfiesSearchCondition = str1.endsWith(str2);
                    break;
                }
                default: {
                    satisfiesSearchCondition = true;
                }
            }
            return satisfiesSearchCondition;
        }
    }
}

