/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.bigram;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.trie.DoubleArrayTrie;
import com.hankcs.hanlp.corpus.dependency.model.WordNatureWeightModelMaker;
import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.dependency.common.Edge;
import com.hankcs.hanlp.dependency.common.Node;
import com.hankcs.hanlp.utility.Predefine;
import java.io.DataOutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public class WordNatureDependencyModel {
    static DoubleArrayTrie<Attribute> trie;

    static boolean load(String path) {
        Attribute attribute;
        trie = new DoubleArrayTrie();
        if (WordNatureDependencyModel.loadDat(path)) {
            return true;
        }
        TreeMap<String, Attribute> map = new TreeMap<String, Attribute>();
        TreeMap<String, Integer> tagMap = new TreeMap<String, Integer>();
        for (String string : IOUtil.readLineListWithLessMemory(path)) {
            String[] param = string.split(" ");
            if (param[0].endsWith("@")) {
                tagMap.put(param[0], Integer.parseInt(param[2]));
                continue;
            }
            int natureCount = (param.length - 1) / 2;
            attribute = new Attribute(natureCount);
            for (int i = 0; i < natureCount; ++i) {
                attribute.dependencyRelation[i] = param[1 + 2 * i];
                attribute.p[i] = Integer.parseInt(param[2 + 2 * i]);
            }
            map.put(param[0], attribute);
        }
        if (map.size() == 0) {
            return false;
        }
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            String[] param = key.split("@", 2);
            attribute = (Attribute)entry.getValue();
            int total = (Integer)tagMap.get(param[0] + "@");
            for (int i = 0; i < attribute.p.length; ++i) {
                attribute.p[i] = (float)(-Math.log(attribute.p[i] / (float)total));
            }
            float boost = 1.0f;
            if (key.startsWith("<")) {
                boost *= 10.0f;
            }
            if (key.endsWith(">")) {
                boost *= 10.0f;
            }
            if (boost == 1.0f) continue;
            attribute.setBoost(boost);
        }
        trie.build(map);
        if (!WordNatureDependencyModel.saveDat(path, map)) {
            Predefine.logger.warning("\u7f13\u5b58" + path + "\u5931\u8d25");
        }
        return true;
    }

    static boolean saveDat(String path, TreeMap<String, Attribute> map) {
        Collection<Attribute> attributeList = map.values();
        try {
            DataOutputStream out = new DataOutputStream(IOUtil.newOutputStream(path + ".bin"));
            out.writeInt(attributeList.size());
            for (Attribute attribute : attributeList) {
                out.writeInt(attribute.p.length);
                for (int i = 0; i < attribute.p.length; ++i) {
                    char[] charArray = attribute.dependencyRelation[i].toCharArray();
                    out.writeInt(charArray.length);
                    for (char c : charArray) {
                        out.writeChar(c);
                    }
                    out.writeFloat(attribute.p[i]);
                }
            }
            if (!trie.save(out)) {
                return false;
            }
            out.close();
        }
        catch (Exception e) {
            Predefine.logger.warning("\u4fdd\u5b58\u5931\u8d25" + e);
            return false;
        }
        return true;
    }

    static boolean loadDat(String path) {
        ByteArray byteArray = ByteArray.createByteArray(path + ".bin");
        if (byteArray == null) {
            return false;
        }
        int size = byteArray.nextInt();
        Attribute[] attributeArray = new Attribute[size];
        for (int i = 0; i < attributeArray.length; ++i) {
            int length = byteArray.nextInt();
            Attribute attribute = new Attribute(length);
            for (int j = 0; j < attribute.dependencyRelation.length; ++j) {
                attribute.dependencyRelation[j] = byteArray.nextString();
                attribute.p[j] = byteArray.nextFloat();
            }
            attributeArray[i] = attribute;
        }
        return trie.load(byteArray, (Attribute[])attributeArray);
    }

    public static Attribute get(String key) {
        return trie.get(key);
    }

    public static Edge getEdge(Node from, Node to) {
        Attribute attribute = WordNatureDependencyModel.get(from.compiledWord, to.compiledWord);
        if (attribute == null) {
            attribute = WordNatureDependencyModel.get(from.compiledWord, WordNatureWeightModelMaker.wrapTag(to.label));
        }
        if (attribute == null) {
            attribute = WordNatureDependencyModel.get(WordNatureWeightModelMaker.wrapTag(from.label), to.compiledWord);
        }
        if (attribute == null) {
            attribute = WordNatureDependencyModel.get(WordNatureWeightModelMaker.wrapTag(from.label), WordNatureWeightModelMaker.wrapTag(to.label));
        }
        if (attribute == null) {
            attribute = Attribute.NULL;
        }
        if (HanLP.Config.DEBUG) {
            System.out.println(from + " \u5230 " + to + " : " + attribute);
        }
        return new Edge(from.id, to.id, attribute.dependencyRelation[0], attribute.p[0]);
    }

    public static Attribute get(String from, String to) {
        return WordNatureDependencyModel.get(from + "@" + to);
    }

    static {
        long start = System.currentTimeMillis();
        if (WordNatureDependencyModel.load(HanLP.Config.WordNatureModelPath)) {
            Predefine.logger.info("\u52a0\u8f7d\u4f9d\u5b58\u53e5\u6cd5\u751f\u6210\u6a21\u578b" + HanLP.Config.WordNatureModelPath + "\u6210\u529f\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start) + " ms");
        } else {
            Predefine.logger.severe("\u52a0\u8f7d\u4f9d\u5b58\u53e5\u6cd5\u751f\u6210\u6a21\u578b" + HanLP.Config.WordNatureModelPath + "\u5931\u8d25\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start) + " ms");
            System.exit(-1);
        }
    }

    static class Attribute {
        static final Attribute NULL = new Attribute("\u672a\u77e5", 10000.0f);
        public String[] dependencyRelation;
        public float[] p;

        public Attribute(int size) {
            this.dependencyRelation = new String[size];
            this.p = new float[size];
        }

        Attribute(String dr, float p) {
            this.dependencyRelation = new String[]{dr};
            this.p = new float[]{p};
        }

        public void setBoost(float boost) {
            int i = 0;
            while (i < this.p.length) {
                int n = i++;
                this.p[n] = this.p[n] * boost;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.dependencyRelation.length * 10);
            for (int i = 0; i < this.dependencyRelation.length; ++i) {
                sb.append(this.dependencyRelation[i]).append(' ').append(this.p[i]).append(' ');
            }
            return sb.toString();
        }
    }
}

