/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dependency;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.trie.DoubleArrayTrie;
import com.hankcs.hanlp.collection.trie.ITrie;
import com.hankcs.hanlp.corpus.dependency.CoNll.CoNLLSentence;
import com.hankcs.hanlp.corpus.dependency.CoNll.CoNLLWord;
import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.dependency.AbstractDependencyParser;
import com.hankcs.hanlp.dependency.common.POSUtil;
import com.hankcs.hanlp.model.bigram.BigramDependencyModel;
import com.hankcs.hanlp.model.crf.CRFModel;
import com.hankcs.hanlp.model.crf.FeatureFunction;
import com.hankcs.hanlp.model.crf.Table;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.utility.Predefine;
import com.hankcs.hanlp.utility.TextUtility;
import java.io.DataOutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CRFDependencyParser
extends AbstractDependencyParser {
    static CRFModel crfModel;
    static final CRFDependencyParser INSTANCE;

    public static CoNLLSentence compute(List<Term> termList) {
        return INSTANCE.parse(termList);
    }

    public static CoNLLSentence compute(String sentence) {
        return INSTANCE.parse(sentence);
    }

    static boolean load(String path) {
        if (CRFDependencyParser.loadDat(path + ".bin")) {
            return true;
        }
        crfModel = CRFModel.loadTxt(path, new CRFModelForDependency(new DoubleArrayTrie<FeatureFunction>()));
        return crfModel != null;
    }

    static boolean loadDat(String path) {
        ByteArray byteArray = ByteArray.createByteArray(path);
        if (byteArray == null) {
            return false;
        }
        crfModel = new CRFModelForDependency(new DoubleArrayTrie<FeatureFunction>());
        return crfModel.load(byteArray);
    }

    static boolean saveDat(String path) {
        try {
            DataOutputStream out = new DataOutputStream(IOUtil.newOutputStream(path));
            crfModel.save(out);
            out.close();
        }
        catch (Exception e) {
            Predefine.logger.warning("\u5728\u7f13\u5b58" + path + "\u65f6\u53d1\u751f\u9519\u8bef" + TextUtility.exceptionToString(e));
            return false;
        }
        return true;
    }

    @Override
    public CoNLLSentence parse(List<Term> termList) {
        int i;
        Table table = new Table();
        table.v = new String[termList.size()][4];
        Iterator<Term> iterator = termList.iterator();
        for (String[] line : table.v) {
            Term term = iterator.next();
            line[0] = term.word;
            line[2] = POSUtil.compilePOS(term.nature);
            line[1] = line[2].substring(0, 1);
        }
        crfModel.tag(table);
        if (HanLP.Config.DEBUG) {
            System.out.println(table);
        }
        CoNLLWord[] coNLLWordArray = new CoNLLWord[table.size()];
        for (i = 0; i < coNLLWordArray.length; ++i) {
            coNLLWordArray[i] = new CoNLLWord(i + 1, table.v[i][0], table.v[i][2], table.v[i][1]);
        }
        i = 0;
        for (String[] line : table.v) {
            int index;
            CRFModelForDependency.DTag dTag = new CRFModelForDependency.DTag(line[3]);
            coNLLWordArray[i].HEAD = dTag.pos.endsWith("ROOT") ? CoNLLWord.ROOT : ((index = CRFDependencyParser.convertOffset2Index(dTag, table, i)) == -1 ? CoNLLWord.NULL : coNLLWordArray[index]);
            ++i;
        }
        for (i = 0; i < coNLLWordArray.length; ++i) {
            coNLLWordArray[i].DEPREL = BigramDependencyModel.get(coNLLWordArray[i].NAME, coNLLWordArray[i].POSTAG, coNLLWordArray[i].HEAD.NAME, coNLLWordArray[i].HEAD.POSTAG);
        }
        return new CoNLLSentence(coNLLWordArray);
    }

    static int convertOffset2Index(CRFModelForDependency.DTag dTag, Table table, int current) {
        int posCount = 0;
        if (dTag.offset > 0) {
            for (int i = current + 1; i < table.size(); ++i) {
                if (table.v[i][1].equals(dTag.pos)) {
                    ++posCount;
                }
                if (posCount != dTag.offset) continue;
                return i;
            }
        } else {
            for (int i = current - 1; i >= 0; --i) {
                if (table.v[i][1].equals(dTag.pos)) {
                    ++posCount;
                }
                if (posCount != -dTag.offset) continue;
                return i;
            }
        }
        return -1;
    }

    static {
        long start = System.currentTimeMillis();
        if (CRFDependencyParser.load(HanLP.Config.CRFDependencyModelPath)) {
            Predefine.logger.info("\u52a0\u8f7d\u968f\u673a\u6761\u4ef6\u573a\u4f9d\u5b58\u53e5\u6cd5\u5206\u6790\u5668\u6a21\u578b" + HanLP.Config.CRFDependencyModelPath + "\u6210\u529f\uff0c\u8017\u65f6 " + (System.currentTimeMillis() - start) + " ms");
        } else {
            Predefine.logger.info("\u52a0\u8f7d\u968f\u673a\u6761\u4ef6\u573a\u4f9d\u5b58\u53e5\u6cd5\u5206\u6790\u5668\u6a21\u578b" + HanLP.Config.CRFDependencyModelPath + "\u5931\u8d25\uff0c\u8017\u65f6 " + (System.currentTimeMillis() - start) + " ms");
        }
        INSTANCE = new CRFDependencyParser();
    }

    static class CRFModelForDependency
    extends CRFModel {
        DTag[] id2dtag;

        public CRFModelForDependency(ITrie<FeatureFunction> featureFunctionTrie) {
            super(featureFunctionTrie);
        }

        @Override
        public boolean load(ByteArray byteArray) {
            if (!super.load(byteArray)) {
                return false;
            }
            this.initId2dtagArray();
            return true;
        }

        private void initId2dtagArray() {
            this.id2dtag = new DTag[this.id2tag.length];
            for (int i = 0; i < this.id2tag.length; ++i) {
                this.id2dtag[i] = new DTag(this.id2tag[i]);
            }
        }

        @Override
        protected void onLoadTxtFinished() {
            super.onLoadTxtFinished();
            this.initId2dtagArray();
        }

        boolean isLegal(int tagId, int current, Table table) {
            DTag tag = this.id2dtag[tagId];
            if ("ROOT".equals(tag.pos)) {
                for (int i = 0; i < current; ++i) {
                    if (!table.v[i][3].endsWith("ROOT")) continue;
                    return false;
                }
                return true;
            }
            int posCount = 0;
            if (tag.offset > 0) {
                for (int i = current + 1; i < table.size(); ++i) {
                    if (table.v[i][1].equals(tag.pos)) {
                        ++posCount;
                    }
                    if (posCount != tag.offset) continue;
                    return true;
                }
                return false;
            }
            for (int i = current - 1; i >= 0; --i) {
                if (table.v[i][1].equals(tag.pos)) {
                    ++posCount;
                }
                if (posCount != -tag.offset) continue;
                return true;
            }
            return false;
        }

        @Override
        public void tag(Table table) {
            int size = table.size();
            double bestScore = Double.MIN_VALUE;
            int bestTag = 0;
            int tagSize = this.id2tag.length;
            LinkedList<double[]> scoreList = this.computeScoreList(table, 0);
            for (int i = 0; i < tagSize; ++i) {
                for (int j = 0; j < tagSize; ++j) {
                    if (!this.isLegal(j, 0, table)) continue;
                    double curScore = CRFModelForDependency.computeScore(scoreList, j);
                    if (this.matrix != null) {
                        curScore += this.matrix[i][j];
                    }
                    if (!(curScore > bestScore)) continue;
                    bestScore = curScore;
                    bestTag = j;
                }
            }
            table.setLast(0, this.id2tag[bestTag]);
            int preTag = bestTag;
            for (int i = 1; i < size; ++i) {
                scoreList = this.computeScoreList(table, i);
                bestScore = Double.MIN_VALUE;
                for (int j = 0; j < tagSize; ++j) {
                    if (!this.isLegal(j, i, table)) continue;
                    double curScore = CRFModelForDependency.computeScore(scoreList, j);
                    if (this.matrix != null) {
                        curScore += this.matrix[preTag][j];
                    }
                    if (!(curScore > bestScore)) continue;
                    bestScore = curScore;
                    bestTag = j;
                }
                table.setLast(i, this.id2tag[bestTag]);
                preTag = bestTag;
            }
        }

        static class DTag {
            int offset;
            String pos;

            public DTag(String tag) {
                String[] args = tag.split("_", 2);
                if (args[0].charAt(0) == '+') {
                    args[0] = args[0].substring(1);
                }
                this.offset = Integer.parseInt(args[0]);
                this.pos = args[1];
            }

            public String toString() {
                return (this.offset > 0 ? "+" : "") + this.offset + "_" + this.pos;
            }
        }
    }
}

