/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.corpus.io;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.corpus.io.ByteArrayStream;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.utility.Predefine;
import com.hankcs.hanlp.utility.TextUtility;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ByteArrayOtherStream
extends ByteArrayStream {
    InputStream is;

    public ByteArrayOtherStream(byte[] bytes, int bufferSize) {
        super(bytes, bufferSize);
    }

    public ByteArrayOtherStream(byte[] bytes, int bufferSize, InputStream is) {
        super(bytes, bufferSize);
        this.is = is;
    }

    public static ByteArrayOtherStream createByteArrayOtherStream(String path) {
        try {
            InputStream is = HanLP.Config.IOAdapter == null ? new FileInputStream(path) : HanLP.Config.IOAdapter.open(path);
            return ByteArrayOtherStream.createByteArrayOtherStream(is);
        }
        catch (Exception e) {
            Predefine.logger.warning(TextUtility.exceptionToString(e));
            return null;
        }
    }

    public static ByteArrayOtherStream createByteArrayOtherStream(InputStream is) throws IOException {
        int size = is.available();
        int bufferSize = Math.min(0x100000, size);
        byte[] bytes = new byte[bufferSize];
        IOUtil.readBytesFromOtherInputStream(is, bytes);
        return new ByteArrayOtherStream(bytes, bufferSize, is);
    }

    @Override
    protected void ensureAvailableBytes(int size) {
        if (this.offset + size > this.bufferSize) {
            try {
                int availableBytes = this.is.available();
                int readBytes = Math.min(availableBytes, this.offset);
                byte[] bytes = new byte[readBytes];
                IOUtil.readBytesFromOtherInputStream(this.is, bytes);
                if (readBytes == availableBytes) {
                    this.is.close();
                    this.is = null;
                }
                assert (readBytes > 0) : "\u5df2\u5230\u8fbe\u6587\u4ef6\u5c3e\u90e8\uff01";
                System.arraycopy(this.bytes, this.offset, this.bytes, this.offset - readBytes, this.bufferSize - this.offset);
                System.arraycopy(bytes, 0, this.bytes, this.bufferSize - readBytes, readBytes);
                this.offset -= readBytes;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void close() {
        super.close();
        try {
            this.is.close();
        }
        catch (IOException e) {
            Predefine.logger.warning(TextUtility.exceptionToString(e));
        }
    }
}

