/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.corpus.dictionary;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.trie.bintrie.BinTrie;
import com.hankcs.hanlp.corpus.dictionary.ISaveAble;
import com.hankcs.hanlp.corpus.dictionary.item.Item;
import com.hankcs.hanlp.corpus.document.sentence.word.IWord;
import com.hankcs.hanlp.corpus.document.sentence.word.Word;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.utility.Predefine;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class DictionaryMaker
implements ISaveAble {
    BinTrie<Item> trie = new BinTrie();

    public void add(IWord word) {
        Item item = this.trie.get(word.getValue());
        if (item == null) {
            item = new Item(word.getValue(), word.getLabel());
            this.trie.put(item.key, item);
        } else {
            item.addLabel(word.getLabel());
        }
    }

    public void add(String value, String label) {
        this.add(new Word(value, label));
    }

    public Item get(String key) {
        return this.trie.get(key);
    }

    public Item get(IWord word) {
        return this.get(word.getValue());
    }

    public TreeSet<String> labelSet() {
        TreeSet<String> labelSet = new TreeSet<String>();
        for (Map.Entry<String, Item> entry : this.entrySet()) {
            labelSet.addAll(entry.getValue().labelMap.keySet());
        }
        return labelSet;
    }

    public static List<Item> loadAsItemList(String path) {
        LinkedList<Item> itemList = new LinkedList<Item>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(HanLP.Config.IOAdapter == null ? new FileInputStream(path) : HanLP.Config.IOAdapter.open(path), "UTF-8"));
            while ((line = br.readLine()) != null) {
                Item item = Item.create(line);
                if (item == null) {
                    Predefine.logger.warning("\u4f7f\u7528\u3010" + line + "\u3011\u521b\u5efaItem\u5931\u8d25");
                    return null;
                }
                itemList.add(item);
            }
        }
        catch (Exception e) {
            Predefine.logger.warning("\u8bfb\u53d6\u8bcd\u5178" + path + "\u53d1\u751f\u5f02\u5e38" + e);
            return null;
        }
        return itemList;
    }

    public static DictionaryMaker load(String path) {
        DictionaryMaker dictionaryMaker = new DictionaryMaker();
        dictionaryMaker.addAll(DictionaryMaker.loadAsItemList(path));
        return dictionaryMaker;
    }

    public void addAll(List<Item> itemList) {
        for (Item item : itemList) {
            this.add(item);
        }
    }

    public void addAllNotCombine(List<Item> itemList) {
        for (Item item : itemList) {
            this.addNotCombine(item);
        }
    }

    public void add(Item item) {
        Item innerItem = this.trie.get(item.key);
        if (innerItem == null) {
            innerItem = item;
            this.trie.put(innerItem.key, innerItem);
        } else {
            innerItem.combine(item);
        }
    }

    public Set<Map.Entry<String, Item>> entrySet() {
        return this.trie.entrySet();
    }

    public Set<String> keySet() {
        return this.trie.keySet();
    }

    public void addNotCombine(Item item) {
        Item innerItem = this.trie.get(item.key);
        if (innerItem == null) {
            innerItem = item;
            this.trie.put(innerItem.key, innerItem);
        }
    }

    public static DictionaryMaker combine(String pathA, String pathB) {
        DictionaryMaker dictionaryMaker = new DictionaryMaker();
        dictionaryMaker.addAll(DictionaryMaker.loadAsItemList(pathA));
        dictionaryMaker.addAll(DictionaryMaker.loadAsItemList(pathB));
        return dictionaryMaker;
    }

    public static DictionaryMaker combine(String ... pathArray) {
        DictionaryMaker dictionaryMaker = new DictionaryMaker();
        for (String path : pathArray) {
            Predefine.logger.warning("\u6b63\u5728\u5904\u7406" + path);
            dictionaryMaker.addAll(DictionaryMaker.loadAsItemList(path));
        }
        return dictionaryMaker;
    }

    public static DictionaryMaker combineWithNormalization(String[] pathArray) {
        DictionaryMaker dictionaryMaker = new DictionaryMaker();
        Predefine.logger.info("\u6b63\u5728\u5904\u7406\u4e3b\u8bcd\u5178" + pathArray[0]);
        dictionaryMaker.addAll(DictionaryMaker.loadAsItemList(pathArray[0]));
        for (int i = 1; i < pathArray.length; ++i) {
            Predefine.logger.info("\u6b63\u5728\u5904\u7406\u526f\u8bcd\u5178" + pathArray[i] + "\uff0c\u5c06\u6267\u884c\u65b0\u8bcd\u5408\u5e76\u6a21\u5f0f");
            dictionaryMaker.addAllNotCombine(DictionaryMaker.loadAsItemList(pathArray[i]));
        }
        return dictionaryMaker;
    }

    public static DictionaryMaker combineWhenNotInclude(String[] pathArray) {
        DictionaryMaker dictionaryMaker = new DictionaryMaker();
        Predefine.logger.info("\u6b63\u5728\u5904\u7406\u4e3b\u8bcd\u5178" + pathArray[0]);
        dictionaryMaker.addAll(DictionaryMaker.loadAsItemList(pathArray[0]));
        for (int i = 1; i < pathArray.length; ++i) {
            Predefine.logger.info("\u6b63\u5728\u5904\u7406\u526f\u8bcd\u5178" + pathArray[i] + "\uff0c\u5e76\u4e14\u8fc7\u6ee4\u5df2\u6709\u8bcd\u5178");
            dictionaryMaker.addAllNotCombine(DictionaryMaker.normalizeFrequency(DictionaryMaker.loadAsItemList(pathArray[i])));
        }
        return dictionaryMaker;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("\u8bcd\u6761\u6570\u91cf\uff1a");
        sb.append(this.trie.size());
        return sb.toString();
    }

    @Override
    public boolean saveTxtTo(String path) {
        if (this.trie.size() == 0) {
            return true;
        }
        try {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(IOUtil.newOutputStream(path), "UTF-8"));
            Set<Map.Entry<String, Item>> entries = this.trie.entrySet();
            for (Map.Entry<String, Item> entry : entries) {
                bw.write(entry.getValue().toString());
                bw.newLine();
            }
            bw.close();
        }
        catch (Exception e) {
            Predefine.logger.warning("\u4fdd\u5b58\u5230" + path + "\u5931\u8d25" + e);
            return false;
        }
        return true;
    }

    public void add(String param) {
        Item item = Item.create(param);
        if (item != null) {
            this.add(item);
        }
    }

    public boolean saveTxtTo(String path, Filter filter) {
        try {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(IOUtil.newOutputStream(path), "UTF-8"));
            Set<Map.Entry<String, Item>> entries = this.trie.entrySet();
            for (Map.Entry<String, Item> entry : entries) {
                if (!filter.onSave(entry.getValue())) continue;
                bw.write(entry.getValue().toString());
                bw.newLine();
            }
            bw.close();
        }
        catch (Exception e) {
            Predefine.logger.warning("\u4fdd\u5b58\u5230" + path + "\u5931\u8d25" + e);
            return false;
        }
        return true;
    }

    public static List<Item> normalizeFrequency(List<Item> itemList) {
        for (Item item : itemList) {
            ArrayList entryArray = new ArrayList(item.labelMap.entrySet());
            Collections.sort(entryArray, new Comparator<Map.Entry<String, Integer>>(){

                @Override
                public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                    return o1.getValue().compareTo(o2.getValue());
                }
            });
            int index = 1;
            for (Map.Entry pair : entryArray) {
                item.labelMap.put(pair.getKey(), index);
                ++index;
            }
        }
        return itemList;
    }

    public static interface Filter {
        public boolean onSave(Item var1);
    }
}

