/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.algoritm;

import com.hankcs.hanlp.dictionary.common.CommonSynonymDictionary;
import java.util.List;

public class EditDistance {
    public static long compute(List<CommonSynonymDictionary.SynonymItem> synonymItemListA, List<CommonSynonymDictionary.SynonymItem> synonymItemListB) {
        long[] arrayA = new long[synonymItemListA.size()];
        long[] arrayB = new long[synonymItemListB.size()];
        int i = 0;
        for (CommonSynonymDictionary.SynonymItem item : synonymItemListA) {
            arrayA[i++] = item.entry.id;
        }
        i = 0;
        for (CommonSynonymDictionary.SynonymItem item : synonymItemListB) {
            arrayB[i++] = item.entry.id;
        }
        return EditDistance.compute(arrayA, arrayB);
    }

    public static long compute(long[] arrayA, long[] arrayB) {
        int i;
        int m = arrayA.length;
        int n = arrayB.length;
        if (m == 0 || n == 0) {
            return 0x2AAAAAAAAAAAAAAAL;
        }
        long[][] d = new long[m + 1][n + 1];
        for (int j = 0; j <= n; ++j) {
            d[0][j] = j;
        }
        for (i = 0; i <= m; ++i) {
            d[i][0] = i;
        }
        for (i = 1; i <= m; ++i) {
            long ci = arrayA[i - 1];
            for (int j = 1; j <= n; ++j) {
                long cj = arrayB[j - 1];
                d[i][j] = ci == cj ? d[i - 1][j - 1] : Math.min(d[i - 1][j - 1] + Math.abs(ci - cj), Math.min(d[i][j - 1] + cj, d[i - 1][j] + ci));
            }
        }
        return d[m][n];
    }

    public static int compute(int[] arrayA, int[] arrayB) {
        int i;
        int m = arrayA.length;
        int n = arrayB.length;
        if (m == 0 || n == 0) {
            return 0x2AAAAAAA;
        }
        int[][] d = new int[m + 1][n + 1];
        for (int j = 0; j <= n; ++j) {
            d[0][j] = j;
        }
        for (i = 0; i <= m; ++i) {
            d[i][0] = i;
        }
        for (i = 1; i <= m; ++i) {
            int ci = arrayA[i - 1];
            for (int j = 1; j <= n; ++j) {
                int cj = arrayB[j - 1];
                d[i][j] = ci == cj ? d[i - 1][j - 1] : Math.min(d[i - 1][j - 1] + Math.abs(ci - cj), Math.min(d[i][j - 1] + cj, d[i - 1][j] + ci));
            }
        }
        return d[m][n];
    }

    public static int compute(String a, String b) {
        return EditDistance.ed(a, b);
    }

    public static int ed(String wrongWord, String rightWord) {
        int i;
        int m = wrongWord.length();
        int n = rightWord.length();
        int[][] d = new int[m + 1][n + 1];
        for (int j = 0; j <= n; ++j) {
            d[0][j] = j;
        }
        for (i = 0; i <= m; ++i) {
            d[i][0] = i;
        }
        for (i = 1; i <= m; ++i) {
            char ci = wrongWord.charAt(i - 1);
            for (int j = 1; j <= n; ++j) {
                char cj = rightWord.charAt(j - 1);
                d[i][j] = ci == cj ? d[i - 1][j - 1] : (i > 1 && j > 1 && ci == rightWord.charAt(j - 2) && cj == wrongWord.charAt(i - 2) ? 1 + Math.min(d[i - 2][j - 2], Math.min(d[i][j - 1], d[i - 1][j])) : Math.min(d[i - 1][j - 1] + 1, Math.min(d[i][j - 1] + 1, d[i - 1][j] + 1)));
            }
        }
        return d[m][n];
    }

    public static int compute(char[] wrongWord, char[] rightWord) {
        int i;
        int m = wrongWord.length;
        int n = rightWord.length;
        int[][] d = new int[m + 1][n + 1];
        for (int j = 0; j <= n; ++j) {
            d[0][j] = j;
        }
        for (i = 0; i <= m; ++i) {
            d[i][0] = i;
        }
        for (i = 1; i <= m; ++i) {
            char ci = wrongWord[i - 1];
            for (int j = 1; j <= n; ++j) {
                char cj = rightWord[j - 1];
                d[i][j] = ci == cj ? d[i - 1][j - 1] : (i > 1 && j > 1 && ci == rightWord[j - 2] && cj == wrongWord[i - 2] ? 1 + Math.min(d[i - 2][j - 2], Math.min(d[i][j - 1], d[i - 1][j])) : Math.min(d[i - 1][j - 1] + 1, Math.min(d[i][j - 1] + 1, d[i - 1][j] + 1)));
            }
        }
        return d[m][n];
    }
}

