/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.utility;

import com.hankcs.hanlp.dictionary.CoreDictionary;
import com.hankcs.hanlp.dictionary.CustomDictionary;
import com.hankcs.hanlp.seg.common.Term;

public class Lexicon {
    public static CoreDictionary.Attribute getAttribute(String word) {
        CoreDictionary.Attribute attribute = CoreDictionary.get(word);
        if (attribute != null) {
            return attribute;
        }
        return CustomDictionary.get(word);
    }

    public static CoreDictionary.Attribute getAttribute(Term term) {
        return Lexicon.getAttribute(term.word);
    }

    public static int getFrequency(String word) {
        CoreDictionary.Attribute attribute = Lexicon.getAttribute(word);
        if (attribute == null) {
            return 0;
        }
        return attribute.totalFrequency;
    }

    public static boolean setAttribute(String word, CoreDictionary.Attribute attribute) {
        if (attribute == null) {
            return false;
        }
        if (CoreDictionary.trie.set(word, attribute)) {
            return true;
        }
        if (CustomDictionary.dat.set(word, attribute)) {
            return true;
        }
        CustomDictionary.trie.put(word, attribute);
        return true;
    }

    public static boolean setAttribute(String word, String natureWithFrequency) {
        CoreDictionary.Attribute attribute = CoreDictionary.Attribute.create(natureWithFrequency);
        return Lexicon.setAttribute(word, attribute);
    }
}

