/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.utility;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collection;

public class TextUtility {
    public static final int CT_SINGLE = 5;
    public static final int CT_DELIMITER = 6;
    public static final int CT_CHINESE = 7;
    public static final int CT_LETTER = 8;
    public static final int CT_NUM = 9;
    public static final int CT_INDEX = 10;
    public static final int CT_OTHER = 17;

    public static int charType(char c) {
        return TextUtility.charType(String.valueOf(c));
    }

    public static int charType(String str) {
        if (str != null && str.length() > 0) {
            byte[] b;
            if ("\u96f6\u25cb\u3007\u4e00\u4e8c\u4e24\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341\u5eff\u767e\u5343\u4e07\u4ebf\u58f9\u8d30\u53c1\u8086\u4f0d\u9646\u67d2\u634c\u7396\u62fe\u4f70\u4edf".contains(str)) {
                return 9;
            }
            try {
                b = str.getBytes("GBK");
            }
            catch (UnsupportedEncodingException e) {
                b = str.getBytes();
                e.printStackTrace();
            }
            byte b1 = b[0];
            byte b2 = b.length > 1 ? b[1] : (byte)0;
            int ub1 = TextUtility.getUnsigned(b1);
            int ub2 = TextUtility.getUnsigned(b2);
            if (ub1 < 128) {
                if (" *\"!,.?()[]{}+=/\\;:|".indexOf((char)b1) != -1) {
                    return 6;
                }
                if ("0123456789".indexOf((char)b1) != -1) {
                    return 9;
                }
                return 5;
            }
            if (ub1 == 162) {
                return 10;
            }
            if (ub1 == 163 && ub2 > 175 && ub2 < 186) {
                return 9;
            }
            if (ub1 == 163 && (ub2 >= 193 && ub2 <= 218 || ub2 >= 225 && ub2 <= 250)) {
                return 8;
            }
            if (ub1 == 161 || ub1 == 163) {
                return 6;
            }
            if (ub1 >= 176 && ub1 <= 247) {
                return 7;
            }
        }
        return 17;
    }

    public static boolean isAllChinese(String str) {
        return str.matches("[\\u4E00-\\u9FA5]+");
    }

    public static boolean isAllNonChinese(byte[] sString) {
        int nLen = sString.length;
        int i = 0;
        while (i < nLen) {
            if (TextUtility.getUnsigned(sString[i]) < 248 && TextUtility.getUnsigned(sString[i]) > 175) {
                return false;
            }
            if (sString[i] < 0) {
                i += 2;
                continue;
            }
            ++i;
        }
        return true;
    }

    public static boolean isAllSingleByte(String str) {
        if (str != null) {
            byte[] b;
            int len = str.length();
            int i = 0;
            try {
                b = str.getBytes("GBK");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                b = str.getBytes();
            }
            while (i < len && b[i] < 128) {
                ++i;
            }
            return i >= len;
        }
        return false;
    }

    public static int cint(String str) {
        if (str != null) {
            try {
                int i = new Integer(str);
                return i;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static boolean isAllNum(String str) {
        if (str != null) {
            String s;
            int i = 0;
            String temp = str + " ";
            if ("\u00b1+\u2014-\uff0b".indexOf(temp.substring(0, 1)) != -1) {
                ++i;
            }
            while (i < str.length() && "\uff10\uff11\uff12\uff13\uff14\uff15\uff16\uff17\uff18\uff19".indexOf(str.substring(i, i + 1)) != -1) {
                ++i;
            }
            if (i < str.length() && ("\u2236\u00b7\uff0e\uff0f".indexOf(s = str.substring(i, i + 1)) != -1 || ".".equals(s) || "/".equals(s))) {
                ++i;
                while (i + 1 < str.length() && "\uff10\uff11\uff12\uff13\uff14\uff15\uff16\uff17\uff18\uff19".indexOf(str.substring(i + 1, i + 2)) != -1) {
                    ++i;
                }
            }
            if (i >= str.length()) {
                return true;
            }
            while (i < str.length() && TextUtility.cint(str.substring(i, i + 1)) >= 0 && TextUtility.cint(str.substring(i, i + 1)) <= 9) {
                ++i;
            }
            if (i < str.length() && ("\u2236\u00b7\uff0e\uff0f".indexOf(s = str.substring(i, i + 1)) != -1 || ".".equals(s) || "/".equals(s))) {
                ++i;
                while (i + 1 < str.length() && "0123456789".indexOf(str.substring(i + 1, i + 2)) != -1) {
                    ++i;
                }
            }
            if (i < str.length() && "\u767e\u5343\u4e07\u4ebf\u4f70\u4edf\uff05\u2030".indexOf(str.substring(i, i + 1)) == -1 && !"%".equals(str.substring(i, i + 1))) {
                --i;
            }
            if (i >= str.length()) {
                return true;
            }
        }
        return false;
    }

    public static boolean isAllIndex(byte[] sString) {
        int i;
        int nLen = sString.length;
        for (i = 0; i < nLen - 1 && TextUtility.getUnsigned(sString[i]) == 162; i += 2) {
        }
        if (i >= nLen) {
            return true;
        }
        while (i < nLen && sString[i] > 64 && sString[i] < 91 || sString[i] > 96 && sString[i] < 123) {
            ++i;
        }
        return i >= nLen;
    }

    public static boolean isAllLetter(String text) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') continue;
            return false;
        }
        return true;
    }

    public static boolean isAllLetterOrNum(String text) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static boolean isAllDelimiter(byte[] sString) {
        int i;
        int nLen = sString.length;
        for (i = 0; i < nLen - 1 && (TextUtility.getUnsigned(sString[i]) == 161 || TextUtility.getUnsigned(sString[i]) == 163); i += 2) {
        }
        return i >= nLen;
    }

    public static boolean isAllChineseNum(String word) {
        String chineseNum = "\u96f6\u25cb\u4e00\u4e8c\u4e24\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341\u5eff\u767e\u5343\u4e07\u4ebf\u58f9\u8d30\u53c1\u8086\u4f0d\u9646\u67d2\u634c\u7396\u62fe\u4f70\u4edf\u2236\u00b7\uff0e\uff0f\u70b9";
        String prefix = "\u51e0\u6570\u7b2c\u4e0a\u6210";
        if (word != null) {
            String temp = word + " ";
            for (int i = 0; i < word.length(); ++i) {
                if (temp.indexOf("\u5206\u4e4b", i) != -1) {
                    i += 2;
                    continue;
                }
                String tchar = temp.substring(i, i + 1);
                if (chineseNum.indexOf(tchar) != -1 || i == 0 && prefix.indexOf(tchar) != -1) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static int getCharCount(String charSet, String word) {
        int nCount = 0;
        if (word != null) {
            String temp = word + " ";
            for (int i = 0; i < word.length(); ++i) {
                String s = temp.substring(i, i + 1);
                if (charSet.indexOf(s) == -1) continue;
                ++nCount;
            }
        }
        return nCount;
    }

    public static int getUnsigned(byte b) {
        if (b > 0) {
            return b;
        }
        return b & 0xFF;
    }

    public static boolean isYearTime(String snum) {
        if (snum != null) {
            int len = snum.length();
            String first = snum.substring(0, 1);
            if (TextUtility.isAllSingleByte(snum) && (len == 4 || len == 2 && (TextUtility.cint(first) > 4 || TextUtility.cint(first) == 0))) {
                return true;
            }
            if (TextUtility.isAllNum(snum) && (len >= 6 || len == 4 && "\uff10\uff15\uff16\uff17\uff18\uff19".indexOf(first) != -1)) {
                return true;
            }
            if (TextUtility.getCharCount("\u96f6\u25cb\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u58f9\u8d30\u53c1\u8086\u4f0d\u9646\u67d2\u634c\u7396", snum) == len && len >= 2) {
                return true;
            }
            if (len == 4 && TextUtility.getCharCount("\u5343\u4edf\u96f6\u25cb", snum) == 2) {
                return true;
            }
            if (len == 1 && TextUtility.getCharCount("\u5343\u4edf", snum) == 1) {
                return true;
            }
            if (len == 2 && TextUtility.getCharCount("\u7532\u4e59\u4e19\u4e01\u620a\u5df1\u5e9a\u8f9b\u58ec\u7678", snum) == 1 && TextUtility.getCharCount("\u5b50\u4e11\u5bc5\u536f\u8fb0\u5df3\u5348\u672a\u7533\u9149\u620c\u4ea5", snum.substring(1)) == 1) {
                return true;
            }
        }
        return false;
    }

    public static boolean isInAggregate(String aggr, String str) {
        if (aggr != null && str != null) {
            str = str + "1";
            for (int i = 0; i < str.length(); ++i) {
                String s = str.substring(i, i + 1);
                if (aggr.indexOf(s) != -1) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isDBCCase(String str) {
        if (str != null) {
            str = str + " ";
            for (int i = 0; i < str.length(); ++i) {
                String s = str.substring(i, i + 1);
                int length = 0;
                try {
                    length = s.getBytes("GBK").length;
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                    length = s.getBytes().length;
                }
                if (length == 1) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isSBCCase(String str) {
        if (str != null) {
            str = str + " ";
            for (int i = 0; i < str.length(); ++i) {
                String s = str.substring(i, i + 1);
                int length = 0;
                try {
                    length = s.getBytes("GBK").length;
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                    length = s.getBytes().length;
                }
                if (length == 2) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isDelimiter(String str) {
        return str != null && ("-".equals(str) || "\uff0d".equals(str));
    }

    public static boolean isUnknownWord(String word) {
        return word != null && word.indexOf("\u672a##") == 0;
    }

    public static double nonZero(double frequency) {
        if (frequency == 0.0) {
            return 0.001;
        }
        return frequency;
    }

    public static char[] long2char(long x) {
        char[] c = new char[]{(char)(x >> 48), (char)(x >> 32), (char)(x >> 16), (char)x};
        return c;
    }

    public static String long2String(long x) {
        char[] cArray = TextUtility.long2char(x);
        StringBuilder sbResult = new StringBuilder(cArray.length);
        for (char c : cArray) {
            sbResult.append(c);
        }
        return sbResult.toString();
    }

    public static String exceptionToString(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    public static boolean isChinese(char c) {
        String regex = "[\\u4e00-\\u9fa5]";
        return String.valueOf(c).matches(regex);
    }

    public static int count(String keyword, String srcText) {
        int count = 0;
        int leng = srcText.length();
        int j = 0;
        for (int i = 0; i < leng; ++i) {
            if (srcText.charAt(i) == keyword.charAt(j)) {
                if (++j != keyword.length()) continue;
                ++count;
                j = 0;
                continue;
            }
            i -= j;
            j = 0;
        }
        return count;
    }

    public static void writeString(String s, DataOutputStream out) throws IOException {
        out.writeInt(s.length());
        for (char c : s.toCharArray()) {
            out.writeChar(c);
        }
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String join(String delimiter, Collection<String> stringCollection) {
        StringBuilder sb = new StringBuilder(stringCollection.size() * (16 + delimiter.length()));
        for (String str : stringCollection) {
            sb.append(str).append(delimiter);
        }
        return sb.toString();
    }
}

