/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.corpus.dictionary;

import com.hankcs.hanlp.corpus.dictionary.CommonDictionaryMaker;
import com.hankcs.hanlp.corpus.dictionary.EasyDictionary;
import com.hankcs.hanlp.corpus.dictionary.PlaceSuffixDictionary;
import com.hankcs.hanlp.corpus.document.CorpusLoader;
import com.hankcs.hanlp.corpus.document.Document;
import com.hankcs.hanlp.corpus.document.sentence.word.IWord;
import com.hankcs.hanlp.corpus.document.sentence.word.Word;
import com.hankcs.hanlp.corpus.tag.NS;
import com.hankcs.hanlp.corpus.util.CorpusUtil;
import com.hankcs.hanlp.corpus.util.Precompiler;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class NSDictionaryMaker
extends CommonDictionaryMaker {
    public NSDictionaryMaker(EasyDictionary dictionary) {
        super(dictionary);
    }

    @Override
    protected void addToDictionary(List<List<IWord>> sentenceList) {
        for (List<IWord> wordList : sentenceList) {
            for (IWord word : wordList) {
                if (word.getLabel().equals(NS.Z.toString())) continue;
                this.dictionaryMaker.add(word);
            }
        }
        for (List<IWord> wordList : sentenceList) {
            IWord pre = null;
            for (IWord word : wordList) {
                if (pre != null) {
                    this.nGramDictionaryMaker.addPair(pre, word);
                }
                pre = word;
            }
        }
    }

    @Override
    protected void roleTag(List<List<IWord>> sentenceList) {
        int i = 0;
        for (List<IWord> wordList : sentenceList) {
            IWord current;
            Precompiler.compileWithoutNS(wordList);
            if (verbose) {
                System.out.print(++i + " / " + sentenceList.size() + " ");
                System.out.println("\u539f\u59cb\u8bed\u6599 " + wordList);
            }
            LinkedList wordLinkedList = (LinkedList)wordList;
            wordLinkedList.addFirst(new Word("\u59cb##\u59cb", "S"));
            wordLinkedList.addLast(new Word("\u672b##\u672b", "Z"));
            if (verbose) {
                System.out.println("\u6dfb\u52a0\u9996\u5c3e " + wordList);
            }
            Iterator iterator = wordLinkedList.iterator();
            IWord pre = (IWord)iterator.next();
            while (iterator.hasNext()) {
                current = (IWord)iterator.next();
                if (current.getLabel().startsWith("ns") && !pre.getLabel().startsWith("ns")) {
                    pre.setLabel(NS.A.toString());
                }
                pre = current;
            }
            if (verbose) {
                System.out.println("\u6807\u6ce8\u4e0a\u6587 " + wordList);
            }
            iterator = wordLinkedList.descendingIterator();
            pre = (IWord)iterator.next();
            while (iterator.hasNext()) {
                current = (IWord)iterator.next();
                if (current.getLabel().startsWith("ns") && !pre.getLabel().startsWith("ns")) {
                    pre.setLabel(NS.B.toString());
                }
                pre = current;
            }
            if (verbose) {
                System.out.println("\u6807\u6ce8\u4e0b\u6587 " + wordList);
            }
            iterator = wordLinkedList.iterator();
            IWord first = (IWord)iterator.next();
            IWord second = (IWord)iterator.next();
            while (iterator.hasNext()) {
                IWord third = (IWord)iterator.next();
                if (first.getLabel().startsWith("ns") && third.getLabel().startsWith("ns") && !second.getLabel().startsWith("ns")) {
                    second.setLabel(NS.X.toString());
                }
                first = second;
                second = third;
            }
            if (verbose) {
                System.out.println("\u6807\u6ce8\u4e2d\u95f4 " + wordList);
            }
            CorpusUtil.spilt(wordList);
            if (verbose) {
                System.out.println("\u62c6\u5206\u5730\u540d " + wordList);
            }
            ListIterator<Word> listIterator = wordLinkedList.listIterator();
            while (listIterator.hasNext()) {
                IWord word = (IWord)listIterator.next();
                String label = word.getLabel();
                if (label.equals(label.toUpperCase())) continue;
                if (label.startsWith("ns")) {
                    String value = word.getValue();
                    int longestSuffixLength = PlaceSuffixDictionary.dictionary.getLongestSuffixLength(value);
                    int wordLength = value.length() - longestSuffixLength;
                    if (longestSuffixLength == 0 || wordLength == 0) {
                        word.setLabel(NS.G.toString());
                        continue;
                    }
                    listIterator.remove();
                    if (wordLength > 3) {
                        listIterator.add(new Word(value.substring(0, wordLength), NS.G.toString()));
                        listIterator.add(new Word(value.substring(wordLength), NS.H.toString()));
                        continue;
                    }
                    int l = 1;
                    int tag = NS.C.ordinal();
                    while (l <= wordLength) {
                        listIterator.add(new Word(value.substring(l - 1, l), NS.values()[tag].toString()));
                        ++l;
                        ++tag;
                    }
                    listIterator.add(new Word(value.substring(wordLength), NS.H.toString()));
                    continue;
                }
                word.setLabel(NS.Z.toString());
            }
            if (!verbose) continue;
            System.out.println("\u5904\u7406\u6574\u4e2a " + wordList);
        }
    }

    public static void main(String[] args) {
        EasyDictionary dictionary = EasyDictionary.create("data/dictionary/2014_dictionary.txt");
        final NSDictionaryMaker nsDictionaryMaker = new NSDictionaryMaker(dictionary);
        CorpusLoader.walk("D:\\JavaProjects\\CorpusToolBox\\data\\2014\\", new CorpusLoader.Handler(){

            @Override
            public void handle(Document document) {
                nsDictionaryMaker.compute(document.getComplexSentenceList());
            }
        });
        nsDictionaryMaker.saveTxtTo("D:\\JavaProjects\\HanLP\\data\\dictionary\\place\\ns");
    }
}

