/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp;

import com.hankcs.hanlp.corpus.dependency.CoNll.CoNLLSentence;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.dependency.nnparser.NeuralNetworkDependencyParser;
import com.hankcs.hanlp.dictionary.py.Pinyin;
import com.hankcs.hanlp.dictionary.py.PinyinDictionary;
import com.hankcs.hanlp.dictionary.ts.SimplifiedChineseDictionary;
import com.hankcs.hanlp.dictionary.ts.TraditionalChineseDictionary;
import com.hankcs.hanlp.phrase.MutualInformationEntropyPhraseExtractor;
import com.hankcs.hanlp.seg.Segment;
import com.hankcs.hanlp.seg.Viterbi.ViterbiSegment;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.summary.TextRankKeyword;
import com.hankcs.hanlp.summary.TextRankSentence;
import com.hankcs.hanlp.tokenizer.StandardTokenizer;
import com.hankcs.hanlp.utility.Predefine;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;

public class HanLP {
    private HanLP() {
    }

    public static String convertToSimplifiedChinese(String traditionalChineseString) {
        return TraditionalChineseDictionary.convertToSimplifiedChinese(traditionalChineseString.toCharArray());
    }

    public static String convertToTraditionalChinese(String simplifiedChineseString) {
        return SimplifiedChineseDictionary.convertToTraditionalChinese(simplifiedChineseString.toCharArray());
    }

    public static String convertToPinyinString(String text, String separator, boolean remainNone) {
        List<Pinyin> pinyinList = PinyinDictionary.convertToPinyin(text, remainNone);
        int length = pinyinList.size();
        StringBuilder sb = new StringBuilder(length * (5 + separator.length()));
        int i = 1;
        for (Pinyin pinyin : pinyinList) {
            sb.append(pinyin.getPinyinWithoutTone());
            if (i < length) {
                sb.append(separator);
            }
            ++i;
        }
        return sb.toString();
    }

    public static List<Pinyin> convertToPinyinList(String text) {
        return PinyinDictionary.convertToPinyin(text);
    }

    public static String convertToPinyinFirstCharString(String text, String separator, boolean remainNone) {
        List<Pinyin> pinyinList = PinyinDictionary.convertToPinyin(text, remainNone);
        int length = pinyinList.size();
        StringBuilder sb = new StringBuilder(length * (1 + separator.length()));
        int i = 1;
        for (Pinyin pinyin : pinyinList) {
            sb.append(pinyin.getFirstChar());
            if (i < length) {
                sb.append(separator);
            }
            ++i;
        }
        return sb.toString();
    }

    public static List<Term> segment(String text) {
        return StandardTokenizer.segment(text.toCharArray());
    }

    public static Segment newSegment() {
        return new ViterbiSegment();
    }

    public static CoNLLSentence parseDependency(String sentence) {
        return NeuralNetworkDependencyParser.compute(sentence);
    }

    public static List<String> extractPhrase(String text, int size) {
        MutualInformationEntropyPhraseExtractor extractor = new MutualInformationEntropyPhraseExtractor();
        return extractor.extractPhrase(text, size);
    }

    public static List<String> extractKeyword(String document, int size) {
        return TextRankKeyword.getKeywordList(document, size);
    }

    public static List<String> extractSummary(String document, int size) {
        return TextRankSentence.getTopSentenceList(document, size);
    }

    public static String getSummary(String document, int max_length) {
        return TextRankSentence.getSummary(document, max_length);
    }

    public static final class Config {
        public static boolean DEBUG = false;
        public static String CoreDictionaryPath = "data/dictionary/CoreNatureDictionary.mini.txt";
        public static String CoreDictionaryTransformMatrixDictionaryPath = "data/dictionary/CoreNatureDictionary.tr.txt";
        public static String[] CustomDictionaryPath = new String[]{"data/dictionary/custom/CustomDictionary.txt"};
        public static String BiGramDictionaryPath = "data/dictionary/CoreNatureDictionary.ngram.mini.txt";
        public static String CoreStopWordDictionaryPath = "data/dictionary/stopwords.txt";
        public static String CoreSynonymDictionaryDictionaryPath = "data/dictionary/synonym/CoreSynonym.txt";
        public static String PersonDictionaryPath = "data/dictionary/person/nr.txt";
        public static String PersonDictionaryTrPath = "data/dictionary/person/nr.tr.txt";
        public static String PlaceDictionaryPath = "data/dictionary/place/ns.txt";
        public static String PlaceDictionaryTrPath = "data/dictionary/place/ns.tr.txt";
        public static String OrganizationDictionaryPath = "data/dictionary/organization/nt.txt";
        public static String OrganizationDictionaryTrPath = "data/dictionary/organization/nt.tr.txt";
        public static String TraditionalChineseDictionaryPath = "data/dictionary/tc/TraditionalChinese.txt";
        public static String SYTDictionaryPath = "data/dictionary/pinyin/SYTDictionary.txt";
        public static String PinyinDictionaryPath = "data/dictionary/pinyin/pinyin.txt";
        public static String TranslatedPersonDictionaryPath = "data/dictionary/person/nrf.txt";
        public static String JapanesePersonDictionaryPath = "data/dictionary/person/nrj.txt";
        public static String CharTypePath = "data/dictionary/other/CharType.dat.yes";
        public static String CharTablePath = "data/dictionary/other/CharTable.bin.yes";
        public static String WordNatureModelPath = "data/model/dependency/WordNature.txt";
        public static String MaxEntModelPath = "data/model/dependency/MaxEntModel.txt";
        public static String NNParserModelPath = "data/model/dependency/NNParserModel.txt";
        public static String CRFSegmentModelPath = "data/model/segment/CRFSegmentModel.txt";
        public static String HMMSegmentModelPath = "data/model/segment/HMMSegmentModel.bin";
        public static String CRFDependencyModelPath = "data/model/dependency/CRFDependencyModelMini.txt";
        public static boolean ShowTermNature = true;
        public static boolean Normalization = false;

        public static void enableDebug() {
            Config.enableDebug(true);
        }

        public static void enableDebug(boolean enable) {
            DEBUG = enable;
            if (DEBUG) {
                Predefine.logger.setLevel(Level.ALL);
            } else {
                Predefine.logger.setLevel(Level.OFF);
            }
        }

        static {
            Properties p = new Properties(){
                String root;

                @Override
                public String getProperty(String key, String defaultValue) {
                    if (this.root == null) {
                        this.root = this.getProperty("root");
                    }
                    if ("root".equals(key)) {
                        return this.root;
                    }
                    String property = this.getProperty(key);
                    if (property == null) {
                        property = defaultValue;
                    }
                    if (property.startsWith("data") && !"CustomDictionaryPath".equals(key)) {
                        String path = this.root + property;
                        if (IOUtil.isFileExists(path) || IOUtil.isFileExists(path + ".bin")) {
                            return path;
                        }
                        return defaultValue;
                    }
                    return property;
                }
            };
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                if (loader == null) {
                    loader = Config.class.getClassLoader();
                }
                p.load(new InputStreamReader(Predefine.HANLP_PROPERTIES_PATH == null ? loader.getResourceAsStream("hanlp.properties") : new FileInputStream(Predefine.HANLP_PROPERTIES_PATH), "UTF-8"));
                String root = p.getProperty("root", "").replaceAll("\\\\", "/");
                if (!root.endsWith("/")) {
                    root = root + "/";
                }
                if (!IOUtil.isFileExists(root + "data")) {
                    throw new IllegalArgumentException("root=" + root + " \u8fd9\u4e2a\u76ee\u5f55\u4e0b\u6ca1\u6709data");
                }
                CoreDictionaryPath = p.getProperty("CoreDictionaryPath", CoreDictionaryPath);
                CoreDictionaryTransformMatrixDictionaryPath = p.getProperty("CoreDictionaryTransformMatrixDictionaryPath", CoreDictionaryTransformMatrixDictionaryPath);
                BiGramDictionaryPath = p.getProperty("BiGramDictionaryPath", BiGramDictionaryPath);
                CoreStopWordDictionaryPath = p.getProperty("CoreStopWordDictionaryPath", CoreStopWordDictionaryPath);
                CoreSynonymDictionaryDictionaryPath = p.getProperty("CoreSynonymDictionaryDictionaryPath", CoreSynonymDictionaryDictionaryPath);
                PersonDictionaryPath = p.getProperty("PersonDictionaryPath", PersonDictionaryPath);
                PersonDictionaryTrPath = p.getProperty("PersonDictionaryTrPath", PersonDictionaryTrPath);
                String[] pathArray = p.getProperty("CustomDictionaryPath", "dictionary/custom/CustomDictionary.txt").split(";");
                String prePath = root;
                for (int i = 0; i < pathArray.length; ++i) {
                    if (pathArray[i].startsWith(" ")) {
                        pathArray[i] = prePath + pathArray[i].trim();
                        continue;
                    }
                    pathArray[i] = root + pathArray[i];
                    int lastSplash = pathArray[i].lastIndexOf(47);
                    if (lastSplash == -1) continue;
                    prePath = pathArray[i].substring(0, lastSplash + 1);
                }
                CustomDictionaryPath = pathArray;
                TraditionalChineseDictionaryPath = p.getProperty("TraditionalChineseDictionaryPath", TraditionalChineseDictionaryPath);
                SYTDictionaryPath = p.getProperty("SYTDictionaryPath", SYTDictionaryPath);
                PinyinDictionaryPath = p.getProperty("PinyinDictionaryPath", PinyinDictionaryPath);
                TranslatedPersonDictionaryPath = p.getProperty("TranslatedPersonDictionaryPath", TranslatedPersonDictionaryPath);
                JapanesePersonDictionaryPath = p.getProperty("JapanesePersonDictionaryPath", JapanesePersonDictionaryPath);
                PlaceDictionaryPath = p.getProperty("PlaceDictionaryPath", PlaceDictionaryPath);
                PlaceDictionaryTrPath = p.getProperty("PlaceDictionaryTrPath", PlaceDictionaryTrPath);
                OrganizationDictionaryPath = p.getProperty("OrganizationDictionaryPath", OrganizationDictionaryPath);
                OrganizationDictionaryTrPath = p.getProperty("OrganizationDictionaryTrPath", OrganizationDictionaryTrPath);
                CharTypePath = p.getProperty("CharTypePath", CharTypePath);
                CharTablePath = p.getProperty("CharTablePath", CharTablePath);
                WordNatureModelPath = p.getProperty("WordNatureModelPath", WordNatureModelPath);
                MaxEntModelPath = p.getProperty("MaxEntModelPath", MaxEntModelPath);
                NNParserModelPath = p.getProperty("NNParserModelPath", NNParserModelPath);
                CRFSegmentModelPath = p.getProperty("CRFSegmentModelPath", CRFSegmentModelPath);
                CRFDependencyModelPath = p.getProperty("CRFDependencyModelPath", CRFDependencyModelPath);
                HMMSegmentModelPath = p.getProperty("HMMSegmentModelPath", HMMSegmentModelPath);
                ShowTermNature = "true".equals(p.getProperty("ShowTermNature", "true"));
                Normalization = "true".equals(p.getProperty("Normalization", "false"));
            }
            catch (Exception e) {
                StringBuilder sbInfo = new StringBuilder("========Tips========\n\u8bf7\u5c06HanLP.properties\u653e\u5728\u4e0b\u5217\u76ee\u5f55\uff1a\n");
                String classPath = (String)System.getProperties().get("java.class.path");
                if (classPath != null) {
                    for (String path : classPath.split(";")) {
                        if (!new File(path).isDirectory()) continue;
                        sbInfo.append(path).append('\n');
                    }
                }
                sbInfo.append("Web\u9879\u76ee\u5219\u8bf7\u653e\u5230\u4e0b\u5217\u76ee\u5f55\uff1a\nWebapp/WEB-INF/lib\nWebapp/WEB-INF/classes\nAppserver/lib\nJRE/lib\n");
                sbInfo.append("\u5e76\u4e14\u7f16\u8f91root=PARENT/path/to/your/data\n");
                sbInfo.append("\u73b0\u5728HanLP\u5c06\u5c1d\u8bd5\u4ece").append(System.getProperties().get("user.dir")).append("\u8bfb\u53d6data\u2026\u2026");
                Predefine.logger.info("hanlp.properties\uff0c\u8fdb\u5165portable\u6a21\u5f0f\u3002\u82e5\u9700\u8981\u81ea\u5b9a\u4e49HanLP\uff0c\u8bf7\u6309\u4e0b\u5217\u63d0\u793a\u64cd\u4f5c\uff1a\n" + sbInfo);
            }
        }
    }
}

