/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.seg.CRF;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.algoritm.Viterbi;
import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.dictionary.CoreDictionary;
import com.hankcs.hanlp.dictionary.CoreDictionaryTransformMatrixDictionary;
import com.hankcs.hanlp.model.CRFSegmentModel;
import com.hankcs.hanlp.model.crf.Table;
import com.hankcs.hanlp.seg.CharacterBasedGenerativeModelSegment;
import com.hankcs.hanlp.seg.Segment;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.seg.common.Vertex;
import com.hankcs.hanlp.utility.CharacterHelper;
import com.hankcs.hanlp.utility.Predefine;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CRFSegment
extends CharacterBasedGenerativeModelSegment {
    @Override
    protected List<Term> segSentence(char[] sentence) {
        if (sentence.length == 0) {
            return Collections.emptyList();
        }
        char[] sentenceConverted = CharTable.convert(sentence);
        Table table = new Table();
        table.v = CRFSegment.atomSegmentToTable(sentenceConverted);
        CRFSegmentModel.crfModel.tag(table);
        List<Term> termList = new LinkedList<Term>();
        if (HanLP.Config.DEBUG) {
            System.out.println("CRF\u6807\u6ce8\u7ed3\u679c");
            System.out.println(table);
        }
        int offset = 0;
        block3: for (int i = 0; i < table.v.length; ++i) {
            String[] line = table.v[i];
            switch (line[2].charAt(0)) {
                case 'B': {
                    int begin = offset;
                    while (table.v[i][2].charAt(0) != 'E') {
                        offset += table.v[i][1].length();
                        if (++i != table.v.length) continue;
                    }
                    if (i == table.v.length) {
                        termList.add(new Term(new String(sentence, begin, offset - begin), null));
                        break block3;
                    }
                    termList.add(new Term(new String(sentence, begin, offset - begin + table.v[i][1].length()), null));
                    break;
                }
                default: {
                    termList.add(new Term(new String(sentence, offset, table.v[i][1].length()), null));
                }
            }
            offset += table.v[i][1].length();
        }
        if (this.config.speechTagging) {
            List<Vertex> vertexList = CRFSegment.toVertexList(termList, true);
            Viterbi.compute(vertexList, CoreDictionaryTransformMatrixDictionary.transformMatrixDictionary);
            int i = 0;
            for (Term term : termList) {
                if (term.nature != null) {
                    term.nature = vertexList.get(i + 1).getNature();
                }
                ++i;
            }
        }
        if (this.config.useCustomDictionary) {
            List<Vertex> vertexList = CRFSegment.toVertexList(termList, false);
            CRFSegment.combineByCustomDictionary(vertexList);
            termList = CRFSegment.toTermList(vertexList, this.config.offset);
        }
        return termList;
    }

    private static List<Vertex> toVertexList(List<Term> termList, boolean appendStart) {
        ArrayList<Vertex> vertexList = new ArrayList<Vertex>(termList.size() + 1);
        if (appendStart) {
            vertexList.add(Vertex.B);
        }
        for (Term term : termList) {
            CoreDictionary.Attribute attribute = CoreDictionary.get(term.word);
            if (attribute == null) {
                attribute = term.word.trim().length() == 0 ? new CoreDictionary.Attribute(Nature.x) : new CoreDictionary.Attribute(Nature.nz);
            } else {
                term.nature = attribute.nature[0];
            }
            Vertex vertex = new Vertex(term.word, attribute);
            vertexList.add(vertex);
        }
        return vertexList;
    }

    protected static List<Term> toTermList(List<Vertex> vertexList, boolean offsetEnabled) {
        assert (vertexList != null);
        int length = vertexList.size();
        ArrayList<Term> resultList = new ArrayList<Term>(length);
        Iterator<Vertex> iterator = vertexList.iterator();
        if (offsetEnabled) {
            int offset = 0;
            for (int i = 0; i < length; ++i) {
                Vertex vertex = iterator.next();
                Term term = CRFSegment.convert(vertex);
                term.offset = offset;
                offset += term.length();
                resultList.add(term);
            }
        } else {
            for (int i = 0; i < length; ++i) {
                Vertex vertex = iterator.next();
                Term term = CRFSegment.convert(vertex);
                resultList.add(term);
            }
        }
        return resultList;
    }

    private static Term convert(Vertex vertex) {
        return new Term(vertex.realWord, vertex.guessNature());
    }

    public static List<String> atomSegment(char[] sentence) {
        ArrayList<String> atomList = new ArrayList<String>(sentence.length);
        int maxLen = sentence.length - 1;
        StringBuilder sbAtom = new StringBuilder();
        block0: for (int i = 0; i < sentence.length; ++i) {
            char c;
            if (sentence[i] >= '0' && sentence[i] <= '9') {
                sbAtom.append(sentence[i]);
                if (i == maxLen) {
                    atomList.add(sbAtom.toString());
                    sbAtom.setLength(0);
                    break;
                }
                c = sentence[++i];
                while (c == '.' || c == '%' || c >= '0' && c <= '9') {
                    sbAtom.append(sentence[i]);
                    if (i == maxLen) {
                        atomList.add(sbAtom.toString());
                        sbAtom.setLength(0);
                        break block0;
                    }
                    c = sentence[++i];
                }
                atomList.add(sbAtom.toString());
                sbAtom.setLength(0);
                --i;
                continue;
            }
            if (CharacterHelper.isEnglishLetter(sentence[i])) {
                sbAtom.append(sentence[i]);
                if (i == maxLen) {
                    atomList.add(sbAtom.toString());
                    sbAtom.setLength(0);
                    break;
                }
                c = sentence[++i];
                while (CharacterHelper.isEnglishLetter(c)) {
                    sbAtom.append(sentence[i]);
                    if (i == maxLen) {
                        atomList.add(sbAtom.toString());
                        sbAtom.setLength(0);
                        break block0;
                    }
                    c = sentence[++i];
                }
                atomList.add(sbAtom.toString());
                sbAtom.setLength(0);
                --i;
                continue;
            }
            atomList.add(String.valueOf(sentence[i]));
        }
        return atomList;
    }

    public static String[][] atomSegmentToTable(char[] sentence) {
        String[][] table = new String[sentence.length][3];
        int size = 0;
        int maxLen = sentence.length - 1;
        StringBuilder sbAtom = new StringBuilder();
        block0: for (int i = 0; i < sentence.length; ++i) {
            char c;
            if (sentence[i] >= '0' && sentence[i] <= '9') {
                sbAtom.append(sentence[i]);
                if (i == maxLen) {
                    table[size][0] = "M";
                    table[size][1] = sbAtom.toString();
                    ++size;
                    sbAtom.setLength(0);
                    break;
                }
                c = sentence[++i];
                while (c == '.' || c == '%' || c >= '0' && c <= '9') {
                    sbAtom.append(sentence[i]);
                    if (i == maxLen) {
                        table[size][0] = "M";
                        table[size][1] = sbAtom.toString();
                        ++size;
                        sbAtom.setLength(0);
                        break block0;
                    }
                    c = sentence[++i];
                }
                table[size][0] = "M";
                table[size][1] = sbAtom.toString();
                ++size;
                sbAtom.setLength(0);
                --i;
                continue;
            }
            if (CharacterHelper.isEnglishLetter(sentence[i]) || sentence[i] == ' ') {
                sbAtom.append(sentence[i]);
                if (i == maxLen) {
                    table[size][0] = "W";
                    table[size][1] = sbAtom.toString();
                    ++size;
                    sbAtom.setLength(0);
                    break;
                }
                c = sentence[++i];
                while (CharacterHelper.isEnglishLetter(c) || c == ' ') {
                    sbAtom.append(sentence[i]);
                    if (i == maxLen) {
                        table[size][0] = "W";
                        table[size][1] = sbAtom.toString();
                        ++size;
                        sbAtom.setLength(0);
                        break block0;
                    }
                    c = sentence[++i];
                }
                table[size][0] = "W";
                table[size][1] = sbAtom.toString();
                ++size;
                sbAtom.setLength(0);
                --i;
                continue;
            }
            String string = String.valueOf(sentence[i]);
            table[size][1] = string;
            table[size][0] = string;
            ++size;
        }
        return CRFSegment.resizeArray(table, size);
    }

    private static String[][] resizeArray(String[][] array, int size) {
        String[][] nArray = new String[size][];
        System.arraycopy(array, 0, nArray, 0, size);
        return nArray;
    }

    @Override
    public Segment enableNumberQuantifierRecognize(boolean enable) {
        throw new UnsupportedOperationException("\u6682\u4e0d\u652f\u6301");
    }

    private static class CharTable {
        public static char[] CONVERT;

        private CharTable() {
        }

        public static char convert(char c) {
            return CONVERT[c];
        }

        public static char[] convert(char[] charArray) {
            char[] result = new char[charArray.length];
            for (int i = 0; i < charArray.length; ++i) {
                result[i] = CONVERT[charArray[i]];
            }
            return result;
        }

        public static String convert(String charArray) {
            assert (charArray != null);
            char[] result = new char[charArray.length()];
            for (int i = 0; i < charArray.length(); ++i) {
                result[i] = CONVERT[charArray.charAt(i)];
            }
            return new String(result);
        }

        public static void normalization(char[] charArray) {
            assert (charArray != null);
            for (int i = 0; i < charArray.length; ++i) {
                charArray[i] = CONVERT[charArray[i]];
            }
        }

        static {
            long start = System.currentTimeMillis();
            try {
                ObjectInputStream in = new ObjectInputStream(new FileInputStream(HanLP.Config.CharTablePath));
                CONVERT = (char[])in.readObject();
                in.close();
            }
            catch (Exception e) {
                Predefine.logger.severe("\u5b57\u7b26\u6b63\u89c4\u5316\u8868\u52a0\u8f7d\u5931\u8d25\uff0c\u539f\u56e0\u5982\u4e0b\uff1a");
                e.printStackTrace();
                System.exit(-1);
            }
            CharTable.CONVERT[8220] = 8220;
            CharTable.CONVERT[8221] = 8221;
            CharTable.CONVERT[46] = 46;
            CharTable.CONVERT[65294] = 46;
            CharTable.CONVERT[12290] = 65292;
            CharTable.CONVERT[65281] = 65292;
            CharTable.CONVERT[65292] = 65292;
            CharTable.CONVERT[8230] = 65292;
            for (int i = 0; i < CONVERT.length; ++i) {
                if (CONVERT[i] != '\u3002') continue;
                CharTable.CONVERT[i] = 65292;
            }
            Predefine.logger.info("\u5b57\u7b26\u6b63\u89c4\u5316\u8868\u52a0\u8f7d\u6210\u529f\uff1a" + (System.currentTimeMillis() - start) + " ms");
        }
    }
}

